/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.party.AncillaryParty;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.ExecutionDetails;
import cdm.event.common.TradeIdentifier;
import cdm.event.common.meta.ExecutionInstructionMeta;
import cdm.product.collateral.Collateral;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.Product;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface ExecutionInstruction
extends RosettaModelObject {
    public static final ExecutionInstructionMeta metaData = new ExecutionInstructionMeta();

    public ExecutionInstruction build();

    public ExecutionInstructionBuilder toBuilder();

    public List<? extends AncillaryParty> getAncillaryParty();

    public Collateral getCollateral();

    public List<? extends Counterparty> getCounterparty();

    public ExecutionDetails getExecutionDetails();

    public List<? extends Party> getParties();

    public List<? extends PartyRole> getPartyRoles();

    public List<? extends PriceQuantity> getPriceQuantity();

    public Product getProduct();

    public FieldWithMetaDate getTradeDate();

    public List<? extends TradeIdentifier> getTradeIdentifier();

    default public RosettaMetaData<? extends ExecutionInstruction> metaData() {
        return metaData;
    }

    public static ExecutionInstructionBuilder builder() {
        return new ExecutionInstructionBuilderImpl();
    }

    default public Class<? extends ExecutionInstruction> getType() {
        return ExecutionInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("ancillaryParty"), processor, AncillaryParty.class, this.getAncillaryParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateral"), processor, Collateral.class, this.getCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.class, this.getCounterparty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionDetails"), processor, ExecutionDetails.class, this.getExecutionDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("parties"), processor, Party.class, this.getParties(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRoles"), processor, PartyRole.class, this.getPartyRoles(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("product"), processor, Product.class, this.getProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeDate"), processor, FieldWithMetaDate.class, this.getTradeDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
    }

    public static class ExecutionInstructionBuilderImpl
    implements ExecutionInstructionBuilder {
        protected List<AncillaryParty.AncillaryPartyBuilder> ancillaryParty = new ArrayList<AncillaryParty.AncillaryPartyBuilder>();
        protected Collateral.CollateralBuilder collateral;
        protected List<Counterparty.CounterpartyBuilder> counterparty = new ArrayList<Counterparty.CounterpartyBuilder>();
        protected ExecutionDetails.ExecutionDetailsBuilder executionDetails;
        protected List<Party.PartyBuilder> parties = new ArrayList<Party.PartyBuilder>();
        protected List<PartyRole.PartyRoleBuilder> partyRoles = new ArrayList<PartyRole.PartyRoleBuilder>();
        protected List<PriceQuantity.PriceQuantityBuilder> priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
        protected Product.ProductBuilder product;
        protected FieldWithMetaDate.FieldWithMetaDateBuilder tradeDate;
        protected List<TradeIdentifier.TradeIdentifierBuilder> tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();

        @Override
        public List<? extends AncillaryParty.AncillaryPartyBuilder> getAncillaryParty() {
            return this.ancillaryParty;
        }

        @Override
        public AncillaryParty.AncillaryPartyBuilder getOrCreateAncillaryParty(int _index) {
            if (this.ancillaryParty == null) {
                this.ancillaryParty = new ArrayList<AncillaryParty.AncillaryPartyBuilder>();
            }
            return (AncillaryParty.AncillaryPartyBuilder)this.getIndex(this.ancillaryParty, _index, () -> {
                AncillaryParty.AncillaryPartyBuilder newAncillaryParty = AncillaryParty.builder();
                return newAncillaryParty;
            });
        }

        @Override
        public Collateral.CollateralBuilder getCollateral() {
            return this.collateral;
        }

        @Override
        public Collateral.CollateralBuilder getOrCreateCollateral() {
            Collateral.CollateralBuilder result = this.collateral != null ? this.collateral : (this.collateral = Collateral.builder());
            return result;
        }

        @Override
        public List<? extends Counterparty.CounterpartyBuilder> getCounterparty() {
            return this.counterparty;
        }

        @Override
        public Counterparty.CounterpartyBuilder getOrCreateCounterparty(int _index) {
            if (this.counterparty == null) {
                this.counterparty = new ArrayList<Counterparty.CounterpartyBuilder>();
            }
            return (Counterparty.CounterpartyBuilder)this.getIndex(this.counterparty, _index, () -> {
                Counterparty.CounterpartyBuilder newCounterparty = Counterparty.builder();
                return newCounterparty;
            });
        }

        @Override
        public ExecutionDetails.ExecutionDetailsBuilder getExecutionDetails() {
            return this.executionDetails;
        }

        @Override
        public ExecutionDetails.ExecutionDetailsBuilder getOrCreateExecutionDetails() {
            ExecutionDetails.ExecutionDetailsBuilder result = this.executionDetails != null ? this.executionDetails : (this.executionDetails = ExecutionDetails.builder());
            return result;
        }

        @Override
        public List<? extends Party.PartyBuilder> getParties() {
            return this.parties;
        }

        @Override
        public Party.PartyBuilder getOrCreateParties(int _index) {
            if (this.parties == null) {
                this.parties = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.parties, _index, () -> {
                Party.PartyBuilder newParties = Party.builder();
                return newParties;
            });
        }

        @Override
        public List<? extends PartyRole.PartyRoleBuilder> getPartyRoles() {
            return this.partyRoles;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreatePartyRoles(int _index) {
            if (this.partyRoles == null) {
                this.partyRoles = new ArrayList<PartyRole.PartyRoleBuilder>();
            }
            return (PartyRole.PartyRoleBuilder)this.getIndex(this.partyRoles, _index, () -> {
                PartyRole.PartyRoleBuilder newPartyRoles = PartyRole.builder();
                return newPartyRoles;
            });
        }

        @Override
        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int _index) {
            if (this.priceQuantity == null) {
                this.priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
            }
            return (PriceQuantity.PriceQuantityBuilder)this.getIndex(this.priceQuantity, _index, () -> {
                PriceQuantity.PriceQuantityBuilder newPriceQuantity = PriceQuantity.builder();
                return newPriceQuantity;
            });
        }

        @Override
        public Product.ProductBuilder getProduct() {
            return this.product;
        }

        @Override
        public Product.ProductBuilder getOrCreateProduct() {
            Product.ProductBuilder result = this.product != null ? this.product : (this.product = Product.builder());
            return result;
        }

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getTradeDate() {
            return this.tradeDate;
        }

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateTradeDate() {
            FieldWithMetaDate.FieldWithMetaDateBuilder result = this.tradeDate != null ? this.tradeDate : (this.tradeDate = FieldWithMetaDate.builder());
            return result;
        }

        @Override
        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int _index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
            }
            return (TradeIdentifier.TradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, _index, () -> {
                TradeIdentifier.TradeIdentifierBuilder newTradeIdentifier = TradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        public ExecutionInstructionBuilder addAncillaryParty(AncillaryParty ancillaryParty) {
            if (ancillaryParty != null) {
                this.ancillaryParty.add(ancillaryParty.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addAncillaryParty(AncillaryParty ancillaryParty, int _idx) {
            this.getIndex(this.ancillaryParty, _idx, () -> ancillaryParty.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addAncillaryParty(List<? extends AncillaryParty> ancillaryPartys) {
            if (ancillaryPartys != null) {
                for (AncillaryParty ancillaryParty : ancillaryPartys) {
                    this.ancillaryParty.add(ancillaryParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setAncillaryParty(List<? extends AncillaryParty> ancillaryPartys) {
            this.ancillaryParty = ancillaryPartys == null ? new ArrayList<AncillaryParty.AncillaryPartyBuilder>() : (List)ancillaryPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setCollateral(Collateral collateral) {
            this.collateral = collateral == null ? null : collateral.toBuilder();
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addCounterparty(Counterparty counterparty) {
            if (counterparty != null) {
                this.counterparty.add(counterparty.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addCounterparty(Counterparty counterparty, int _idx) {
            this.getIndex(this.counterparty, _idx, () -> counterparty.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addCounterparty(List<? extends Counterparty> counterpartys) {
            if (counterpartys != null) {
                for (Counterparty counterparty : counterpartys) {
                    this.counterparty.add(counterparty.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setCounterparty(List<? extends Counterparty> counterpartys) {
            this.counterparty = counterpartys == null ? new ArrayList<Counterparty.CounterpartyBuilder>() : (List)counterpartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setExecutionDetails(ExecutionDetails executionDetails) {
            this.executionDetails = executionDetails == null ? null : executionDetails.toBuilder();
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addParties(Party parties) {
            if (parties != null) {
                this.parties.add(parties.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addParties(Party parties, int _idx) {
            this.getIndex(this.parties, _idx, () -> parties.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addParties(List<? extends Party> partiess) {
            if (partiess != null) {
                for (Party party : partiess) {
                    this.parties.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setParties(List<? extends Party> partiess) {
            this.parties = partiess == null ? new ArrayList<Party.PartyBuilder>() : (List)partiess.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addPartyRoles(PartyRole partyRoles) {
            if (partyRoles != null) {
                this.partyRoles.add(partyRoles.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addPartyRoles(PartyRole partyRoles, int _idx) {
            this.getIndex(this.partyRoles, _idx, () -> partyRoles.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addPartyRoles(List<? extends PartyRole> partyRoless) {
            if (partyRoless != null) {
                for (PartyRole partyRole : partyRoless) {
                    this.partyRoles.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setPartyRoles(List<? extends PartyRole> partyRoless) {
            this.partyRoles = partyRoless == null ? new ArrayList<PartyRole.PartyRoleBuilder>() : (List)partyRoless.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addPriceQuantity(PriceQuantity priceQuantity) {
            if (priceQuantity != null) {
                this.priceQuantity.add(priceQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addPriceQuantity(PriceQuantity priceQuantity, int _idx) {
            this.getIndex(this.priceQuantity, _idx, () -> priceQuantity.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            if (priceQuantitys != null) {
                for (PriceQuantity priceQuantity : priceQuantitys) {
                    this.priceQuantity.add(priceQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            this.priceQuantity = priceQuantitys == null ? new ArrayList<PriceQuantity.PriceQuantityBuilder>() : (List)priceQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setProduct(Product product) {
            this.product = product == null ? null : product.toBuilder();
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setTradeDate(FieldWithMetaDate tradeDate) {
            this.tradeDate = tradeDate == null ? null : tradeDate.toBuilder();
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setTradeDateValue(Date tradeDate) {
            this.getOrCreateTradeDate().setValue(tradeDate);
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addTradeIdentifier(TradeIdentifier tradeIdentifier) {
            if (tradeIdentifier != null) {
                this.tradeIdentifier.add(tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addTradeIdentifier(TradeIdentifier tradeIdentifier, int _idx) {
            this.getIndex(this.tradeIdentifier, _idx, () -> tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public ExecutionInstructionBuilder addTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (TradeIdentifier tradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(tradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ExecutionInstructionBuilder setTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<TradeIdentifier.TradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ExecutionInstruction build() {
            return new ExecutionInstructionImpl(this);
        }

        @Override
        public ExecutionInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public ExecutionInstructionBuilder prune() {
            this.ancillaryParty = this.ancillaryParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.collateral != null && !this.collateral.prune().hasData()) {
                this.collateral = null;
            }
            this.counterparty = this.counterparty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.executionDetails != null && !this.executionDetails.prune().hasData()) {
                this.executionDetails = null;
            }
            this.parties = this.parties.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyRoles = this.partyRoles.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.priceQuantity = this.priceQuantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.product != null && !this.product.prune().hasData()) {
                this.product = null;
            }
            if (this.tradeDate != null && !this.tradeDate.prune().hasData()) {
                this.tradeDate = null;
            }
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAncillaryParty() != null && this.getAncillaryParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCollateral() != null && this.getCollateral().hasData()) {
                return true;
            }
            if (this.getCounterparty() != null && this.getCounterparty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getExecutionDetails() != null && this.getExecutionDetails().hasData()) {
                return true;
            }
            if (this.getParties() != null && this.getParties().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyRoles() != null && this.getPartyRoles().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPriceQuantity() != null && this.getPriceQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getProduct() != null && this.getProduct().hasData()) {
                return true;
            }
            if (this.getTradeDate() != null) {
                return true;
            }
            return this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ExecutionInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExecutionInstructionBuilder o = (ExecutionInstructionBuilder)other;
            merger.mergeRosetta(this.getAncillaryParty(), o.getAncillaryParty(), this::getOrCreateAncillaryParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateral(), (RosettaModelObjectBuilder)o.getCollateral(), this::setCollateral);
            merger.mergeRosetta(this.getCounterparty(), o.getCounterparty(), this::getOrCreateCounterparty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionDetails(), (RosettaModelObjectBuilder)o.getExecutionDetails(), this::setExecutionDetails);
            merger.mergeRosetta(this.getParties(), o.getParties(), this::getOrCreateParties);
            merger.mergeRosetta(this.getPartyRoles(), o.getPartyRoles(), this::getOrCreatePartyRoles);
            merger.mergeRosetta(this.getPriceQuantity(), o.getPriceQuantity(), this::getOrCreatePriceQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProduct(), (RosettaModelObjectBuilder)o.getProduct(), this::setProduct);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeDate(), (RosettaModelObjectBuilder)o.getTradeDate(), this::setTradeDate);
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExecutionInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.ancillaryParty, _that.getAncillaryParty())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.executionDetails, _that.getExecutionDetails())) {
                return false;
            }
            if (!ListEquals.listEquals(this.parties, _that.getParties())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRoles, _that.getPartyRoles())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.ancillaryParty != null ? this.ancillaryParty.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            _result = 31 * _result + (this.executionDetails != null ? this.executionDetails.hashCode() : 0);
            _result = 31 * _result + (this.parties != null ? this.parties.hashCode() : 0);
            _result = 31 * _result + (this.partyRoles != null ? this.partyRoles.hashCode() : 0);
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExecutionInstructionBuilder {ancillaryParty=" + this.ancillaryParty + ", collateral=" + this.collateral + ", counterparty=" + this.counterparty + ", executionDetails=" + this.executionDetails + ", parties=" + this.parties + ", partyRoles=" + this.partyRoles + ", priceQuantity=" + this.priceQuantity + ", product=" + this.product + ", tradeDate=" + this.tradeDate + ", tradeIdentifier=" + this.tradeIdentifier + '}';
        }
    }

    public static class ExecutionInstructionImpl
    implements ExecutionInstruction {
        private final List<? extends AncillaryParty> ancillaryParty;
        private final Collateral collateral;
        private final List<? extends Counterparty> counterparty;
        private final ExecutionDetails executionDetails;
        private final List<? extends Party> parties;
        private final List<? extends PartyRole> partyRoles;
        private final List<? extends PriceQuantity> priceQuantity;
        private final Product product;
        private final FieldWithMetaDate tradeDate;
        private final List<? extends TradeIdentifier> tradeIdentifier;

        protected ExecutionInstructionImpl(ExecutionInstructionBuilder builder) {
            this.ancillaryParty = Optional.ofNullable(builder.getAncillaryParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateral = Optional.ofNullable(builder.getCollateral()).map(f -> f.build()).orElse(null);
            this.counterparty = Optional.ofNullable(builder.getCounterparty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.executionDetails = Optional.ofNullable(builder.getExecutionDetails()).map(f -> f.build()).orElse(null);
            this.parties = Optional.ofNullable(builder.getParties()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyRoles = Optional.ofNullable(builder.getPartyRoles()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.priceQuantity = Optional.ofNullable(builder.getPriceQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.product = Optional.ofNullable(builder.getProduct()).map(f -> f.build()).orElse(null);
            this.tradeDate = Optional.ofNullable(builder.getTradeDate()).map(f -> f.build()).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public List<? extends AncillaryParty> getAncillaryParty() {
            return this.ancillaryParty;
        }

        @Override
        public Collateral getCollateral() {
            return this.collateral;
        }

        @Override
        public List<? extends Counterparty> getCounterparty() {
            return this.counterparty;
        }

        @Override
        public ExecutionDetails getExecutionDetails() {
            return this.executionDetails;
        }

        @Override
        public List<? extends Party> getParties() {
            return this.parties;
        }

        @Override
        public List<? extends PartyRole> getPartyRoles() {
            return this.partyRoles;
        }

        @Override
        public List<? extends PriceQuantity> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        public Product getProduct() {
            return this.product;
        }

        @Override
        public FieldWithMetaDate getTradeDate() {
            return this.tradeDate;
        }

        @Override
        public List<? extends TradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public ExecutionInstruction build() {
            return this;
        }

        @Override
        public ExecutionInstructionBuilder toBuilder() {
            ExecutionInstructionBuilder builder = ExecutionInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExecutionInstructionBuilder builder) {
            Optional.ofNullable(this.getAncillaryParty()).ifPresent(builder::setAncillaryParty);
            Optional.ofNullable(this.getCollateral()).ifPresent(builder::setCollateral);
            Optional.ofNullable(this.getCounterparty()).ifPresent(builder::setCounterparty);
            Optional.ofNullable(this.getExecutionDetails()).ifPresent(builder::setExecutionDetails);
            Optional.ofNullable(this.getParties()).ifPresent(builder::setParties);
            Optional.ofNullable(this.getPartyRoles()).ifPresent(builder::setPartyRoles);
            Optional.ofNullable(this.getPriceQuantity()).ifPresent(builder::setPriceQuantity);
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProduct);
            Optional.ofNullable(this.getTradeDate()).ifPresent(builder::setTradeDate);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExecutionInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.ancillaryParty, _that.getAncillaryParty())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.executionDetails, _that.getExecutionDetails())) {
                return false;
            }
            if (!ListEquals.listEquals(this.parties, _that.getParties())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRoles, _that.getPartyRoles())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!Objects.equals(this.tradeDate, _that.getTradeDate())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.ancillaryParty != null ? this.ancillaryParty.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            _result = 31 * _result + (this.executionDetails != null ? this.executionDetails.hashCode() : 0);
            _result = 31 * _result + (this.parties != null ? this.parties.hashCode() : 0);
            _result = 31 * _result + (this.partyRoles != null ? this.partyRoles.hashCode() : 0);
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.tradeDate != null ? this.tradeDate.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExecutionInstruction {ancillaryParty=" + this.ancillaryParty + ", collateral=" + this.collateral + ", counterparty=" + this.counterparty + ", executionDetails=" + this.executionDetails + ", parties=" + this.parties + ", partyRoles=" + this.partyRoles + ", priceQuantity=" + this.priceQuantity + ", product=" + this.product + ", tradeDate=" + this.tradeDate + ", tradeIdentifier=" + this.tradeIdentifier + '}';
        }
    }

    public static interface ExecutionInstructionBuilder
    extends ExecutionInstruction,
    RosettaModelObjectBuilder {
        public AncillaryParty.AncillaryPartyBuilder getOrCreateAncillaryParty(int var1);

        public List<? extends AncillaryParty.AncillaryPartyBuilder> getAncillaryParty();

        public Collateral.CollateralBuilder getOrCreateCollateral();

        @Override
        public Collateral.CollateralBuilder getCollateral();

        public Counterparty.CounterpartyBuilder getOrCreateCounterparty(int var1);

        public List<? extends Counterparty.CounterpartyBuilder> getCounterparty();

        public ExecutionDetails.ExecutionDetailsBuilder getOrCreateExecutionDetails();

        @Override
        public ExecutionDetails.ExecutionDetailsBuilder getExecutionDetails();

        public Party.PartyBuilder getOrCreateParties(int var1);

        public List<? extends Party.PartyBuilder> getParties();

        public PartyRole.PartyRoleBuilder getOrCreatePartyRoles(int var1);

        public List<? extends PartyRole.PartyRoleBuilder> getPartyRoles();

        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int var1);

        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity();

        public Product.ProductBuilder getOrCreateProduct();

        @Override
        public Product.ProductBuilder getProduct();

        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateTradeDate();

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getTradeDate();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier();

        public ExecutionInstructionBuilder addAncillaryParty(AncillaryParty var1);

        public ExecutionInstructionBuilder addAncillaryParty(AncillaryParty var1, int var2);

        public ExecutionInstructionBuilder addAncillaryParty(List<? extends AncillaryParty> var1);

        public ExecutionInstructionBuilder setAncillaryParty(List<? extends AncillaryParty> var1);

        public ExecutionInstructionBuilder setCollateral(Collateral var1);

        public ExecutionInstructionBuilder addCounterparty(Counterparty var1);

        public ExecutionInstructionBuilder addCounterparty(Counterparty var1, int var2);

        public ExecutionInstructionBuilder addCounterparty(List<? extends Counterparty> var1);

        public ExecutionInstructionBuilder setCounterparty(List<? extends Counterparty> var1);

        public ExecutionInstructionBuilder setExecutionDetails(ExecutionDetails var1);

        public ExecutionInstructionBuilder addParties(Party var1);

        public ExecutionInstructionBuilder addParties(Party var1, int var2);

        public ExecutionInstructionBuilder addParties(List<? extends Party> var1);

        public ExecutionInstructionBuilder setParties(List<? extends Party> var1);

        public ExecutionInstructionBuilder addPartyRoles(PartyRole var1);

        public ExecutionInstructionBuilder addPartyRoles(PartyRole var1, int var2);

        public ExecutionInstructionBuilder addPartyRoles(List<? extends PartyRole> var1);

        public ExecutionInstructionBuilder setPartyRoles(List<? extends PartyRole> var1);

        public ExecutionInstructionBuilder addPriceQuantity(PriceQuantity var1);

        public ExecutionInstructionBuilder addPriceQuantity(PriceQuantity var1, int var2);

        public ExecutionInstructionBuilder addPriceQuantity(List<? extends PriceQuantity> var1);

        public ExecutionInstructionBuilder setPriceQuantity(List<? extends PriceQuantity> var1);

        public ExecutionInstructionBuilder setProduct(Product var1);

        public ExecutionInstructionBuilder setTradeDate(FieldWithMetaDate var1);

        public ExecutionInstructionBuilder setTradeDateValue(Date var1);

        public ExecutionInstructionBuilder addTradeIdentifier(TradeIdentifier var1);

        public ExecutionInstructionBuilder addTradeIdentifier(TradeIdentifier var1, int var2);

        public ExecutionInstructionBuilder addTradeIdentifier(List<? extends TradeIdentifier> var1);

        public ExecutionInstructionBuilder setTradeIdentifier(List<? extends TradeIdentifier> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("ancillaryParty"), processor, AncillaryParty.AncillaryPartyBuilder.class, this.getAncillaryParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateral"), processor, Collateral.CollateralBuilder.class, this.getCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.CounterpartyBuilder.class, this.getCounterparty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionDetails"), processor, ExecutionDetails.ExecutionDetailsBuilder.class, this.getExecutionDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("parties"), processor, Party.PartyBuilder.class, this.getParties(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRoles"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRoles(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.PriceQuantityBuilder.class, this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("product"), processor, Product.ProductBuilder.class, this.getProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeDate"), processor, FieldWithMetaDate.FieldWithMetaDateBuilder.class, this.getTradeDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        }

        public ExecutionInstructionBuilder prune();
    }
}

