/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.base.staticdata.party.LegalEntity;
import cdm.event.common.ExecutionTypeEnum;
import cdm.event.common.meta.ExecutionDetailsMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ExecutionDetails
extends RosettaModelObject,
GlobalKey {
    public static final ExecutionDetailsMeta metaData = new ExecutionDetailsMeta();

    public ExecutionDetails build();

    public ExecutionDetailsBuilder toBuilder();

    public ExecutionTypeEnum getExecutionType();

    public LegalEntity getExecutionVenue();

    public MetaFields getMeta();

    public IdentifiedList getPackageReference();

    default public RosettaMetaData<? extends ExecutionDetails> metaData() {
        return metaData;
    }

    public static ExecutionDetailsBuilder builder() {
        return new ExecutionDetailsBuilderImpl();
    }

    default public Class<? extends ExecutionDetails> getType() {
        return ExecutionDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("executionType"), ExecutionTypeEnum.class, (Object)this.getExecutionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionVenue"), processor, LegalEntity.class, this.getExecutionVenue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageReference"), processor, IdentifiedList.class, this.getPackageReference(), new AttributeMeta[0]);
    }

    public static class ExecutionDetailsBuilderImpl
    implements ExecutionDetailsBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected ExecutionTypeEnum executionType;
        protected LegalEntity.LegalEntityBuilder executionVenue;
        protected MetaFields.MetaFieldsBuilder meta;
        protected IdentifiedList.IdentifiedListBuilder packageReference;

        @Override
        public ExecutionTypeEnum getExecutionType() {
            return this.executionType;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getExecutionVenue() {
            return this.executionVenue;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateExecutionVenue() {
            LegalEntity.LegalEntityBuilder result = this.executionVenue != null ? this.executionVenue : (this.executionVenue = LegalEntity.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public IdentifiedList.IdentifiedListBuilder getPackageReference() {
            return this.packageReference;
        }

        @Override
        public IdentifiedList.IdentifiedListBuilder getOrCreatePackageReference() {
            IdentifiedList.IdentifiedListBuilder result = this.packageReference != null ? this.packageReference : (this.packageReference = IdentifiedList.builder());
            return result;
        }

        @Override
        public ExecutionDetailsBuilder setExecutionType(ExecutionTypeEnum executionType) {
            this.executionType = executionType == null ? null : executionType;
            return this;
        }

        @Override
        public ExecutionDetailsBuilder setExecutionVenue(LegalEntity executionVenue) {
            this.executionVenue = executionVenue == null ? null : executionVenue.toBuilder();
            return this;
        }

        @Override
        public ExecutionDetailsBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public ExecutionDetailsBuilder setPackageReference(IdentifiedList packageReference) {
            this.packageReference = packageReference == null ? null : packageReference.toBuilder();
            return this;
        }

        @Override
        public ExecutionDetails build() {
            return new ExecutionDetailsImpl(this);
        }

        @Override
        public ExecutionDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public ExecutionDetailsBuilder prune() {
            if (this.executionVenue != null && !this.executionVenue.prune().hasData()) {
                this.executionVenue = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.packageReference != null && !this.packageReference.prune().hasData()) {
                this.packageReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getExecutionType() != null) {
                return true;
            }
            if (this.getExecutionVenue() != null && this.getExecutionVenue().hasData()) {
                return true;
            }
            return this.getPackageReference() != null && this.getPackageReference().hasData();
        }

        public ExecutionDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExecutionDetailsBuilder o = (ExecutionDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionVenue(), (RosettaModelObjectBuilder)o.getExecutionVenue(), this::setExecutionVenue);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageReference(), (RosettaModelObjectBuilder)o.getPackageReference(), this::setPackageReference);
            merger.mergeBasic((Object)this.getExecutionType(), (Object)o.getExecutionType(), this::setExecutionType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExecutionDetails _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.executionType, (Object)_that.getExecutionType())) {
                return false;
            }
            if (!Objects.equals(this.executionVenue, _that.getExecutionVenue())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            return Objects.equals(this.packageReference, _that.getPackageReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.executionType != null ? ((Object)((Object)this.executionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.executionVenue != null ? this.executionVenue.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.packageReference != null ? this.packageReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExecutionDetailsBuilder {executionType=" + (Object)((Object)this.executionType) + ", executionVenue=" + this.executionVenue + ", meta=" + this.meta + ", packageReference=" + this.packageReference + '}';
        }
    }

    public static class ExecutionDetailsImpl
    implements ExecutionDetails {
        private final ExecutionTypeEnum executionType;
        private final LegalEntity executionVenue;
        private final MetaFields meta;
        private final IdentifiedList packageReference;

        protected ExecutionDetailsImpl(ExecutionDetailsBuilder builder) {
            this.executionType = builder.getExecutionType();
            this.executionVenue = Optional.ofNullable(builder.getExecutionVenue()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.packageReference = Optional.ofNullable(builder.getPackageReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        public ExecutionTypeEnum getExecutionType() {
            return this.executionType;
        }

        @Override
        public LegalEntity getExecutionVenue() {
            return this.executionVenue;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public IdentifiedList getPackageReference() {
            return this.packageReference;
        }

        @Override
        public ExecutionDetails build() {
            return this;
        }

        @Override
        public ExecutionDetailsBuilder toBuilder() {
            ExecutionDetailsBuilder builder = ExecutionDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExecutionDetailsBuilder builder) {
            Optional.ofNullable(this.getExecutionType()).ifPresent(builder::setExecutionType);
            Optional.ofNullable(this.getExecutionVenue()).ifPresent(builder::setExecutionVenue);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPackageReference()).ifPresent(builder::setPackageReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExecutionDetails _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.executionType, (Object)_that.getExecutionType())) {
                return false;
            }
            if (!Objects.equals(this.executionVenue, _that.getExecutionVenue())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            return Objects.equals(this.packageReference, _that.getPackageReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.executionType != null ? ((Object)((Object)this.executionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.executionVenue != null ? this.executionVenue.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.packageReference != null ? this.packageReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExecutionDetails {executionType=" + (Object)((Object)this.executionType) + ", executionVenue=" + this.executionVenue + ", meta=" + this.meta + ", packageReference=" + this.packageReference + '}';
        }
    }

    public static interface ExecutionDetailsBuilder
    extends ExecutionDetails,
    RosettaModelObjectBuilder {
        public LegalEntity.LegalEntityBuilder getOrCreateExecutionVenue();

        @Override
        public LegalEntity.LegalEntityBuilder getExecutionVenue();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public IdentifiedList.IdentifiedListBuilder getOrCreatePackageReference();

        @Override
        public IdentifiedList.IdentifiedListBuilder getPackageReference();

        public ExecutionDetailsBuilder setExecutionType(ExecutionTypeEnum var1);

        public ExecutionDetailsBuilder setExecutionVenue(LegalEntity var1);

        public ExecutionDetailsBuilder setMeta(MetaFields var1);

        public ExecutionDetailsBuilder setPackageReference(IdentifiedList var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("executionType"), ExecutionTypeEnum.class, (Object)this.getExecutionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionVenue"), processor, LegalEntity.LegalEntityBuilder.class, this.getExecutionVenue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageReference"), processor, IdentifiedList.IdentifiedListBuilder.class, this.getPackageReference(), new AttributeMeta[0]);
        }

        public ExecutionDetailsBuilder prune();
    }
}

