/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum EventIntentEnum {
    ALLOCATION,
    CASH_FLOW,
    CLEARING,
    COMPRESSION,
    CONTRACT_FORMATION,
    CONTRACT_TERMS_AMENDMENT,
    CORPORATE_ACTION_ADJUSTMENT,
    CREDIT_EVENT,
    DECREASE,
    EARLY_TERMINATION_PROVISION,
    INCREASE,
    INDEX_TRANSITION,
    NOTIONAL_RESET,
    NOTIONAL_STEP,
    NOVATION,
    OBSERVATION_RECORD,
    OPTION_EXERCISE,
    OPTIONAL_EXTENSION,
    OPTIONAL_CANCELLATION,
    PRINCIPAL_EXCHANGE,
    REALLOCATION,
    REPURCHASE;

    private static Map<String, EventIntentEnum> values;
    private final String displayName;

    private EventIntentEnum() {
        this(null);
    }

    private EventIntentEnum(String displayName) {
        this.displayName = displayName;
    }

    public static EventIntentEnum fromDisplayName(String name) {
        EventIntentEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, EventIntentEnum> map = new ConcurrentHashMap<String, EventIntentEnum>();
        for (EventIntentEnum instance : EventIntentEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

