/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.CreditEventTypeEnum;
import cdm.event.common.meta.CreditEventMeta;
import cdm.legaldocumentation.common.Resource;
import cdm.observable.asset.Price;
import cdm.product.asset.ReferenceInformation;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CreditEvent
extends RosettaModelObject {
    public static final CreditEventMeta metaData = new CreditEventMeta();

    public CreditEvent build();

    public CreditEventBuilder toBuilder();

    public Date getAuctionDate();

    public CreditEventTypeEnum getCreditEventType();

    public Date getEventDeterminationDate();

    public Price getFinalPrice();

    public List<? extends Resource> getPubliclyAvailableInformation();

    public BigDecimal getRecoveryPercent();

    public ReferenceInformation getReferenceInformation();

    default public RosettaMetaData<? extends CreditEvent> metaData() {
        return metaData;
    }

    public static CreditEventBuilder builder() {
        return new CreditEventBuilderImpl();
    }

    default public Class<? extends CreditEvent> getType() {
        return CreditEvent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("auctionDate"), Date.class, (Object)this.getAuctionDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creditEventType"), CreditEventTypeEnum.class, (Object)this.getCreditEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDeterminationDate"), Date.class, (Object)this.getEventDeterminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("recoveryPercent"), BigDecimal.class, (Object)this.getRecoveryPercent(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalPrice"), processor, Price.class, this.getFinalPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, Resource.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceInformation"), processor, ReferenceInformation.class, this.getReferenceInformation(), new AttributeMeta[0]);
    }

    public static class CreditEventBuilderImpl
    implements CreditEventBuilder {
        protected Date auctionDate;
        protected CreditEventTypeEnum creditEventType;
        protected Date eventDeterminationDate;
        protected Price.PriceBuilder finalPrice;
        protected List<Resource.ResourceBuilder> publiclyAvailableInformation = new ArrayList<Resource.ResourceBuilder>();
        protected BigDecimal recoveryPercent;
        protected ReferenceInformation.ReferenceInformationBuilder referenceInformation;

        @Override
        public Date getAuctionDate() {
            return this.auctionDate;
        }

        @Override
        public CreditEventTypeEnum getCreditEventType() {
            return this.creditEventType;
        }

        @Override
        public Date getEventDeterminationDate() {
            return this.eventDeterminationDate;
        }

        @Override
        public Price.PriceBuilder getFinalPrice() {
            return this.finalPrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateFinalPrice() {
            Price.PriceBuilder result = this.finalPrice != null ? this.finalPrice : (this.finalPrice = Price.builder());
            return result;
        }

        @Override
        public List<? extends Resource.ResourceBuilder> getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        public Resource.ResourceBuilder getOrCreatePubliclyAvailableInformation(int _index) {
            if (this.publiclyAvailableInformation == null) {
                this.publiclyAvailableInformation = new ArrayList<Resource.ResourceBuilder>();
            }
            return (Resource.ResourceBuilder)this.getIndex(this.publiclyAvailableInformation, _index, () -> {
                Resource.ResourceBuilder newPubliclyAvailableInformation = Resource.builder();
                return newPubliclyAvailableInformation;
            });
        }

        @Override
        public BigDecimal getRecoveryPercent() {
            return this.recoveryPercent;
        }

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getReferenceInformation() {
            return this.referenceInformation;
        }

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getOrCreateReferenceInformation() {
            ReferenceInformation.ReferenceInformationBuilder result = this.referenceInformation != null ? this.referenceInformation : (this.referenceInformation = ReferenceInformation.builder());
            return result;
        }

        @Override
        public CreditEventBuilder setAuctionDate(Date auctionDate) {
            this.auctionDate = auctionDate == null ? null : auctionDate;
            return this;
        }

        @Override
        public CreditEventBuilder setCreditEventType(CreditEventTypeEnum creditEventType) {
            this.creditEventType = creditEventType == null ? null : creditEventType;
            return this;
        }

        @Override
        public CreditEventBuilder setEventDeterminationDate(Date eventDeterminationDate) {
            this.eventDeterminationDate = eventDeterminationDate == null ? null : eventDeterminationDate;
            return this;
        }

        @Override
        public CreditEventBuilder setFinalPrice(Price finalPrice) {
            this.finalPrice = finalPrice == null ? null : finalPrice.toBuilder();
            return this;
        }

        @Override
        public CreditEventBuilder addPubliclyAvailableInformation(Resource publiclyAvailableInformation) {
            if (publiclyAvailableInformation != null) {
                this.publiclyAvailableInformation.add(publiclyAvailableInformation.toBuilder());
            }
            return this;
        }

        @Override
        public CreditEventBuilder addPubliclyAvailableInformation(Resource publiclyAvailableInformation, int _idx) {
            this.getIndex(this.publiclyAvailableInformation, _idx, () -> publiclyAvailableInformation.toBuilder());
            return this;
        }

        @Override
        public CreditEventBuilder addPubliclyAvailableInformation(List<? extends Resource> publiclyAvailableInformations) {
            if (publiclyAvailableInformations != null) {
                for (Resource resource : publiclyAvailableInformations) {
                    this.publiclyAvailableInformation.add(resource.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CreditEventBuilder setPubliclyAvailableInformation(List<? extends Resource> publiclyAvailableInformations) {
            this.publiclyAvailableInformation = publiclyAvailableInformations == null ? new ArrayList<Resource.ResourceBuilder>() : (List)publiclyAvailableInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CreditEventBuilder setRecoveryPercent(BigDecimal recoveryPercent) {
            this.recoveryPercent = recoveryPercent == null ? null : recoveryPercent;
            return this;
        }

        @Override
        public CreditEventBuilder setReferenceInformation(ReferenceInformation referenceInformation) {
            this.referenceInformation = referenceInformation == null ? null : referenceInformation.toBuilder();
            return this;
        }

        @Override
        public CreditEvent build() {
            return new CreditEventImpl(this);
        }

        @Override
        public CreditEventBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditEventBuilder prune() {
            if (this.finalPrice != null && !this.finalPrice.prune().hasData()) {
                this.finalPrice = null;
            }
            this.publiclyAvailableInformation = this.publiclyAvailableInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.referenceInformation != null && !this.referenceInformation.prune().hasData()) {
                this.referenceInformation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAuctionDate() != null) {
                return true;
            }
            if (this.getCreditEventType() != null) {
                return true;
            }
            if (this.getEventDeterminationDate() != null) {
                return true;
            }
            if (this.getFinalPrice() != null && this.getFinalPrice().hasData()) {
                return true;
            }
            if (this.getPubliclyAvailableInformation() != null && this.getPubliclyAvailableInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRecoveryPercent() != null) {
                return true;
            }
            return this.getReferenceInformation() != null && this.getReferenceInformation().hasData();
        }

        public CreditEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditEventBuilder o = (CreditEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFinalPrice(), (RosettaModelObjectBuilder)o.getFinalPrice(), this::setFinalPrice);
            merger.mergeRosetta(this.getPubliclyAvailableInformation(), o.getPubliclyAvailableInformation(), this::getOrCreatePubliclyAvailableInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceInformation(), (RosettaModelObjectBuilder)o.getReferenceInformation(), this::setReferenceInformation);
            merger.mergeBasic((Object)this.getAuctionDate(), (Object)o.getAuctionDate(), this::setAuctionDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCreditEventType(), (Object)o.getCreditEventType(), this::setCreditEventType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventDeterminationDate(), (Object)o.getEventDeterminationDate(), this::setEventDeterminationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRecoveryPercent(), (Object)o.getRecoveryPercent(), this::setRecoveryPercent, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEvent _that = this.getType().cast(o);
            if (!Objects.equals(this.auctionDate, _that.getAuctionDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.creditEventType, (Object)_that.getCreditEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventDeterminationDate, _that.getEventDeterminationDate())) {
                return false;
            }
            if (!Objects.equals(this.finalPrice, _that.getFinalPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation())) {
                return false;
            }
            if (!Objects.equals(this.recoveryPercent, _that.getRecoveryPercent())) {
                return false;
            }
            return Objects.equals(this.referenceInformation, _that.getReferenceInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.auctionDate != null ? this.auctionDate.hashCode() : 0);
            _result = 31 * _result + (this.creditEventType != null ? ((Object)((Object)this.creditEventType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDeterminationDate != null ? this.eventDeterminationDate.hashCode() : 0);
            _result = 31 * _result + (this.finalPrice != null ? this.finalPrice.hashCode() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            _result = 31 * _result + (this.recoveryPercent != null ? this.recoveryPercent.hashCode() : 0);
            _result = 31 * _result + (this.referenceInformation != null ? this.referenceInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEventBuilder {auctionDate=" + this.auctionDate + ", creditEventType=" + (Object)((Object)this.creditEventType) + ", eventDeterminationDate=" + this.eventDeterminationDate + ", finalPrice=" + this.finalPrice + ", publiclyAvailableInformation=" + this.publiclyAvailableInformation + ", recoveryPercent=" + this.recoveryPercent + ", referenceInformation=" + this.referenceInformation + '}';
        }
    }

    public static class CreditEventImpl
    implements CreditEvent {
        private final Date auctionDate;
        private final CreditEventTypeEnum creditEventType;
        private final Date eventDeterminationDate;
        private final Price finalPrice;
        private final List<? extends Resource> publiclyAvailableInformation;
        private final BigDecimal recoveryPercent;
        private final ReferenceInformation referenceInformation;

        protected CreditEventImpl(CreditEventBuilder builder) {
            this.auctionDate = builder.getAuctionDate();
            this.creditEventType = builder.getCreditEventType();
            this.eventDeterminationDate = builder.getEventDeterminationDate();
            this.finalPrice = Optional.ofNullable(builder.getFinalPrice()).map(f -> f.build()).orElse(null);
            this.publiclyAvailableInformation = Optional.ofNullable(builder.getPubliclyAvailableInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.recoveryPercent = builder.getRecoveryPercent();
            this.referenceInformation = Optional.ofNullable(builder.getReferenceInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Date getAuctionDate() {
            return this.auctionDate;
        }

        @Override
        public CreditEventTypeEnum getCreditEventType() {
            return this.creditEventType;
        }

        @Override
        public Date getEventDeterminationDate() {
            return this.eventDeterminationDate;
        }

        @Override
        public Price getFinalPrice() {
            return this.finalPrice;
        }

        @Override
        public List<? extends Resource> getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        public BigDecimal getRecoveryPercent() {
            return this.recoveryPercent;
        }

        @Override
        public ReferenceInformation getReferenceInformation() {
            return this.referenceInformation;
        }

        @Override
        public CreditEvent build() {
            return this;
        }

        @Override
        public CreditEventBuilder toBuilder() {
            CreditEventBuilder builder = CreditEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditEventBuilder builder) {
            Optional.ofNullable(this.getAuctionDate()).ifPresent(builder::setAuctionDate);
            Optional.ofNullable(this.getCreditEventType()).ifPresent(builder::setCreditEventType);
            Optional.ofNullable(this.getEventDeterminationDate()).ifPresent(builder::setEventDeterminationDate);
            Optional.ofNullable(this.getFinalPrice()).ifPresent(builder::setFinalPrice);
            Optional.ofNullable(this.getPubliclyAvailableInformation()).ifPresent(builder::setPubliclyAvailableInformation);
            Optional.ofNullable(this.getRecoveryPercent()).ifPresent(builder::setRecoveryPercent);
            Optional.ofNullable(this.getReferenceInformation()).ifPresent(builder::setReferenceInformation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEvent _that = this.getType().cast(o);
            if (!Objects.equals(this.auctionDate, _that.getAuctionDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.creditEventType, (Object)_that.getCreditEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventDeterminationDate, _that.getEventDeterminationDate())) {
                return false;
            }
            if (!Objects.equals(this.finalPrice, _that.getFinalPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation())) {
                return false;
            }
            if (!Objects.equals(this.recoveryPercent, _that.getRecoveryPercent())) {
                return false;
            }
            return Objects.equals(this.referenceInformation, _that.getReferenceInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.auctionDate != null ? this.auctionDate.hashCode() : 0);
            _result = 31 * _result + (this.creditEventType != null ? ((Object)((Object)this.creditEventType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDeterminationDate != null ? this.eventDeterminationDate.hashCode() : 0);
            _result = 31 * _result + (this.finalPrice != null ? this.finalPrice.hashCode() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            _result = 31 * _result + (this.recoveryPercent != null ? this.recoveryPercent.hashCode() : 0);
            _result = 31 * _result + (this.referenceInformation != null ? this.referenceInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEvent {auctionDate=" + this.auctionDate + ", creditEventType=" + (Object)((Object)this.creditEventType) + ", eventDeterminationDate=" + this.eventDeterminationDate + ", finalPrice=" + this.finalPrice + ", publiclyAvailableInformation=" + this.publiclyAvailableInformation + ", recoveryPercent=" + this.recoveryPercent + ", referenceInformation=" + this.referenceInformation + '}';
        }
    }

    public static interface CreditEventBuilder
    extends CreditEvent,
    RosettaModelObjectBuilder {
        public Price.PriceBuilder getOrCreateFinalPrice();

        @Override
        public Price.PriceBuilder getFinalPrice();

        public Resource.ResourceBuilder getOrCreatePubliclyAvailableInformation(int var1);

        public List<? extends Resource.ResourceBuilder> getPubliclyAvailableInformation();

        public ReferenceInformation.ReferenceInformationBuilder getOrCreateReferenceInformation();

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getReferenceInformation();

        public CreditEventBuilder setAuctionDate(Date var1);

        public CreditEventBuilder setCreditEventType(CreditEventTypeEnum var1);

        public CreditEventBuilder setEventDeterminationDate(Date var1);

        public CreditEventBuilder setFinalPrice(Price var1);

        public CreditEventBuilder addPubliclyAvailableInformation(Resource var1);

        public CreditEventBuilder addPubliclyAvailableInformation(Resource var1, int var2);

        public CreditEventBuilder addPubliclyAvailableInformation(List<? extends Resource> var1);

        public CreditEventBuilder setPubliclyAvailableInformation(List<? extends Resource> var1);

        public CreditEventBuilder setRecoveryPercent(BigDecimal var1);

        public CreditEventBuilder setReferenceInformation(ReferenceInformation var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("auctionDate"), Date.class, (Object)this.getAuctionDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creditEventType"), CreditEventTypeEnum.class, (Object)this.getCreditEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDeterminationDate"), Date.class, (Object)this.getEventDeterminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("recoveryPercent"), BigDecimal.class, (Object)this.getRecoveryPercent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalPrice"), processor, Price.PriceBuilder.class, this.getFinalPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, Resource.ResourceBuilder.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceInformation"), processor, ReferenceInformation.ReferenceInformationBuilder.class, this.getReferenceInformation(), new AttributeMeta[0]);
        }

        public CreditEventBuilder prune();
    }
}

