/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.CollateralStatusEnum;
import cdm.event.common.TradeState;
import cdm.event.common.meta.CollateralPositionMeta;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.event.position.Position;
import cdm.observable.asset.Money;
import cdm.product.collateral.CollateralTreatment;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.Product;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CollateralPosition
extends Position {
    public static final CollateralPositionMeta metaData = new CollateralPositionMeta();

    @Override
    public CollateralPosition build();

    @Override
    public CollateralPositionBuilder toBuilder();

    public CollateralStatusEnum getCollateralPositionStatus();

    public CollateralTreatment getTreatment();

    default public RosettaMetaData<? extends CollateralPosition> metaData() {
        return metaData;
    }

    public static CollateralPositionBuilder builder() {
        return new CollateralPositionBuilderImpl();
    }

    default public Class<? extends CollateralPosition> getType() {
        return CollateralPosition.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        Position.super.process(path, processor);
        processor.processBasic(path.newSubPath("collateralPositionStatus"), CollateralStatusEnum.class, (Object)this.getCollateralPositionStatus(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("treatment"), processor, CollateralTreatment.class, this.getTreatment(), new AttributeMeta[0]);
    }

    public static class CollateralPositionBuilderImpl
    extends Position.PositionBuilderImpl
    implements CollateralPositionBuilder {
        protected CollateralStatusEnum collateralPositionStatus;
        protected CollateralTreatment.CollateralTreatmentBuilder treatment;

        @Override
        public CollateralStatusEnum getCollateralPositionStatus() {
            return this.collateralPositionStatus;
        }

        @Override
        public CollateralTreatment.CollateralTreatmentBuilder getTreatment() {
            return this.treatment;
        }

        @Override
        public CollateralTreatment.CollateralTreatmentBuilder getOrCreateTreatment() {
            CollateralTreatment.CollateralTreatmentBuilder result = this.treatment != null ? this.treatment : (this.treatment = CollateralTreatment.builder());
            return result;
        }

        @Override
        public CollateralPositionBuilder setCollateralPositionStatus(CollateralStatusEnum collateralPositionStatus) {
            this.collateralPositionStatus = collateralPositionStatus == null ? null : collateralPositionStatus;
            return this;
        }

        @Override
        public CollateralPositionBuilder setTreatment(CollateralTreatment treatment) {
            this.treatment = treatment == null ? null : treatment.toBuilder();
            return this;
        }

        @Override
        public CollateralPositionBuilder setCashBalance(Money cashBalance) {
            this.cashBalance = cashBalance == null ? null : cashBalance.toBuilder();
            return this;
        }

        @Override
        public CollateralPositionBuilder addPriceQuantity(PriceQuantity priceQuantity) {
            if (priceQuantity != null) {
                this.priceQuantity.add(priceQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralPositionBuilder addPriceQuantity(PriceQuantity priceQuantity, int _idx) {
            this.getIndex(this.priceQuantity, _idx, () -> priceQuantity.toBuilder());
            return this;
        }

        @Override
        public CollateralPositionBuilder addPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            if (priceQuantitys != null) {
                for (PriceQuantity priceQuantity : priceQuantitys) {
                    this.priceQuantity.add(priceQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CollateralPositionBuilder setPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            this.priceQuantity = priceQuantitys == null ? new ArrayList() : (List)priceQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralPositionBuilder setProduct(Product product) {
            this.product = product == null ? null : product.toBuilder();
            return this;
        }

        @Override
        public CollateralPositionBuilder setTradeReference(ReferenceWithMetaTradeState tradeReference) {
            this.tradeReference = tradeReference == null ? null : tradeReference.toBuilder();
            return this;
        }

        @Override
        public CollateralPositionBuilder setTradeReferenceValue(TradeState tradeReference) {
            this.getOrCreateTradeReference().setValue(tradeReference);
            return this;
        }

        @Override
        public CollateralPosition build() {
            return new CollateralPositionImpl(this);
        }

        @Override
        public CollateralPositionBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralPositionBuilder prune() {
            super.prune();
            if (this.treatment != null && !this.treatment.prune().hasData()) {
                this.treatment = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCollateralPositionStatus() != null) {
                return true;
            }
            return this.getTreatment() != null && this.getTreatment().hasData();
        }

        @Override
        public CollateralPositionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CollateralPositionBuilder o = (CollateralPositionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTreatment(), (RosettaModelObjectBuilder)o.getTreatment(), this::setTreatment);
            merger.mergeBasic((Object)this.getCollateralPositionStatus(), (Object)o.getCollateralPositionStatus(), this::setCollateralPositionStatus, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollateralPosition _that = (CollateralPosition)this.getType().cast(o);
            if (!Objects.equals((Object)this.collateralPositionStatus, (Object)_that.getCollateralPositionStatus())) {
                return false;
            }
            return Objects.equals(this.treatment, _that.getTreatment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.collateralPositionStatus != null ? ((Object)((Object)this.collateralPositionStatus)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.treatment != null ? this.treatment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CollateralPositionBuilder {collateralPositionStatus=" + (Object)((Object)this.collateralPositionStatus) + ", treatment=" + this.treatment + '}' + " " + super.toString();
        }
    }

    public static class CollateralPositionImpl
    extends Position.PositionImpl
    implements CollateralPosition {
        private final CollateralStatusEnum collateralPositionStatus;
        private final CollateralTreatment treatment;

        protected CollateralPositionImpl(CollateralPositionBuilder builder) {
            super(builder);
            this.collateralPositionStatus = builder.getCollateralPositionStatus();
            this.treatment = Optional.ofNullable(builder.getTreatment()).map(f -> f.build()).orElse(null);
        }

        @Override
        public CollateralStatusEnum getCollateralPositionStatus() {
            return this.collateralPositionStatus;
        }

        @Override
        public CollateralTreatment getTreatment() {
            return this.treatment;
        }

        @Override
        public CollateralPosition build() {
            return this;
        }

        @Override
        public CollateralPositionBuilder toBuilder() {
            CollateralPositionBuilder builder = CollateralPosition.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralPositionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCollateralPositionStatus()).ifPresent(builder::setCollateralPositionStatus);
            Optional.ofNullable(this.getTreatment()).ifPresent(builder::setTreatment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollateralPosition _that = (CollateralPosition)this.getType().cast(o);
            if (!Objects.equals((Object)this.collateralPositionStatus, (Object)_that.getCollateralPositionStatus())) {
                return false;
            }
            return Objects.equals(this.treatment, _that.getTreatment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.collateralPositionStatus != null ? ((Object)((Object)this.collateralPositionStatus)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.treatment != null ? this.treatment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CollateralPosition {collateralPositionStatus=" + (Object)((Object)this.collateralPositionStatus) + ", treatment=" + this.treatment + '}' + " " + super.toString();
        }
    }

    public static interface CollateralPositionBuilder
    extends CollateralPosition,
    Position.PositionBuilder,
    RosettaModelObjectBuilder {
        public CollateralTreatment.CollateralTreatmentBuilder getOrCreateTreatment();

        @Override
        public CollateralTreatment.CollateralTreatmentBuilder getTreatment();

        public CollateralPositionBuilder setCollateralPositionStatus(CollateralStatusEnum var1);

        public CollateralPositionBuilder setTreatment(CollateralTreatment var1);

        @Override
        public CollateralPositionBuilder setCashBalance(Money var1);

        @Override
        public CollateralPositionBuilder addPriceQuantity(PriceQuantity var1);

        @Override
        public CollateralPositionBuilder addPriceQuantity(PriceQuantity var1, int var2);

        @Override
        public CollateralPositionBuilder addPriceQuantity(List<? extends PriceQuantity> var1);

        @Override
        public CollateralPositionBuilder setPriceQuantity(List<? extends PriceQuantity> var1);

        @Override
        public CollateralPositionBuilder setProduct(Product var1);

        @Override
        public CollateralPositionBuilder setTradeReference(ReferenceWithMetaTradeState var1);

        @Override
        public CollateralPositionBuilder setTradeReferenceValue(TradeState var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            Position.PositionBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("collateralPositionStatus"), CollateralStatusEnum.class, (Object)this.getCollateralPositionStatus(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("treatment"), processor, CollateralTreatment.CollateralTreatmentBuilder.class, this.getTreatment(), new AttributeMeta[0]);
        }

        @Override
        public CollateralPositionBuilder prune();
    }
}

