/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.event.common.CollateralBalance;
import cdm.event.common.CollateralPosition;
import cdm.event.common.meta.CollateralPortfolioMeta;
import cdm.legaldocumentation.common.LegalAgreement;
import cdm.legaldocumentation.common.metafields.ReferenceWithMetaLegalAgreement;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CollateralPortfolio
extends RosettaModelObject,
GlobalKey {
    public static final CollateralPortfolioMeta metaData = new CollateralPortfolioMeta();

    public CollateralPortfolio build();

    public CollateralPortfolioBuilder toBuilder();

    public List<? extends CollateralBalance> getCollateralBalance();

    public List<? extends CollateralPosition> getCollateralPosition();

    public ReferenceWithMetaLegalAgreement getLegalAgreement();

    public MetaFields getMeta();

    public Identifier getPortfolioIdentifier();

    default public RosettaMetaData<? extends CollateralPortfolio> metaData() {
        return metaData;
    }

    public static CollateralPortfolioBuilder builder() {
        return new CollateralPortfolioBuilderImpl();
    }

    default public Class<? extends CollateralPortfolio> getType() {
        return CollateralPortfolio.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("collateralBalance"), processor, CollateralBalance.class, this.getCollateralBalance(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralPosition"), processor, CollateralPosition.class, this.getCollateralPosition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalAgreement"), processor, ReferenceWithMetaLegalAgreement.class, this.getLegalAgreement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioIdentifier"), processor, Identifier.class, this.getPortfolioIdentifier(), new AttributeMeta[0]);
    }

    public static class CollateralPortfolioBuilderImpl
    implements CollateralPortfolioBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected List<CollateralBalance.CollateralBalanceBuilder> collateralBalance = new ArrayList<CollateralBalance.CollateralBalanceBuilder>();
        protected List<CollateralPosition.CollateralPositionBuilder> collateralPosition = new ArrayList<CollateralPosition.CollateralPositionBuilder>();
        protected ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder legalAgreement;
        protected MetaFields.MetaFieldsBuilder meta;
        protected Identifier.IdentifierBuilder portfolioIdentifier;

        @Override
        public List<? extends CollateralBalance.CollateralBalanceBuilder> getCollateralBalance() {
            return this.collateralBalance;
        }

        @Override
        public CollateralBalance.CollateralBalanceBuilder getOrCreateCollateralBalance(int _index) {
            if (this.collateralBalance == null) {
                this.collateralBalance = new ArrayList<CollateralBalance.CollateralBalanceBuilder>();
            }
            return (CollateralBalance.CollateralBalanceBuilder)this.getIndex(this.collateralBalance, _index, () -> {
                CollateralBalance.CollateralBalanceBuilder newCollateralBalance = CollateralBalance.builder();
                return newCollateralBalance;
            });
        }

        @Override
        public List<? extends CollateralPosition.CollateralPositionBuilder> getCollateralPosition() {
            return this.collateralPosition;
        }

        @Override
        public CollateralPosition.CollateralPositionBuilder getOrCreateCollateralPosition(int _index) {
            if (this.collateralPosition == null) {
                this.collateralPosition = new ArrayList<CollateralPosition.CollateralPositionBuilder>();
            }
            return (CollateralPosition.CollateralPositionBuilder)this.getIndex(this.collateralPosition, _index, () -> {
                CollateralPosition.CollateralPositionBuilder newCollateralPosition = CollateralPosition.builder();
                return newCollateralPosition;
            });
        }

        @Override
        public ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder getLegalAgreement() {
            return this.legalAgreement;
        }

        @Override
        public ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder getOrCreateLegalAgreement() {
            ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder result = this.legalAgreement != null ? this.legalAgreement : (this.legalAgreement = ReferenceWithMetaLegalAgreement.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public Identifier.IdentifierBuilder getPortfolioIdentifier() {
            return this.portfolioIdentifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreatePortfolioIdentifier() {
            Identifier.IdentifierBuilder result = this.portfolioIdentifier != null ? this.portfolioIdentifier : (this.portfolioIdentifier = Identifier.builder());
            return result;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralBalance(CollateralBalance collateralBalance) {
            if (collateralBalance != null) {
                this.collateralBalance.add(collateralBalance.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralBalance(CollateralBalance collateralBalance, int _idx) {
            this.getIndex(this.collateralBalance, _idx, () -> collateralBalance.toBuilder());
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralBalance(List<? extends CollateralBalance> collateralBalances) {
            if (collateralBalances != null) {
                for (CollateralBalance collateralBalance : collateralBalances) {
                    this.collateralBalance.add(collateralBalance.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CollateralPortfolioBuilder setCollateralBalance(List<? extends CollateralBalance> collateralBalances) {
            this.collateralBalance = collateralBalances == null ? new ArrayList<CollateralBalance.CollateralBalanceBuilder>() : (List)collateralBalances.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralPosition(CollateralPosition collateralPosition) {
            if (collateralPosition != null) {
                this.collateralPosition.add(collateralPosition.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralPosition(CollateralPosition collateralPosition, int _idx) {
            this.getIndex(this.collateralPosition, _idx, () -> collateralPosition.toBuilder());
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralPosition(List<? extends CollateralPosition> collateralPositions) {
            if (collateralPositions != null) {
                for (CollateralPosition collateralPosition : collateralPositions) {
                    this.collateralPosition.add(collateralPosition.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CollateralPortfolioBuilder setCollateralPosition(List<? extends CollateralPosition> collateralPositions) {
            this.collateralPosition = collateralPositions == null ? new ArrayList<CollateralPosition.CollateralPositionBuilder>() : (List)collateralPositions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralPortfolioBuilder setLegalAgreement(ReferenceWithMetaLegalAgreement legalAgreement) {
            this.legalAgreement = legalAgreement == null ? null : legalAgreement.toBuilder();
            return this;
        }

        @Override
        public CollateralPortfolioBuilder setLegalAgreementValue(LegalAgreement legalAgreement) {
            this.getOrCreateLegalAgreement().setValue(legalAgreement);
            return this;
        }

        @Override
        public CollateralPortfolioBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public CollateralPortfolioBuilder setPortfolioIdentifier(Identifier portfolioIdentifier) {
            this.portfolioIdentifier = portfolioIdentifier == null ? null : portfolioIdentifier.toBuilder();
            return this;
        }

        @Override
        public CollateralPortfolio build() {
            return new CollateralPortfolioImpl(this);
        }

        @Override
        public CollateralPortfolioBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralPortfolioBuilder prune() {
            this.collateralBalance = this.collateralBalance.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.collateralPosition = this.collateralPosition.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.legalAgreement != null && !this.legalAgreement.prune().hasData()) {
                this.legalAgreement = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.portfolioIdentifier != null && !this.portfolioIdentifier.prune().hasData()) {
                this.portfolioIdentifier = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCollateralBalance() != null && this.getCollateralBalance().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCollateralPosition() != null && this.getCollateralPosition().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLegalAgreement() != null && this.getLegalAgreement().hasData()) {
                return true;
            }
            return this.getPortfolioIdentifier() != null && this.getPortfolioIdentifier().hasData();
        }

        public CollateralPortfolioBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralPortfolioBuilder o = (CollateralPortfolioBuilder)other;
            merger.mergeRosetta(this.getCollateralBalance(), o.getCollateralBalance(), this::getOrCreateCollateralBalance);
            merger.mergeRosetta(this.getCollateralPosition(), o.getCollateralPosition(), this::getOrCreateCollateralPosition);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegalAgreement(), (RosettaModelObjectBuilder)o.getLegalAgreement(), this::setLegalAgreement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPortfolioIdentifier(), (RosettaModelObjectBuilder)o.getPortfolioIdentifier(), this::setPortfolioIdentifier);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralPortfolio _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.collateralBalance, _that.getCollateralBalance())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralPosition, _that.getCollateralPosition())) {
                return false;
            }
            if (!Objects.equals(this.legalAgreement, _that.getLegalAgreement())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            return Objects.equals(this.portfolioIdentifier, _that.getPortfolioIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralBalance != null ? this.collateralBalance.hashCode() : 0);
            _result = 31 * _result + (this.collateralPosition != null ? this.collateralPosition.hashCode() : 0);
            _result = 31 * _result + (this.legalAgreement != null ? this.legalAgreement.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.portfolioIdentifier != null ? this.portfolioIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralPortfolioBuilder {collateralBalance=" + this.collateralBalance + ", collateralPosition=" + this.collateralPosition + ", legalAgreement=" + this.legalAgreement + ", meta=" + this.meta + ", portfolioIdentifier=" + this.portfolioIdentifier + '}';
        }
    }

    public static class CollateralPortfolioImpl
    implements CollateralPortfolio {
        private final List<? extends CollateralBalance> collateralBalance;
        private final List<? extends CollateralPosition> collateralPosition;
        private final ReferenceWithMetaLegalAgreement legalAgreement;
        private final MetaFields meta;
        private final Identifier portfolioIdentifier;

        protected CollateralPortfolioImpl(CollateralPortfolioBuilder builder) {
            this.collateralBalance = Optional.ofNullable(builder.getCollateralBalance()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateralPosition = Optional.ofNullable(builder.getCollateralPosition()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.legalAgreement = Optional.ofNullable(builder.getLegalAgreement()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.portfolioIdentifier = Optional.ofNullable(builder.getPortfolioIdentifier()).map(f -> f.build()).orElse(null);
        }

        @Override
        public List<? extends CollateralBalance> getCollateralBalance() {
            return this.collateralBalance;
        }

        @Override
        public List<? extends CollateralPosition> getCollateralPosition() {
            return this.collateralPosition;
        }

        @Override
        public ReferenceWithMetaLegalAgreement getLegalAgreement() {
            return this.legalAgreement;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Identifier getPortfolioIdentifier() {
            return this.portfolioIdentifier;
        }

        @Override
        public CollateralPortfolio build() {
            return this;
        }

        @Override
        public CollateralPortfolioBuilder toBuilder() {
            CollateralPortfolioBuilder builder = CollateralPortfolio.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralPortfolioBuilder builder) {
            Optional.ofNullable(this.getCollateralBalance()).ifPresent(builder::setCollateralBalance);
            Optional.ofNullable(this.getCollateralPosition()).ifPresent(builder::setCollateralPosition);
            Optional.ofNullable(this.getLegalAgreement()).ifPresent(builder::setLegalAgreement);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPortfolioIdentifier()).ifPresent(builder::setPortfolioIdentifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralPortfolio _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.collateralBalance, _that.getCollateralBalance())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralPosition, _that.getCollateralPosition())) {
                return false;
            }
            if (!Objects.equals(this.legalAgreement, _that.getLegalAgreement())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            return Objects.equals(this.portfolioIdentifier, _that.getPortfolioIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralBalance != null ? this.collateralBalance.hashCode() : 0);
            _result = 31 * _result + (this.collateralPosition != null ? this.collateralPosition.hashCode() : 0);
            _result = 31 * _result + (this.legalAgreement != null ? this.legalAgreement.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.portfolioIdentifier != null ? this.portfolioIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralPortfolio {collateralBalance=" + this.collateralBalance + ", collateralPosition=" + this.collateralPosition + ", legalAgreement=" + this.legalAgreement + ", meta=" + this.meta + ", portfolioIdentifier=" + this.portfolioIdentifier + '}';
        }
    }

    public static interface CollateralPortfolioBuilder
    extends CollateralPortfolio,
    RosettaModelObjectBuilder {
        public CollateralBalance.CollateralBalanceBuilder getOrCreateCollateralBalance(int var1);

        public List<? extends CollateralBalance.CollateralBalanceBuilder> getCollateralBalance();

        public CollateralPosition.CollateralPositionBuilder getOrCreateCollateralPosition(int var1);

        public List<? extends CollateralPosition.CollateralPositionBuilder> getCollateralPosition();

        public ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder getOrCreateLegalAgreement();

        @Override
        public ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder getLegalAgreement();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public Identifier.IdentifierBuilder getOrCreatePortfolioIdentifier();

        @Override
        public Identifier.IdentifierBuilder getPortfolioIdentifier();

        public CollateralPortfolioBuilder addCollateralBalance(CollateralBalance var1);

        public CollateralPortfolioBuilder addCollateralBalance(CollateralBalance var1, int var2);

        public CollateralPortfolioBuilder addCollateralBalance(List<? extends CollateralBalance> var1);

        public CollateralPortfolioBuilder setCollateralBalance(List<? extends CollateralBalance> var1);

        public CollateralPortfolioBuilder addCollateralPosition(CollateralPosition var1);

        public CollateralPortfolioBuilder addCollateralPosition(CollateralPosition var1, int var2);

        public CollateralPortfolioBuilder addCollateralPosition(List<? extends CollateralPosition> var1);

        public CollateralPortfolioBuilder setCollateralPosition(List<? extends CollateralPosition> var1);

        public CollateralPortfolioBuilder setLegalAgreement(ReferenceWithMetaLegalAgreement var1);

        public CollateralPortfolioBuilder setLegalAgreementValue(LegalAgreement var1);

        public CollateralPortfolioBuilder setMeta(MetaFields var1);

        public CollateralPortfolioBuilder setPortfolioIdentifier(Identifier var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("collateralBalance"), processor, CollateralBalance.CollateralBalanceBuilder.class, this.getCollateralBalance(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralPosition"), processor, CollateralPosition.CollateralPositionBuilder.class, this.getCollateralPosition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalAgreement"), processor, ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder.class, this.getLegalAgreement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getPortfolioIdentifier(), new AttributeMeta[0]);
        }

        public CollateralPortfolioBuilder prune();
    }
}

