/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum CallTypeEnum {
    MARGIN_CALL,
    NOTIFICATION,
    EXPECTED_CALL;

    private static Map<String, CallTypeEnum> values;
    private final String displayName;

    private CallTypeEnum() {
        this(null);
    }

    private CallTypeEnum(String displayName) {
        this.displayName = displayName;
    }

    public static CallTypeEnum fromDisplayName(String name) {
        CallTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, CallTypeEnum> map = new ConcurrentHashMap<String, CallTypeEnum>();
        for (CallTypeEnum instance : CallTypeEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

