/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.event.common.CorporateActionTypeEnum;
import cdm.event.common.EventIntentEnum;
import cdm.event.common.Instruction;
import cdm.event.common.TradeState;
import cdm.event.common.meta.BusinessEventMeta;
import cdm.event.workflow.EventInstruction;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface BusinessEvent
extends EventInstruction,
GlobalKey {
    public static final BusinessEventMeta metaData = new BusinessEventMeta();

    @Override
    public BusinessEvent build();

    @Override
    public BusinessEventBuilder toBuilder();

    public List<? extends TradeState> getAfter();

    public String getEventQualifier();

    public MetaFields getMeta();

    default public RosettaMetaData<? extends BusinessEvent> metaData() {
        return metaData;
    }

    public static BusinessEventBuilder builder() {
        return new BusinessEventBuilderImpl();
    }

    default public Class<? extends BusinessEvent> getType() {
        return BusinessEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        EventInstruction.super.process(path, processor);
        processor.processBasic(path.newSubPath("eventQualifier"), String.class, (Object)this.getEventQualifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("after"), processor, TradeState.class, this.getAfter(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class BusinessEventBuilderImpl
    extends EventInstruction.EventInstructionBuilderImpl
    implements BusinessEventBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected List<TradeState.TradeStateBuilder> after = new ArrayList<TradeState.TradeStateBuilder>();
        protected String eventQualifier;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        public List<? extends TradeState.TradeStateBuilder> getAfter() {
            return this.after;
        }

        @Override
        public TradeState.TradeStateBuilder getOrCreateAfter(int _index) {
            if (this.after == null) {
                this.after = new ArrayList<TradeState.TradeStateBuilder>();
            }
            return (TradeState.TradeStateBuilder)this.getIndex(this.after, _index, () -> {
                TradeState.TradeStateBuilder newAfter = TradeState.builder();
                return newAfter;
            });
        }

        @Override
        public String getEventQualifier() {
            return this.eventQualifier;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public BusinessEventBuilder addAfter(TradeState after) {
            if (after != null) {
                this.after.add(after.toBuilder());
            }
            return this;
        }

        @Override
        public BusinessEventBuilder addAfter(TradeState after, int _idx) {
            this.getIndex(this.after, _idx, () -> after.toBuilder());
            return this;
        }

        @Override
        public BusinessEventBuilder addAfter(List<? extends TradeState> afters) {
            if (afters != null) {
                for (TradeState tradeState : afters) {
                    this.after.add(tradeState.toBuilder());
                }
            }
            return this;
        }

        @Override
        public BusinessEventBuilder setAfter(List<? extends TradeState> afters) {
            this.after = afters == null ? new ArrayList<TradeState.TradeStateBuilder>() : (List)afters.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BusinessEventBuilder setEventQualifier(String eventQualifier) {
            this.eventQualifier = eventQualifier == null ? null : eventQualifier;
            return this;
        }

        @Override
        public BusinessEventBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public BusinessEventBuilder setCorporateActionIntent(CorporateActionTypeEnum corporateActionIntent) {
            this.corporateActionIntent = corporateActionIntent == null ? null : corporateActionIntent;
            return this;
        }

        @Override
        public BusinessEventBuilder setEffectiveDate(Date effectiveDate) {
            this.effectiveDate = effectiveDate == null ? null : effectiveDate;
            return this;
        }

        @Override
        public BusinessEventBuilder setEventDate(Date eventDate) {
            this.eventDate = eventDate == null ? null : eventDate;
            return this;
        }

        @Override
        public BusinessEventBuilder addInstruction(Instruction instruction) {
            if (instruction != null) {
                this.instruction.add(instruction.toBuilder());
            }
            return this;
        }

        @Override
        public BusinessEventBuilder addInstruction(Instruction instruction, int _idx) {
            this.getIndex(this.instruction, _idx, () -> instruction.toBuilder());
            return this;
        }

        @Override
        public BusinessEventBuilder addInstruction(List<? extends Instruction> instructions) {
            if (instructions != null) {
                for (Instruction instruction : instructions) {
                    this.instruction.add(instruction.toBuilder());
                }
            }
            return this;
        }

        @Override
        public BusinessEventBuilder setInstruction(List<? extends Instruction> instructions) {
            this.instruction = instructions == null ? new ArrayList() : (List)instructions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BusinessEventBuilder setIntent(EventIntentEnum intent) {
            this.intent = intent == null ? null : intent;
            return this;
        }

        @Override
        public BusinessEventBuilder setPackageInformation(IdentifiedList packageInformation) {
            this.packageInformation = packageInformation == null ? null : packageInformation.toBuilder();
            return this;
        }

        @Override
        public BusinessEvent build() {
            return new BusinessEventImpl(this);
        }

        @Override
        public BusinessEventBuilder toBuilder() {
            return this;
        }

        @Override
        public BusinessEventBuilder prune() {
            super.prune();
            this.after = this.after.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAfter() != null && this.getAfter().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getEventQualifier() != null;
        }

        @Override
        public BusinessEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BusinessEventBuilder o = (BusinessEventBuilder)other;
            merger.mergeRosetta(this.getAfter(), o.getAfter(), this::getOrCreateAfter);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getEventQualifier(), (Object)o.getEventQualifier(), this::setEventQualifier, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BusinessEvent _that = (BusinessEvent)this.getType().cast(o);
            if (!ListEquals.listEquals(this.after, _that.getAfter())) {
                return false;
            }
            if (!Objects.equals(this.eventQualifier, _that.getEventQualifier())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.after != null ? this.after.hashCode() : 0);
            _result = 31 * _result + (this.eventQualifier != null ? this.eventQualifier.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BusinessEventBuilder {after=" + this.after + ", eventQualifier=" + this.eventQualifier + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static class BusinessEventImpl
    extends EventInstruction.EventInstructionImpl
    implements BusinessEvent {
        private final List<? extends TradeState> after;
        private final String eventQualifier;
        private final MetaFields meta;

        protected BusinessEventImpl(BusinessEventBuilder builder) {
            super(builder);
            this.after = Optional.ofNullable(builder.getAfter()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.eventQualifier = builder.getEventQualifier();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        public List<? extends TradeState> getAfter() {
            return this.after;
        }

        @Override
        public String getEventQualifier() {
            return this.eventQualifier;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public BusinessEvent build() {
            return this;
        }

        @Override
        public BusinessEventBuilder toBuilder() {
            BusinessEventBuilder builder = BusinessEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BusinessEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAfter()).ifPresent(builder::setAfter);
            Optional.ofNullable(this.getEventQualifier()).ifPresent(builder::setEventQualifier);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BusinessEvent _that = (BusinessEvent)this.getType().cast(o);
            if (!ListEquals.listEquals(this.after, _that.getAfter())) {
                return false;
            }
            if (!Objects.equals(this.eventQualifier, _that.getEventQualifier())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.after != null ? this.after.hashCode() : 0);
            _result = 31 * _result + (this.eventQualifier != null ? this.eventQualifier.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BusinessEvent {after=" + this.after + ", eventQualifier=" + this.eventQualifier + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static interface BusinessEventBuilder
    extends BusinessEvent,
    EventInstruction.EventInstructionBuilder,
    RosettaModelObjectBuilder {
        public TradeState.TradeStateBuilder getOrCreateAfter(int var1);

        public List<? extends TradeState.TradeStateBuilder> getAfter();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public BusinessEventBuilder addAfter(TradeState var1);

        public BusinessEventBuilder addAfter(TradeState var1, int var2);

        public BusinessEventBuilder addAfter(List<? extends TradeState> var1);

        public BusinessEventBuilder setAfter(List<? extends TradeState> var1);

        public BusinessEventBuilder setEventQualifier(String var1);

        public BusinessEventBuilder setMeta(MetaFields var1);

        @Override
        public BusinessEventBuilder setCorporateActionIntent(CorporateActionTypeEnum var1);

        @Override
        public BusinessEventBuilder setEffectiveDate(Date var1);

        @Override
        public BusinessEventBuilder setEventDate(Date var1);

        @Override
        public BusinessEventBuilder addInstruction(Instruction var1);

        @Override
        public BusinessEventBuilder addInstruction(Instruction var1, int var2);

        @Override
        public BusinessEventBuilder addInstruction(List<? extends Instruction> var1);

        @Override
        public BusinessEventBuilder setInstruction(List<? extends Instruction> var1);

        @Override
        public BusinessEventBuilder setIntent(EventIntentEnum var1);

        @Override
        public BusinessEventBuilder setPackageInformation(IdentifiedList var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            EventInstruction.EventInstructionBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("eventQualifier"), String.class, (Object)this.getEventQualifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("after"), processor, TradeState.TradeStateBuilder.class, this.getAfter(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        @Override
        public BusinessEventBuilder prune();
    }
}

