/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.TradeState;
import cdm.event.common.meta.BillingRecordInstructionMeta;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.observable.event.Observation;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface BillingRecordInstruction
extends RosettaModelObject {
    public static final BillingRecordInstructionMeta metaData = new BillingRecordInstructionMeta();

    public BillingRecordInstruction build();

    public BillingRecordInstructionBuilder toBuilder();

    public List<? extends Observation> getObservation();

    public Date getRecordEndDate();

    public Date getRecordStartDate();

    public Date getSettlementDate();

    public ReferenceWithMetaTradeState getTradeState();

    default public RosettaMetaData<? extends BillingRecordInstruction> metaData() {
        return metaData;
    }

    public static BillingRecordInstructionBuilder builder() {
        return new BillingRecordInstructionBuilderImpl();
    }

    default public Class<? extends BillingRecordInstruction> getType() {
        return BillingRecordInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("recordEndDate"), Date.class, (Object)this.getRecordEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("recordStartDate"), Date.class, (Object)this.getRecordStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementDate"), Date.class, (Object)this.getSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observation"), processor, Observation.class, this.getObservation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeState"), processor, ReferenceWithMetaTradeState.class, this.getTradeState(), new AttributeMeta[0]);
    }

    public static class BillingRecordInstructionBuilderImpl
    implements BillingRecordInstructionBuilder {
        protected List<Observation.ObservationBuilder> observation = new ArrayList<Observation.ObservationBuilder>();
        protected Date recordEndDate;
        protected Date recordStartDate;
        protected Date settlementDate;
        protected ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder tradeState;

        @Override
        public List<? extends Observation.ObservationBuilder> getObservation() {
            return this.observation;
        }

        @Override
        public Observation.ObservationBuilder getOrCreateObservation(int _index) {
            if (this.observation == null) {
                this.observation = new ArrayList<Observation.ObservationBuilder>();
            }
            return (Observation.ObservationBuilder)this.getIndex(this.observation, _index, () -> {
                Observation.ObservationBuilder newObservation = Observation.builder();
                return newObservation;
            });
        }

        @Override
        public Date getRecordEndDate() {
            return this.recordEndDate;
        }

        @Override
        public Date getRecordStartDate() {
            return this.recordStartDate;
        }

        @Override
        public Date getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getTradeState() {
            return this.tradeState;
        }

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeState() {
            ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder result = this.tradeState != null ? this.tradeState : (this.tradeState = ReferenceWithMetaTradeState.builder());
            return result;
        }

        @Override
        public BillingRecordInstructionBuilder addObservation(Observation observation) {
            if (observation != null) {
                this.observation.add(observation.toBuilder());
            }
            return this;
        }

        @Override
        public BillingRecordInstructionBuilder addObservation(Observation observation, int _idx) {
            this.getIndex(this.observation, _idx, () -> observation.toBuilder());
            return this;
        }

        @Override
        public BillingRecordInstructionBuilder addObservation(List<? extends Observation> observations) {
            if (observations != null) {
                for (Observation observation : observations) {
                    this.observation.add(observation.toBuilder());
                }
            }
            return this;
        }

        @Override
        public BillingRecordInstructionBuilder setObservation(List<? extends Observation> observations) {
            this.observation = observations == null ? new ArrayList<Observation.ObservationBuilder>() : (List)observations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BillingRecordInstructionBuilder setRecordEndDate(Date recordEndDate) {
            this.recordEndDate = recordEndDate == null ? null : recordEndDate;
            return this;
        }

        @Override
        public BillingRecordInstructionBuilder setRecordStartDate(Date recordStartDate) {
            this.recordStartDate = recordStartDate == null ? null : recordStartDate;
            return this;
        }

        @Override
        public BillingRecordInstructionBuilder setSettlementDate(Date settlementDate) {
            this.settlementDate = settlementDate == null ? null : settlementDate;
            return this;
        }

        @Override
        public BillingRecordInstructionBuilder setTradeState(ReferenceWithMetaTradeState tradeState) {
            this.tradeState = tradeState == null ? null : tradeState.toBuilder();
            return this;
        }

        @Override
        public BillingRecordInstructionBuilder setTradeStateValue(TradeState tradeState) {
            this.getOrCreateTradeState().setValue(tradeState);
            return this;
        }

        @Override
        public BillingRecordInstruction build() {
            return new BillingRecordInstructionImpl(this);
        }

        @Override
        public BillingRecordInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public BillingRecordInstructionBuilder prune() {
            this.observation = this.observation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.tradeState != null && !this.tradeState.prune().hasData()) {
                this.tradeState = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getObservation() != null && this.getObservation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRecordEndDate() != null) {
                return true;
            }
            if (this.getRecordStartDate() != null) {
                return true;
            }
            if (this.getSettlementDate() != null) {
                return true;
            }
            return this.getTradeState() != null && this.getTradeState().hasData();
        }

        public BillingRecordInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BillingRecordInstructionBuilder o = (BillingRecordInstructionBuilder)other;
            merger.mergeRosetta(this.getObservation(), o.getObservation(), this::getOrCreateObservation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeState(), (RosettaModelObjectBuilder)o.getTradeState(), this::setTradeState);
            merger.mergeBasic((Object)this.getRecordEndDate(), (Object)o.getRecordEndDate(), this::setRecordEndDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRecordStartDate(), (Object)o.getRecordStartDate(), this::setRecordStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementDate(), (Object)o.getSettlementDate(), this::setSettlementDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BillingRecordInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observation, _that.getObservation())) {
                return false;
            }
            if (!Objects.equals(this.recordEndDate, _that.getRecordEndDate())) {
                return false;
            }
            if (!Objects.equals(this.recordStartDate, _that.getRecordStartDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            return Objects.equals(this.tradeState, _that.getTradeState());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observation != null ? this.observation.hashCode() : 0);
            _result = 31 * _result + (this.recordEndDate != null ? this.recordEndDate.hashCode() : 0);
            _result = 31 * _result + (this.recordStartDate != null ? this.recordStartDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.tradeState != null ? this.tradeState.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BillingRecordInstructionBuilder {observation=" + this.observation + ", recordEndDate=" + this.recordEndDate + ", recordStartDate=" + this.recordStartDate + ", settlementDate=" + this.settlementDate + ", tradeState=" + this.tradeState + '}';
        }
    }

    public static class BillingRecordInstructionImpl
    implements BillingRecordInstruction {
        private final List<? extends Observation> observation;
        private final Date recordEndDate;
        private final Date recordStartDate;
        private final Date settlementDate;
        private final ReferenceWithMetaTradeState tradeState;

        protected BillingRecordInstructionImpl(BillingRecordInstructionBuilder builder) {
            this.observation = Optional.ofNullable(builder.getObservation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.recordEndDate = builder.getRecordEndDate();
            this.recordStartDate = builder.getRecordStartDate();
            this.settlementDate = builder.getSettlementDate();
            this.tradeState = Optional.ofNullable(builder.getTradeState()).map(f -> f.build()).orElse(null);
        }

        @Override
        public List<? extends Observation> getObservation() {
            return this.observation;
        }

        @Override
        public Date getRecordEndDate() {
            return this.recordEndDate;
        }

        @Override
        public Date getRecordStartDate() {
            return this.recordStartDate;
        }

        @Override
        public Date getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public ReferenceWithMetaTradeState getTradeState() {
            return this.tradeState;
        }

        @Override
        public BillingRecordInstruction build() {
            return this;
        }

        @Override
        public BillingRecordInstructionBuilder toBuilder() {
            BillingRecordInstructionBuilder builder = BillingRecordInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BillingRecordInstructionBuilder builder) {
            Optional.ofNullable(this.getObservation()).ifPresent(builder::setObservation);
            Optional.ofNullable(this.getRecordEndDate()).ifPresent(builder::setRecordEndDate);
            Optional.ofNullable(this.getRecordStartDate()).ifPresent(builder::setRecordStartDate);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
            Optional.ofNullable(this.getTradeState()).ifPresent(builder::setTradeState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BillingRecordInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observation, _that.getObservation())) {
                return false;
            }
            if (!Objects.equals(this.recordEndDate, _that.getRecordEndDate())) {
                return false;
            }
            if (!Objects.equals(this.recordStartDate, _that.getRecordStartDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            return Objects.equals(this.tradeState, _that.getTradeState());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observation != null ? this.observation.hashCode() : 0);
            _result = 31 * _result + (this.recordEndDate != null ? this.recordEndDate.hashCode() : 0);
            _result = 31 * _result + (this.recordStartDate != null ? this.recordStartDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.tradeState != null ? this.tradeState.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BillingRecordInstruction {observation=" + this.observation + ", recordEndDate=" + this.recordEndDate + ", recordStartDate=" + this.recordStartDate + ", settlementDate=" + this.settlementDate + ", tradeState=" + this.tradeState + '}';
        }
    }

    public static interface BillingRecordInstructionBuilder
    extends BillingRecordInstruction,
    RosettaModelObjectBuilder {
        public Observation.ObservationBuilder getOrCreateObservation(int var1);

        public List<? extends Observation.ObservationBuilder> getObservation();

        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeState();

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getTradeState();

        public BillingRecordInstructionBuilder addObservation(Observation var1);

        public BillingRecordInstructionBuilder addObservation(Observation var1, int var2);

        public BillingRecordInstructionBuilder addObservation(List<? extends Observation> var1);

        public BillingRecordInstructionBuilder setObservation(List<? extends Observation> var1);

        public BillingRecordInstructionBuilder setRecordEndDate(Date var1);

        public BillingRecordInstructionBuilder setRecordStartDate(Date var1);

        public BillingRecordInstructionBuilder setSettlementDate(Date var1);

        public BillingRecordInstructionBuilder setTradeState(ReferenceWithMetaTradeState var1);

        public BillingRecordInstructionBuilder setTradeStateValue(TradeState var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("recordEndDate"), Date.class, (Object)this.getRecordEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("recordStartDate"), Date.class, (Object)this.getRecordStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementDate"), Date.class, (Object)this.getSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observation"), processor, Observation.ObservationBuilder.class, this.getObservation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeState"), processor, ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder.class, this.getTradeState(), new AttributeMeta[0]);
        }

        public BillingRecordInstructionBuilder prune();
    }
}

