/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.event.common.meta.BillingRecordMeta;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.observable.asset.Money;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface BillingRecord
extends RosettaModelObject {
    public static final BillingRecordMeta metaData = new BillingRecordMeta();

    public BillingRecord build();

    public BillingRecordBuilder toBuilder();

    public Money getMinimumFee();

    public Date getRecordEndDate();

    public Date getRecordStartDate();

    public Transfer getRecordTransfer();

    public ReferenceWithMetaTradeState getTradeState();

    default public RosettaMetaData<? extends BillingRecord> metaData() {
        return metaData;
    }

    public static BillingRecordBuilder builder() {
        return new BillingRecordBuilderImpl();
    }

    default public Class<? extends BillingRecord> getType() {
        return BillingRecord.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("recordEndDate"), Date.class, (Object)this.getRecordEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("recordStartDate"), Date.class, (Object)this.getRecordStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumFee"), processor, Money.class, this.getMinimumFee(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("recordTransfer"), processor, Transfer.class, this.getRecordTransfer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeState"), processor, ReferenceWithMetaTradeState.class, this.getTradeState(), new AttributeMeta[0]);
    }

    public static class BillingRecordBuilderImpl
    implements BillingRecordBuilder {
        protected Money.MoneyBuilder minimumFee;
        protected Date recordEndDate;
        protected Date recordStartDate;
        protected Transfer.TransferBuilder recordTransfer;
        protected ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder tradeState;

        @Override
        public Money.MoneyBuilder getMinimumFee() {
            return this.minimumFee;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMinimumFee() {
            Money.MoneyBuilder result = this.minimumFee != null ? this.minimumFee : (this.minimumFee = Money.builder());
            return result;
        }

        @Override
        public Date getRecordEndDate() {
            return this.recordEndDate;
        }

        @Override
        public Date getRecordStartDate() {
            return this.recordStartDate;
        }

        @Override
        public Transfer.TransferBuilder getRecordTransfer() {
            return this.recordTransfer;
        }

        @Override
        public Transfer.TransferBuilder getOrCreateRecordTransfer() {
            Transfer.TransferBuilder result = this.recordTransfer != null ? this.recordTransfer : (this.recordTransfer = Transfer.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getTradeState() {
            return this.tradeState;
        }

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeState() {
            ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder result = this.tradeState != null ? this.tradeState : (this.tradeState = ReferenceWithMetaTradeState.builder());
            return result;
        }

        @Override
        public BillingRecordBuilder setMinimumFee(Money minimumFee) {
            this.minimumFee = minimumFee == null ? null : minimumFee.toBuilder();
            return this;
        }

        @Override
        public BillingRecordBuilder setRecordEndDate(Date recordEndDate) {
            this.recordEndDate = recordEndDate == null ? null : recordEndDate;
            return this;
        }

        @Override
        public BillingRecordBuilder setRecordStartDate(Date recordStartDate) {
            this.recordStartDate = recordStartDate == null ? null : recordStartDate;
            return this;
        }

        @Override
        public BillingRecordBuilder setRecordTransfer(Transfer recordTransfer) {
            this.recordTransfer = recordTransfer == null ? null : recordTransfer.toBuilder();
            return this;
        }

        @Override
        public BillingRecordBuilder setTradeState(ReferenceWithMetaTradeState tradeState) {
            this.tradeState = tradeState == null ? null : tradeState.toBuilder();
            return this;
        }

        @Override
        public BillingRecordBuilder setTradeStateValue(TradeState tradeState) {
            this.getOrCreateTradeState().setValue(tradeState);
            return this;
        }

        @Override
        public BillingRecord build() {
            return new BillingRecordImpl(this);
        }

        @Override
        public BillingRecordBuilder toBuilder() {
            return this;
        }

        @Override
        public BillingRecordBuilder prune() {
            if (this.minimumFee != null && !this.minimumFee.prune().hasData()) {
                this.minimumFee = null;
            }
            if (this.recordTransfer != null && !this.recordTransfer.prune().hasData()) {
                this.recordTransfer = null;
            }
            if (this.tradeState != null && !this.tradeState.prune().hasData()) {
                this.tradeState = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getMinimumFee() != null && this.getMinimumFee().hasData()) {
                return true;
            }
            if (this.getRecordEndDate() != null) {
                return true;
            }
            if (this.getRecordStartDate() != null) {
                return true;
            }
            if (this.getRecordTransfer() != null && this.getRecordTransfer().hasData()) {
                return true;
            }
            return this.getTradeState() != null && this.getTradeState().hasData();
        }

        public BillingRecordBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BillingRecordBuilder o = (BillingRecordBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumFee(), (RosettaModelObjectBuilder)o.getMinimumFee(), this::setMinimumFee);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRecordTransfer(), (RosettaModelObjectBuilder)o.getRecordTransfer(), this::setRecordTransfer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeState(), (RosettaModelObjectBuilder)o.getTradeState(), this::setTradeState);
            merger.mergeBasic((Object)this.getRecordEndDate(), (Object)o.getRecordEndDate(), this::setRecordEndDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRecordStartDate(), (Object)o.getRecordStartDate(), this::setRecordStartDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BillingRecord _that = this.getType().cast(o);
            if (!Objects.equals(this.minimumFee, _that.getMinimumFee())) {
                return false;
            }
            if (!Objects.equals(this.recordEndDate, _that.getRecordEndDate())) {
                return false;
            }
            if (!Objects.equals(this.recordStartDate, _that.getRecordStartDate())) {
                return false;
            }
            if (!Objects.equals(this.recordTransfer, _that.getRecordTransfer())) {
                return false;
            }
            return Objects.equals(this.tradeState, _that.getTradeState());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.minimumFee != null ? this.minimumFee.hashCode() : 0);
            _result = 31 * _result + (this.recordEndDate != null ? this.recordEndDate.hashCode() : 0);
            _result = 31 * _result + (this.recordStartDate != null ? this.recordStartDate.hashCode() : 0);
            _result = 31 * _result + (this.recordTransfer != null ? this.recordTransfer.hashCode() : 0);
            _result = 31 * _result + (this.tradeState != null ? this.tradeState.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BillingRecordBuilder {minimumFee=" + this.minimumFee + ", recordEndDate=" + this.recordEndDate + ", recordStartDate=" + this.recordStartDate + ", recordTransfer=" + this.recordTransfer + ", tradeState=" + this.tradeState + '}';
        }
    }

    public static class BillingRecordImpl
    implements BillingRecord {
        private final Money minimumFee;
        private final Date recordEndDate;
        private final Date recordStartDate;
        private final Transfer recordTransfer;
        private final ReferenceWithMetaTradeState tradeState;

        protected BillingRecordImpl(BillingRecordBuilder builder) {
            this.minimumFee = Optional.ofNullable(builder.getMinimumFee()).map(f -> f.build()).orElse(null);
            this.recordEndDate = builder.getRecordEndDate();
            this.recordStartDate = builder.getRecordStartDate();
            this.recordTransfer = Optional.ofNullable(builder.getRecordTransfer()).map(f -> f.build()).orElse(null);
            this.tradeState = Optional.ofNullable(builder.getTradeState()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Money getMinimumFee() {
            return this.minimumFee;
        }

        @Override
        public Date getRecordEndDate() {
            return this.recordEndDate;
        }

        @Override
        public Date getRecordStartDate() {
            return this.recordStartDate;
        }

        @Override
        public Transfer getRecordTransfer() {
            return this.recordTransfer;
        }

        @Override
        public ReferenceWithMetaTradeState getTradeState() {
            return this.tradeState;
        }

        @Override
        public BillingRecord build() {
            return this;
        }

        @Override
        public BillingRecordBuilder toBuilder() {
            BillingRecordBuilder builder = BillingRecord.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BillingRecordBuilder builder) {
            Optional.ofNullable(this.getMinimumFee()).ifPresent(builder::setMinimumFee);
            Optional.ofNullable(this.getRecordEndDate()).ifPresent(builder::setRecordEndDate);
            Optional.ofNullable(this.getRecordStartDate()).ifPresent(builder::setRecordStartDate);
            Optional.ofNullable(this.getRecordTransfer()).ifPresent(builder::setRecordTransfer);
            Optional.ofNullable(this.getTradeState()).ifPresent(builder::setTradeState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BillingRecord _that = this.getType().cast(o);
            if (!Objects.equals(this.minimumFee, _that.getMinimumFee())) {
                return false;
            }
            if (!Objects.equals(this.recordEndDate, _that.getRecordEndDate())) {
                return false;
            }
            if (!Objects.equals(this.recordStartDate, _that.getRecordStartDate())) {
                return false;
            }
            if (!Objects.equals(this.recordTransfer, _that.getRecordTransfer())) {
                return false;
            }
            return Objects.equals(this.tradeState, _that.getTradeState());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.minimumFee != null ? this.minimumFee.hashCode() : 0);
            _result = 31 * _result + (this.recordEndDate != null ? this.recordEndDate.hashCode() : 0);
            _result = 31 * _result + (this.recordStartDate != null ? this.recordStartDate.hashCode() : 0);
            _result = 31 * _result + (this.recordTransfer != null ? this.recordTransfer.hashCode() : 0);
            _result = 31 * _result + (this.tradeState != null ? this.tradeState.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BillingRecord {minimumFee=" + this.minimumFee + ", recordEndDate=" + this.recordEndDate + ", recordStartDate=" + this.recordStartDate + ", recordTransfer=" + this.recordTransfer + ", tradeState=" + this.tradeState + '}';
        }
    }

    public static interface BillingRecordBuilder
    extends BillingRecord,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateMinimumFee();

        @Override
        public Money.MoneyBuilder getMinimumFee();

        public Transfer.TransferBuilder getOrCreateRecordTransfer();

        @Override
        public Transfer.TransferBuilder getRecordTransfer();

        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeState();

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getTradeState();

        public BillingRecordBuilder setMinimumFee(Money var1);

        public BillingRecordBuilder setRecordEndDate(Date var1);

        public BillingRecordBuilder setRecordStartDate(Date var1);

        public BillingRecordBuilder setRecordTransfer(Transfer var1);

        public BillingRecordBuilder setTradeState(ReferenceWithMetaTradeState var1);

        public BillingRecordBuilder setTradeStateValue(TradeState var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("recordEndDate"), Date.class, (Object)this.getRecordEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("recordStartDate"), Date.class, (Object)this.getRecordStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumFee"), processor, Money.MoneyBuilder.class, this.getMinimumFee(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("recordTransfer"), processor, Transfer.TransferBuilder.class, this.getRecordTransfer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeState"), processor, ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder.class, this.getTradeState(), new AttributeMeta[0]);
        }

        public BillingRecordBuilder prune();
    }
}

