/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.AffirmationStatusEnum;
import cdm.event.common.Lineage;
import cdm.event.common.meta.AffirmationMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface Affirmation
extends RosettaModelObject {
    public static final AffirmationMeta metaData = new AffirmationMeta();

    public Affirmation build();

    public AffirmationBuilder toBuilder();

    public List<? extends Identifier> getIdentifier();

    public Lineage getLineage();

    public List<? extends Party> getParty();

    public List<? extends PartyRole> getPartyRole();

    public AffirmationStatusEnum getStatus();

    default public RosettaMetaData<? extends Affirmation> metaData() {
        return metaData;
    }

    public static AffirmationBuilder builder() {
        return new AffirmationBuilderImpl();
    }

    default public Class<? extends Affirmation> getType() {
        return Affirmation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("status"), AffirmationStatusEnum.class, (Object)this.getStatus(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("identifier"), processor, Identifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lineage"), processor, Lineage.class, this.getLineage(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.class, this.getPartyRole(), new AttributeMeta[0]);
    }

    public static class AffirmationBuilderImpl
    implements AffirmationBuilder {
        protected List<Identifier.IdentifierBuilder> identifier = new ArrayList<Identifier.IdentifierBuilder>();
        protected Lineage.LineageBuilder lineage;
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();
        protected List<PartyRole.PartyRoleBuilder> partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
        protected AffirmationStatusEnum status;

        @Override
        public List<? extends Identifier.IdentifierBuilder> getIdentifier() {
            return this.identifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreateIdentifier(int _index) {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier.IdentifierBuilder>();
            }
            return (Identifier.IdentifierBuilder)this.getIndex(this.identifier, _index, () -> {
                Identifier.IdentifierBuilder newIdentifier = Identifier.builder();
                return newIdentifier;
            });
        }

        @Override
        public Lineage.LineageBuilder getLineage() {
            return this.lineage;
        }

        @Override
        public Lineage.LineageBuilder getOrCreateLineage() {
            Lineage.LineageBuilder result = this.lineage != null ? this.lineage : (this.lineage = Lineage.builder());
            return result;
        }

        @Override
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int _index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, _index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole() {
            return this.partyRole;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int _index) {
            if (this.partyRole == null) {
                this.partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
            }
            return (PartyRole.PartyRoleBuilder)this.getIndex(this.partyRole, _index, () -> {
                PartyRole.PartyRoleBuilder newPartyRole = PartyRole.builder();
                return newPartyRole;
            });
        }

        @Override
        public AffirmationStatusEnum getStatus() {
            return this.status;
        }

        @Override
        public AffirmationBuilder addIdentifier(Identifier identifier) {
            if (identifier != null) {
                this.identifier.add(identifier.toBuilder());
            }
            return this;
        }

        @Override
        public AffirmationBuilder addIdentifier(Identifier identifier, int _idx) {
            this.getIndex(this.identifier, _idx, () -> identifier.toBuilder());
            return this;
        }

        @Override
        public AffirmationBuilder addIdentifier(List<? extends Identifier> identifiers) {
            if (identifiers != null) {
                for (Identifier identifier : identifiers) {
                    this.identifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AffirmationBuilder setIdentifier(List<? extends Identifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList<Identifier.IdentifierBuilder>() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AffirmationBuilder setLineage(Lineage lineage) {
            this.lineage = lineage == null ? null : lineage.toBuilder();
            return this;
        }

        @Override
        public AffirmationBuilder addParty(Party party) {
            if (party != null) {
                this.party.add(party.toBuilder());
            }
            return this;
        }

        @Override
        public AffirmationBuilder addParty(Party party, int _idx) {
            this.getIndex(this.party, _idx, () -> party.toBuilder());
            return this;
        }

        @Override
        public AffirmationBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AffirmationBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AffirmationBuilder addPartyRole(PartyRole partyRole) {
            if (partyRole != null) {
                this.partyRole.add(partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public AffirmationBuilder addPartyRole(PartyRole partyRole, int _idx) {
            this.getIndex(this.partyRole, _idx, () -> partyRole.toBuilder());
            return this;
        }

        @Override
        public AffirmationBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AffirmationBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList<PartyRole.PartyRoleBuilder>() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AffirmationBuilder setStatus(AffirmationStatusEnum status) {
            this.status = status == null ? null : status;
            return this;
        }

        @Override
        public Affirmation build() {
            return new AffirmationImpl(this);
        }

        @Override
        public AffirmationBuilder toBuilder() {
            return this;
        }

        @Override
        public AffirmationBuilder prune() {
            this.identifier = this.identifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.lineage != null && !this.lineage.prune().hasData()) {
                this.lineage = null;
            }
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyRole = this.partyRole.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getIdentifier() != null && this.getIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLineage() != null && this.getLineage().hasData()) {
                return true;
            }
            if (this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyRole() != null && this.getPartyRole().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getStatus() != null;
        }

        public AffirmationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AffirmationBuilder o = (AffirmationBuilder)other;
            merger.mergeRosetta(this.getIdentifier(), o.getIdentifier(), this::getOrCreateIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLineage(), (RosettaModelObjectBuilder)o.getLineage(), this::setLineage);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeRosetta(this.getPartyRole(), o.getPartyRole(), this::getOrCreatePartyRole);
            merger.mergeBasic((Object)this.getStatus(), (Object)o.getStatus(), this::setStatus, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Affirmation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.lineage, _that.getLineage())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            return Objects.equals((Object)this.status, (Object)_that.getStatus());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.lineage != null ? this.lineage.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.status != null ? ((Object)((Object)this.status)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AffirmationBuilder {identifier=" + this.identifier + ", lineage=" + this.lineage + ", party=" + this.party + ", partyRole=" + this.partyRole + ", status=" + (Object)((Object)this.status) + '}';
        }
    }

    public static class AffirmationImpl
    implements Affirmation {
        private final List<? extends Identifier> identifier;
        private final Lineage lineage;
        private final List<? extends Party> party;
        private final List<? extends PartyRole> partyRole;
        private final AffirmationStatusEnum status;

        protected AffirmationImpl(AffirmationBuilder builder) {
            this.identifier = Optional.ofNullable(builder.getIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.lineage = Optional.ofNullable(builder.getLineage()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyRole = Optional.ofNullable(builder.getPartyRole()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.status = builder.getStatus();
        }

        @Override
        public List<? extends Identifier> getIdentifier() {
            return this.identifier;
        }

        @Override
        public Lineage getLineage() {
            return this.lineage;
        }

        @Override
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public List<? extends PartyRole> getPartyRole() {
            return this.partyRole;
        }

        @Override
        public AffirmationStatusEnum getStatus() {
            return this.status;
        }

        @Override
        public Affirmation build() {
            return this;
        }

        @Override
        public AffirmationBuilder toBuilder() {
            AffirmationBuilder builder = Affirmation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AffirmationBuilder builder) {
            Optional.ofNullable(this.getIdentifier()).ifPresent(builder::setIdentifier);
            Optional.ofNullable(this.getLineage()).ifPresent(builder::setLineage);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getPartyRole()).ifPresent(builder::setPartyRole);
            Optional.ofNullable(this.getStatus()).ifPresent(builder::setStatus);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Affirmation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.lineage, _that.getLineage())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            return Objects.equals((Object)this.status, (Object)_that.getStatus());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.lineage != null ? this.lineage.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.status != null ? ((Object)((Object)this.status)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Affirmation {identifier=" + this.identifier + ", lineage=" + this.lineage + ", party=" + this.party + ", partyRole=" + this.partyRole + ", status=" + (Object)((Object)this.status) + '}';
        }
    }

    public static interface AffirmationBuilder
    extends Affirmation,
    RosettaModelObjectBuilder {
        public Identifier.IdentifierBuilder getOrCreateIdentifier(int var1);

        public List<? extends Identifier.IdentifierBuilder> getIdentifier();

        public Lineage.LineageBuilder getOrCreateLineage();

        @Override
        public Lineage.LineageBuilder getLineage();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int var1);

        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole();

        public AffirmationBuilder addIdentifier(Identifier var1);

        public AffirmationBuilder addIdentifier(Identifier var1, int var2);

        public AffirmationBuilder addIdentifier(List<? extends Identifier> var1);

        public AffirmationBuilder setIdentifier(List<? extends Identifier> var1);

        public AffirmationBuilder setLineage(Lineage var1);

        public AffirmationBuilder addParty(Party var1);

        public AffirmationBuilder addParty(Party var1, int var2);

        public AffirmationBuilder addParty(List<? extends Party> var1);

        public AffirmationBuilder setParty(List<? extends Party> var1);

        public AffirmationBuilder addPartyRole(PartyRole var1);

        public AffirmationBuilder addPartyRole(PartyRole var1, int var2);

        public AffirmationBuilder addPartyRole(List<? extends PartyRole> var1);

        public AffirmationBuilder setPartyRole(List<? extends PartyRole> var1);

        public AffirmationBuilder setStatus(AffirmationStatusEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("status"), AffirmationStatusEnum.class, (Object)this.getStatus(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("identifier"), processor, Identifier.IdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lineage"), processor, Lineage.LineageBuilder.class, this.getLineage(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRole(), new AttributeMeta[0]);
        }

        public AffirmationBuilder prune();
    }
}

