/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party;

import cdm.base.staticdata.party.BusinessUnit;
import cdm.base.staticdata.party.ContactInformation;
import cdm.base.staticdata.party.NaturalPerson;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.meta.PartyContactInformationMeta;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface PartyContactInformation
extends RosettaModelObject {
    public static final PartyContactInformationMeta metaData = new PartyContactInformationMeta();

    public PartyContactInformation build();

    public PartyContactInformationBuilder toBuilder();

    public String getAdditionalInformation();

    public List<? extends BusinessUnit> getBusinessUnit();

    public ContactInformation getContactInformation();

    public ReferenceWithMetaParty getPartyReference();

    public List<? extends NaturalPerson> getPerson();

    default public RosettaMetaData<? extends PartyContactInformation> metaData() {
        return metaData;
    }

    public static PartyContactInformationBuilder builder() {
        return new PartyContactInformationBuilderImpl();
    }

    default public Class<? extends PartyContactInformation> getType() {
        return PartyContactInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("additionalInformation"), String.class, (Object)this.getAdditionalInformation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessUnit"), processor, BusinessUnit.class, this.getBusinessUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contactInformation"), processor, ContactInformation.class, this.getContactInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("person"), processor, NaturalPerson.class, this.getPerson(), new AttributeMeta[0]);
    }

    public static class PartyContactInformationBuilderImpl
    implements PartyContactInformationBuilder {
        protected String additionalInformation;
        protected List<BusinessUnit.BusinessUnitBuilder> businessUnit = new ArrayList<BusinessUnit.BusinessUnitBuilder>();
        protected ContactInformation.ContactInformationBuilder contactInformation;
        protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder partyReference;
        protected List<NaturalPerson.NaturalPersonBuilder> person = new ArrayList<NaturalPerson.NaturalPersonBuilder>();

        @Override
        public String getAdditionalInformation() {
            return this.additionalInformation;
        }

        @Override
        public List<? extends BusinessUnit.BusinessUnitBuilder> getBusinessUnit() {
            return this.businessUnit;
        }

        @Override
        public BusinessUnit.BusinessUnitBuilder getOrCreateBusinessUnit(int _index) {
            if (this.businessUnit == null) {
                this.businessUnit = new ArrayList<BusinessUnit.BusinessUnitBuilder>();
            }
            return (BusinessUnit.BusinessUnitBuilder)this.getIndex(this.businessUnit, _index, () -> {
                BusinessUnit.BusinessUnitBuilder newBusinessUnit = BusinessUnit.builder();
                return newBusinessUnit;
            });
        }

        @Override
        public ContactInformation.ContactInformationBuilder getContactInformation() {
            return this.contactInformation;
        }

        @Override
        public ContactInformation.ContactInformationBuilder getOrCreateContactInformation() {
            ContactInformation.ContactInformationBuilder result = this.contactInformation != null ? this.contactInformation : (this.contactInformation = ContactInformation.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference() {
            ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = ReferenceWithMetaParty.builder());
            return result;
        }

        @Override
        public List<? extends NaturalPerson.NaturalPersonBuilder> getPerson() {
            return this.person;
        }

        @Override
        public NaturalPerson.NaturalPersonBuilder getOrCreatePerson(int _index) {
            if (this.person == null) {
                this.person = new ArrayList<NaturalPerson.NaturalPersonBuilder>();
            }
            return (NaturalPerson.NaturalPersonBuilder)this.getIndex(this.person, _index, () -> {
                NaturalPerson.NaturalPersonBuilder newPerson = NaturalPerson.builder();
                return newPerson;
            });
        }

        @Override
        public PartyContactInformationBuilder setAdditionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation == null ? null : additionalInformation;
            return this;
        }

        @Override
        public PartyContactInformationBuilder addBusinessUnit(BusinessUnit businessUnit) {
            if (businessUnit != null) {
                this.businessUnit.add(businessUnit.toBuilder());
            }
            return this;
        }

        @Override
        public PartyContactInformationBuilder addBusinessUnit(BusinessUnit businessUnit, int _idx) {
            this.getIndex(this.businessUnit, _idx, () -> businessUnit.toBuilder());
            return this;
        }

        @Override
        public PartyContactInformationBuilder addBusinessUnit(List<? extends BusinessUnit> businessUnits) {
            if (businessUnits != null) {
                for (BusinessUnit businessUnit : businessUnits) {
                    this.businessUnit.add(businessUnit.toBuilder());
                }
            }
            return this;
        }

        @Override
        public PartyContactInformationBuilder setBusinessUnit(List<? extends BusinessUnit> businessUnits) {
            this.businessUnit = businessUnits == null ? new ArrayList<BusinessUnit.BusinessUnitBuilder>() : (List)businessUnits.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PartyContactInformationBuilder setContactInformation(ContactInformation contactInformation) {
            this.contactInformation = contactInformation == null ? null : contactInformation.toBuilder();
            return this;
        }

        @Override
        public PartyContactInformationBuilder setPartyReference(ReferenceWithMetaParty partyReference) {
            this.partyReference = partyReference == null ? null : partyReference.toBuilder();
            return this;
        }

        @Override
        public PartyContactInformationBuilder setPartyReferenceValue(Party partyReference) {
            this.getOrCreatePartyReference().setValue(partyReference);
            return this;
        }

        @Override
        public PartyContactInformationBuilder addPerson(NaturalPerson person) {
            if (person != null) {
                this.person.add(person.toBuilder());
            }
            return this;
        }

        @Override
        public PartyContactInformationBuilder addPerson(NaturalPerson person, int _idx) {
            this.getIndex(this.person, _idx, () -> person.toBuilder());
            return this;
        }

        @Override
        public PartyContactInformationBuilder addPerson(List<? extends NaturalPerson> persons) {
            if (persons != null) {
                for (NaturalPerson naturalPerson : persons) {
                    this.person.add(naturalPerson.toBuilder());
                }
            }
            return this;
        }

        @Override
        public PartyContactInformationBuilder setPerson(List<? extends NaturalPerson> persons) {
            this.person = persons == null ? new ArrayList<NaturalPerson.NaturalPersonBuilder>() : (List)persons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PartyContactInformation build() {
            return new PartyContactInformationImpl(this);
        }

        @Override
        public PartyContactInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public PartyContactInformationBuilder prune() {
            this.businessUnit = this.businessUnit.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.contactInformation != null && !this.contactInformation.prune().hasData()) {
                this.contactInformation = null;
            }
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            this.person = this.person.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAdditionalInformation() != null) {
                return true;
            }
            if (this.getBusinessUnit() != null && this.getBusinessUnit().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getContactInformation() != null && this.getContactInformation().hasData()) {
                return true;
            }
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            return this.getPerson() != null && this.getPerson().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PartyContactInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PartyContactInformationBuilder o = (PartyContactInformationBuilder)other;
            merger.mergeRosetta(this.getBusinessUnit(), o.getBusinessUnit(), this::getOrCreateBusinessUnit);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContactInformation(), (RosettaModelObjectBuilder)o.getContactInformation(), this::setContactInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta(this.getPerson(), o.getPerson(), this::getOrCreatePerson);
            merger.mergeBasic((Object)this.getAdditionalInformation(), (Object)o.getAdditionalInformation(), this::setAdditionalInformation, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyContactInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.additionalInformation, _that.getAdditionalInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.businessUnit, _that.getBusinessUnit())) {
                return false;
            }
            if (!Objects.equals(this.contactInformation, _that.getContactInformation())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.person, _that.getPerson());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.additionalInformation != null ? this.additionalInformation.hashCode() : 0);
            _result = 31 * _result + (this.businessUnit != null ? this.businessUnit.hashCode() : 0);
            _result = 31 * _result + (this.contactInformation != null ? this.contactInformation.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.person != null ? this.person.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyContactInformationBuilder {additionalInformation=" + this.additionalInformation + ", businessUnit=" + this.businessUnit + ", contactInformation=" + this.contactInformation + ", partyReference=" + this.partyReference + ", person=" + this.person + '}';
        }
    }

    public static class PartyContactInformationImpl
    implements PartyContactInformation {
        private final String additionalInformation;
        private final List<? extends BusinessUnit> businessUnit;
        private final ContactInformation contactInformation;
        private final ReferenceWithMetaParty partyReference;
        private final List<? extends NaturalPerson> person;

        protected PartyContactInformationImpl(PartyContactInformationBuilder builder) {
            this.additionalInformation = builder.getAdditionalInformation();
            this.businessUnit = Optional.ofNullable(builder.getBusinessUnit()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.contactInformation = Optional.ofNullable(builder.getContactInformation()).map(f -> f.build()).orElse(null);
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.person = Optional.ofNullable(builder.getPerson()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public String getAdditionalInformation() {
            return this.additionalInformation;
        }

        @Override
        public List<? extends BusinessUnit> getBusinessUnit() {
            return this.businessUnit;
        }

        @Override
        public ContactInformation getContactInformation() {
            return this.contactInformation;
        }

        @Override
        public ReferenceWithMetaParty getPartyReference() {
            return this.partyReference;
        }

        @Override
        public List<? extends NaturalPerson> getPerson() {
            return this.person;
        }

        @Override
        public PartyContactInformation build() {
            return this;
        }

        @Override
        public PartyContactInformationBuilder toBuilder() {
            PartyContactInformationBuilder builder = PartyContactInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartyContactInformationBuilder builder) {
            Optional.ofNullable(this.getAdditionalInformation()).ifPresent(builder::setAdditionalInformation);
            Optional.ofNullable(this.getBusinessUnit()).ifPresent(builder::setBusinessUnit);
            Optional.ofNullable(this.getContactInformation()).ifPresent(builder::setContactInformation);
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getPerson()).ifPresent(builder::setPerson);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyContactInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.additionalInformation, _that.getAdditionalInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.businessUnit, _that.getBusinessUnit())) {
                return false;
            }
            if (!Objects.equals(this.contactInformation, _that.getContactInformation())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.person, _that.getPerson());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.additionalInformation != null ? this.additionalInformation.hashCode() : 0);
            _result = 31 * _result + (this.businessUnit != null ? this.businessUnit.hashCode() : 0);
            _result = 31 * _result + (this.contactInformation != null ? this.contactInformation.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.person != null ? this.person.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyContactInformation {additionalInformation=" + this.additionalInformation + ", businessUnit=" + this.businessUnit + ", contactInformation=" + this.contactInformation + ", partyReference=" + this.partyReference + ", person=" + this.person + '}';
        }
    }

    public static interface PartyContactInformationBuilder
    extends PartyContactInformation,
    RosettaModelObjectBuilder {
        public BusinessUnit.BusinessUnitBuilder getOrCreateBusinessUnit(int var1);

        public List<? extends BusinessUnit.BusinessUnitBuilder> getBusinessUnit();

        public ContactInformation.ContactInformationBuilder getOrCreateContactInformation();

        @Override
        public ContactInformation.ContactInformationBuilder getContactInformation();

        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference();

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference();

        public NaturalPerson.NaturalPersonBuilder getOrCreatePerson(int var1);

        public List<? extends NaturalPerson.NaturalPersonBuilder> getPerson();

        public PartyContactInformationBuilder setAdditionalInformation(String var1);

        public PartyContactInformationBuilder addBusinessUnit(BusinessUnit var1);

        public PartyContactInformationBuilder addBusinessUnit(BusinessUnit var1, int var2);

        public PartyContactInformationBuilder addBusinessUnit(List<? extends BusinessUnit> var1);

        public PartyContactInformationBuilder setBusinessUnit(List<? extends BusinessUnit> var1);

        public PartyContactInformationBuilder setContactInformation(ContactInformation var1);

        public PartyContactInformationBuilder setPartyReference(ReferenceWithMetaParty var1);

        public PartyContactInformationBuilder setPartyReferenceValue(Party var1);

        public PartyContactInformationBuilder addPerson(NaturalPerson var1);

        public PartyContactInformationBuilder addPerson(NaturalPerson var1, int var2);

        public PartyContactInformationBuilder addPerson(List<? extends NaturalPerson> var1);

        public PartyContactInformationBuilder setPerson(List<? extends NaturalPerson> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("additionalInformation"), String.class, (Object)this.getAdditionalInformation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessUnit"), processor, BusinessUnit.BusinessUnitBuilder.class, this.getBusinessUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contactInformation"), processor, ContactInformation.ContactInformationBuilder.class, this.getContactInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("person"), processor, NaturalPerson.NaturalPersonBuilder.class, this.getPerson(), new AttributeMeta[0]);
        }

        public PartyContactInformationBuilder prune();
    }
}

