/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party;

import cdm.base.staticdata.party.ContactInformation;
import cdm.base.staticdata.party.NaturalPersonRole;
import cdm.base.staticdata.party.PersonIdentifier;
import cdm.base.staticdata.party.meta.NaturalPersonMeta;
import cdm.base.staticdata.party.metafields.FieldWithMetaPersonIdentifier;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface NaturalPerson
extends RosettaModelObject,
GlobalKey {
    public static final NaturalPersonMeta metaData = new NaturalPersonMeta();

    public NaturalPerson build();

    public NaturalPersonBuilder toBuilder();

    public ContactInformation getContactInformation();

    public Date getDateOfBirth();

    public String getFirstName();

    public String getHonorific();

    public List<String> getInitial();

    public MetaFields getMeta();

    public List<String> getMiddleName();

    public List<? extends FieldWithMetaPersonIdentifier> getPersonId();

    public List<? extends NaturalPersonRole> getPersonRole();

    public String getSuffix();

    public String getSurname();

    default public RosettaMetaData<? extends NaturalPerson> metaData() {
        return metaData;
    }

    public static NaturalPersonBuilder builder() {
        return new NaturalPersonBuilderImpl();
    }

    default public Class<? extends NaturalPerson> getType() {
        return NaturalPerson.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("dateOfBirth"), Date.class, (Object)this.getDateOfBirth(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstName"), String.class, (Object)this.getFirstName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("honorific"), String.class, (Object)this.getHonorific(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initial"), String.class, this.getInitial(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("middleName"), String.class, this.getMiddleName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("suffix"), String.class, (Object)this.getSuffix(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("surname"), String.class, (Object)this.getSurname(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contactInformation"), processor, ContactInformation.class, this.getContactInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("personId"), processor, FieldWithMetaPersonIdentifier.class, this.getPersonId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("personRole"), processor, NaturalPersonRole.class, this.getPersonRole(), new AttributeMeta[0]);
    }

    public static class NaturalPersonBuilderImpl
    implements NaturalPersonBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected ContactInformation.ContactInformationBuilder contactInformation;
        protected Date dateOfBirth;
        protected String firstName;
        protected String honorific;
        protected List<String> initial = new ArrayList<String>();
        protected MetaFields.MetaFieldsBuilder meta;
        protected List<String> middleName = new ArrayList<String>();
        protected List<FieldWithMetaPersonIdentifier.FieldWithMetaPersonIdentifierBuilder> personId = new ArrayList<FieldWithMetaPersonIdentifier.FieldWithMetaPersonIdentifierBuilder>();
        protected List<NaturalPersonRole.NaturalPersonRoleBuilder> personRole = new ArrayList<NaturalPersonRole.NaturalPersonRoleBuilder>();
        protected String suffix;
        protected String surname;

        @Override
        public ContactInformation.ContactInformationBuilder getContactInformation() {
            return this.contactInformation;
        }

        @Override
        public ContactInformation.ContactInformationBuilder getOrCreateContactInformation() {
            ContactInformation.ContactInformationBuilder result = this.contactInformation != null ? this.contactInformation : (this.contactInformation = ContactInformation.builder());
            return result;
        }

        @Override
        public Date getDateOfBirth() {
            return this.dateOfBirth;
        }

        @Override
        public String getFirstName() {
            return this.firstName;
        }

        @Override
        public String getHonorific() {
            return this.honorific;
        }

        @Override
        public List<String> getInitial() {
            return this.initial;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public List<String> getMiddleName() {
            return this.middleName;
        }

        @Override
        public List<? extends FieldWithMetaPersonIdentifier.FieldWithMetaPersonIdentifierBuilder> getPersonId() {
            return this.personId;
        }

        @Override
        public FieldWithMetaPersonIdentifier.FieldWithMetaPersonIdentifierBuilder getOrCreatePersonId(int _index) {
            if (this.personId == null) {
                this.personId = new ArrayList<FieldWithMetaPersonIdentifier.FieldWithMetaPersonIdentifierBuilder>();
            }
            return (FieldWithMetaPersonIdentifier.FieldWithMetaPersonIdentifierBuilder)this.getIndex(this.personId, _index, () -> {
                FieldWithMetaPersonIdentifier.FieldWithMetaPersonIdentifierBuilder newPersonId = FieldWithMetaPersonIdentifier.builder();
                return newPersonId;
            });
        }

        @Override
        public List<? extends NaturalPersonRole.NaturalPersonRoleBuilder> getPersonRole() {
            return this.personRole;
        }

        @Override
        public NaturalPersonRole.NaturalPersonRoleBuilder getOrCreatePersonRole(int _index) {
            if (this.personRole == null) {
                this.personRole = new ArrayList<NaturalPersonRole.NaturalPersonRoleBuilder>();
            }
            return (NaturalPersonRole.NaturalPersonRoleBuilder)this.getIndex(this.personRole, _index, () -> {
                NaturalPersonRole.NaturalPersonRoleBuilder newPersonRole = NaturalPersonRole.builder();
                return newPersonRole;
            });
        }

        @Override
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public String getSurname() {
            return this.surname;
        }

        @Override
        public NaturalPersonBuilder setContactInformation(ContactInformation contactInformation) {
            this.contactInformation = contactInformation == null ? null : contactInformation.toBuilder();
            return this;
        }

        @Override
        public NaturalPersonBuilder setDateOfBirth(Date dateOfBirth) {
            this.dateOfBirth = dateOfBirth == null ? null : dateOfBirth;
            return this;
        }

        @Override
        public NaturalPersonBuilder setFirstName(String firstName) {
            this.firstName = firstName == null ? null : firstName;
            return this;
        }

        @Override
        public NaturalPersonBuilder setHonorific(String honorific) {
            this.honorific = honorific == null ? null : honorific;
            return this;
        }

        @Override
        public NaturalPersonBuilder addInitial(String initial) {
            if (initial != null) {
                this.initial.add(initial);
            }
            return this;
        }

        @Override
        public NaturalPersonBuilder addInitial(String initial, int _idx) {
            this.getIndex(this.initial, _idx, () -> initial);
            return this;
        }

        @Override
        public NaturalPersonBuilder addInitial(List<? extends String> initials) {
            if (initials != null) {
                for (String string : initials) {
                    this.initial.add(string);
                }
            }
            return this;
        }

        @Override
        public NaturalPersonBuilder setInitial(List<? extends String> initials) {
            this.initial = initials == null ? new ArrayList<String>() : (List)initials.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public NaturalPersonBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public NaturalPersonBuilder addMiddleName(String middleName) {
            if (middleName != null) {
                this.middleName.add(middleName);
            }
            return this;
        }

        @Override
        public NaturalPersonBuilder addMiddleName(String middleName, int _idx) {
            this.getIndex(this.middleName, _idx, () -> middleName);
            return this;
        }

        @Override
        public NaturalPersonBuilder addMiddleName(List<? extends String> middleNames) {
            if (middleNames != null) {
                for (String string : middleNames) {
                    this.middleName.add(string);
                }
            }
            return this;
        }

        @Override
        public NaturalPersonBuilder setMiddleName(List<? extends String> middleNames) {
            this.middleName = middleNames == null ? new ArrayList<String>() : (List)middleNames.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public NaturalPersonBuilder addPersonId(FieldWithMetaPersonIdentifier personId) {
            if (personId != null) {
                this.personId.add(personId.toBuilder());
            }
            return this;
        }

        @Override
        public NaturalPersonBuilder addPersonId(FieldWithMetaPersonIdentifier personId, int _idx) {
            this.getIndex(this.personId, _idx, () -> personId.toBuilder());
            return this;
        }

        @Override
        public NaturalPersonBuilder addPersonIdValue(PersonIdentifier personId) {
            this.getOrCreatePersonId(-1).setValue(personId.toBuilder());
            return this;
        }

        @Override
        public NaturalPersonBuilder addPersonIdValue(PersonIdentifier personId, int _idx) {
            this.getOrCreatePersonId(_idx).setValue(personId.toBuilder());
            return this;
        }

        @Override
        public NaturalPersonBuilder addPersonId(List<? extends FieldWithMetaPersonIdentifier> personIds) {
            if (personIds != null) {
                for (FieldWithMetaPersonIdentifier fieldWithMetaPersonIdentifier : personIds) {
                    this.personId.add(fieldWithMetaPersonIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public NaturalPersonBuilder setPersonId(List<? extends FieldWithMetaPersonIdentifier> personIds) {
            this.personId = personIds == null ? new ArrayList<FieldWithMetaPersonIdentifier.FieldWithMetaPersonIdentifierBuilder>() : (List)personIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public NaturalPersonBuilder addPersonIdValue(List<? extends PersonIdentifier> personIds) {
            if (personIds != null) {
                for (PersonIdentifier personIdentifier : personIds) {
                    this.addPersonIdValue(personIdentifier);
                }
            }
            return this;
        }

        @Override
        public NaturalPersonBuilder setPersonIdValue(List<? extends PersonIdentifier> personIds) {
            this.personId.clear();
            if (personIds != null) {
                personIds.forEach(this::addPersonIdValue);
            }
            return this;
        }

        @Override
        public NaturalPersonBuilder addPersonRole(NaturalPersonRole personRole) {
            if (personRole != null) {
                this.personRole.add(personRole.toBuilder());
            }
            return this;
        }

        @Override
        public NaturalPersonBuilder addPersonRole(NaturalPersonRole personRole, int _idx) {
            this.getIndex(this.personRole, _idx, () -> personRole.toBuilder());
            return this;
        }

        @Override
        public NaturalPersonBuilder addPersonRole(List<? extends NaturalPersonRole> personRoles) {
            if (personRoles != null) {
                for (NaturalPersonRole naturalPersonRole : personRoles) {
                    this.personRole.add(naturalPersonRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        public NaturalPersonBuilder setPersonRole(List<? extends NaturalPersonRole> personRoles) {
            this.personRole = personRoles == null ? new ArrayList<NaturalPersonRole.NaturalPersonRoleBuilder>() : (List)personRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public NaturalPersonBuilder setSuffix(String suffix) {
            this.suffix = suffix == null ? null : suffix;
            return this;
        }

        @Override
        public NaturalPersonBuilder setSurname(String surname) {
            this.surname = surname == null ? null : surname;
            return this;
        }

        @Override
        public NaturalPerson build() {
            return new NaturalPersonImpl(this);
        }

        @Override
        public NaturalPersonBuilder toBuilder() {
            return this;
        }

        @Override
        public NaturalPersonBuilder prune() {
            if (this.contactInformation != null && !this.contactInformation.prune().hasData()) {
                this.contactInformation = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            this.personId = this.personId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.personRole = this.personRole.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getContactInformation() != null && this.getContactInformation().hasData()) {
                return true;
            }
            if (this.getDateOfBirth() != null) {
                return true;
            }
            if (this.getFirstName() != null) {
                return true;
            }
            if (this.getHonorific() != null) {
                return true;
            }
            if (this.getInitial() != null && !this.getInitial().isEmpty()) {
                return true;
            }
            if (this.getMiddleName() != null && !this.getMiddleName().isEmpty()) {
                return true;
            }
            if (this.getPersonId() != null && this.getPersonId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPersonRole() != null && this.getPersonRole().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSuffix() != null) {
                return true;
            }
            return this.getSurname() != null;
        }

        public NaturalPersonBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            NaturalPersonBuilder o = (NaturalPersonBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContactInformation(), (RosettaModelObjectBuilder)o.getContactInformation(), this::setContactInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta(this.getPersonId(), o.getPersonId(), this::getOrCreatePersonId);
            merger.mergeRosetta(this.getPersonRole(), o.getPersonRole(), this::getOrCreatePersonRole);
            merger.mergeBasic((Object)this.getDateOfBirth(), (Object)o.getDateOfBirth(), this::setDateOfBirth, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFirstName(), (Object)o.getFirstName(), this::setFirstName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getHonorific(), (Object)o.getHonorific(), this::setHonorific, new AttributeMeta[0]);
            merger.mergeBasic(this.getInitial(), o.getInitial(), this::addInitial);
            merger.mergeBasic(this.getMiddleName(), o.getMiddleName(), this::addMiddleName);
            merger.mergeBasic((Object)this.getSuffix(), (Object)o.getSuffix(), this::setSuffix, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSurname(), (Object)o.getSurname(), this::setSurname, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NaturalPerson _that = this.getType().cast(o);
            if (!Objects.equals(this.contactInformation, _that.getContactInformation())) {
                return false;
            }
            if (!Objects.equals(this.dateOfBirth, _that.getDateOfBirth())) {
                return false;
            }
            if (!Objects.equals(this.firstName, _that.getFirstName())) {
                return false;
            }
            if (!Objects.equals(this.honorific, _that.getHonorific())) {
                return false;
            }
            if (!ListEquals.listEquals(this.initial, _that.getInitial())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.middleName, _that.getMiddleName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.personId, _that.getPersonId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.personRole, _that.getPersonRole())) {
                return false;
            }
            if (!Objects.equals(this.suffix, _that.getSuffix())) {
                return false;
            }
            return Objects.equals(this.surname, _that.getSurname());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.contactInformation != null ? this.contactInformation.hashCode() : 0);
            _result = 31 * _result + (this.dateOfBirth != null ? this.dateOfBirth.hashCode() : 0);
            _result = 31 * _result + (this.firstName != null ? this.firstName.hashCode() : 0);
            _result = 31 * _result + (this.honorific != null ? this.honorific.hashCode() : 0);
            _result = 31 * _result + (this.initial != null ? this.initial.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.middleName != null ? this.middleName.hashCode() : 0);
            _result = 31 * _result + (this.personId != null ? this.personId.hashCode() : 0);
            _result = 31 * _result + (this.personRole != null ? this.personRole.hashCode() : 0);
            _result = 31 * _result + (this.suffix != null ? this.suffix.hashCode() : 0);
            _result = 31 * _result + (this.surname != null ? this.surname.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NaturalPersonBuilder {contactInformation=" + this.contactInformation + ", dateOfBirth=" + this.dateOfBirth + ", firstName=" + this.firstName + ", honorific=" + this.honorific + ", initial=" + this.initial + ", meta=" + this.meta + ", middleName=" + this.middleName + ", personId=" + this.personId + ", personRole=" + this.personRole + ", suffix=" + this.suffix + ", surname=" + this.surname + '}';
        }
    }

    public static class NaturalPersonImpl
    implements NaturalPerson {
        private final ContactInformation contactInformation;
        private final Date dateOfBirth;
        private final String firstName;
        private final String honorific;
        private final List<String> initial;
        private final MetaFields meta;
        private final List<String> middleName;
        private final List<? extends FieldWithMetaPersonIdentifier> personId;
        private final List<? extends NaturalPersonRole> personRole;
        private final String suffix;
        private final String surname;

        protected NaturalPersonImpl(NaturalPersonBuilder builder) {
            this.contactInformation = Optional.ofNullable(builder.getContactInformation()).map(f -> f.build()).orElse(null);
            this.dateOfBirth = builder.getDateOfBirth();
            this.firstName = builder.getFirstName();
            this.honorific = builder.getHonorific();
            this.initial = Optional.ofNullable(builder.getInitial()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.middleName = Optional.ofNullable(builder.getMiddleName()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.personId = Optional.ofNullable(builder.getPersonId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.personRole = Optional.ofNullable(builder.getPersonRole()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.suffix = builder.getSuffix();
            this.surname = builder.getSurname();
        }

        @Override
        public ContactInformation getContactInformation() {
            return this.contactInformation;
        }

        @Override
        public Date getDateOfBirth() {
            return this.dateOfBirth;
        }

        @Override
        public String getFirstName() {
            return this.firstName;
        }

        @Override
        public String getHonorific() {
            return this.honorific;
        }

        @Override
        public List<String> getInitial() {
            return this.initial;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public List<String> getMiddleName() {
            return this.middleName;
        }

        @Override
        public List<? extends FieldWithMetaPersonIdentifier> getPersonId() {
            return this.personId;
        }

        @Override
        public List<? extends NaturalPersonRole> getPersonRole() {
            return this.personRole;
        }

        @Override
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public String getSurname() {
            return this.surname;
        }

        @Override
        public NaturalPerson build() {
            return this;
        }

        @Override
        public NaturalPersonBuilder toBuilder() {
            NaturalPersonBuilder builder = NaturalPerson.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NaturalPersonBuilder builder) {
            Optional.ofNullable(this.getContactInformation()).ifPresent(builder::setContactInformation);
            Optional.ofNullable(this.getDateOfBirth()).ifPresent(builder::setDateOfBirth);
            Optional.ofNullable(this.getFirstName()).ifPresent(builder::setFirstName);
            Optional.ofNullable(this.getHonorific()).ifPresent(builder::setHonorific);
            Optional.ofNullable(this.getInitial()).ifPresent(builder::setInitial);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getMiddleName()).ifPresent(builder::setMiddleName);
            Optional.ofNullable(this.getPersonId()).ifPresent(builder::setPersonId);
            Optional.ofNullable(this.getPersonRole()).ifPresent(builder::setPersonRole);
            Optional.ofNullable(this.getSuffix()).ifPresent(builder::setSuffix);
            Optional.ofNullable(this.getSurname()).ifPresent(builder::setSurname);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NaturalPerson _that = this.getType().cast(o);
            if (!Objects.equals(this.contactInformation, _that.getContactInformation())) {
                return false;
            }
            if (!Objects.equals(this.dateOfBirth, _that.getDateOfBirth())) {
                return false;
            }
            if (!Objects.equals(this.firstName, _that.getFirstName())) {
                return false;
            }
            if (!Objects.equals(this.honorific, _that.getHonorific())) {
                return false;
            }
            if (!ListEquals.listEquals(this.initial, _that.getInitial())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.middleName, _that.getMiddleName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.personId, _that.getPersonId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.personRole, _that.getPersonRole())) {
                return false;
            }
            if (!Objects.equals(this.suffix, _that.getSuffix())) {
                return false;
            }
            return Objects.equals(this.surname, _that.getSurname());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.contactInformation != null ? this.contactInformation.hashCode() : 0);
            _result = 31 * _result + (this.dateOfBirth != null ? this.dateOfBirth.hashCode() : 0);
            _result = 31 * _result + (this.firstName != null ? this.firstName.hashCode() : 0);
            _result = 31 * _result + (this.honorific != null ? this.honorific.hashCode() : 0);
            _result = 31 * _result + (this.initial != null ? this.initial.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.middleName != null ? this.middleName.hashCode() : 0);
            _result = 31 * _result + (this.personId != null ? this.personId.hashCode() : 0);
            _result = 31 * _result + (this.personRole != null ? this.personRole.hashCode() : 0);
            _result = 31 * _result + (this.suffix != null ? this.suffix.hashCode() : 0);
            _result = 31 * _result + (this.surname != null ? this.surname.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NaturalPerson {contactInformation=" + this.contactInformation + ", dateOfBirth=" + this.dateOfBirth + ", firstName=" + this.firstName + ", honorific=" + this.honorific + ", initial=" + this.initial + ", meta=" + this.meta + ", middleName=" + this.middleName + ", personId=" + this.personId + ", personRole=" + this.personRole + ", suffix=" + this.suffix + ", surname=" + this.surname + '}';
        }
    }

    public static interface NaturalPersonBuilder
    extends NaturalPerson,
    RosettaModelObjectBuilder {
        public ContactInformation.ContactInformationBuilder getOrCreateContactInformation();

        @Override
        public ContactInformation.ContactInformationBuilder getContactInformation();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public FieldWithMetaPersonIdentifier.FieldWithMetaPersonIdentifierBuilder getOrCreatePersonId(int var1);

        public List<? extends FieldWithMetaPersonIdentifier.FieldWithMetaPersonIdentifierBuilder> getPersonId();

        public NaturalPersonRole.NaturalPersonRoleBuilder getOrCreatePersonRole(int var1);

        public List<? extends NaturalPersonRole.NaturalPersonRoleBuilder> getPersonRole();

        public NaturalPersonBuilder setContactInformation(ContactInformation var1);

        public NaturalPersonBuilder setDateOfBirth(Date var1);

        public NaturalPersonBuilder setFirstName(String var1);

        public NaturalPersonBuilder setHonorific(String var1);

        public NaturalPersonBuilder addInitial(String var1);

        public NaturalPersonBuilder addInitial(String var1, int var2);

        public NaturalPersonBuilder addInitial(List<? extends String> var1);

        public NaturalPersonBuilder setInitial(List<? extends String> var1);

        public NaturalPersonBuilder setMeta(MetaFields var1);

        public NaturalPersonBuilder addMiddleName(String var1);

        public NaturalPersonBuilder addMiddleName(String var1, int var2);

        public NaturalPersonBuilder addMiddleName(List<? extends String> var1);

        public NaturalPersonBuilder setMiddleName(List<? extends String> var1);

        public NaturalPersonBuilder addPersonId(FieldWithMetaPersonIdentifier var1);

        public NaturalPersonBuilder addPersonId(FieldWithMetaPersonIdentifier var1, int var2);

        public NaturalPersonBuilder addPersonIdValue(PersonIdentifier var1);

        public NaturalPersonBuilder addPersonIdValue(PersonIdentifier var1, int var2);

        public NaturalPersonBuilder addPersonId(List<? extends FieldWithMetaPersonIdentifier> var1);

        public NaturalPersonBuilder setPersonId(List<? extends FieldWithMetaPersonIdentifier> var1);

        public NaturalPersonBuilder addPersonIdValue(List<? extends PersonIdentifier> var1);

        public NaturalPersonBuilder setPersonIdValue(List<? extends PersonIdentifier> var1);

        public NaturalPersonBuilder addPersonRole(NaturalPersonRole var1);

        public NaturalPersonBuilder addPersonRole(NaturalPersonRole var1, int var2);

        public NaturalPersonBuilder addPersonRole(List<? extends NaturalPersonRole> var1);

        public NaturalPersonBuilder setPersonRole(List<? extends NaturalPersonRole> var1);

        public NaturalPersonBuilder setSuffix(String var1);

        public NaturalPersonBuilder setSurname(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("dateOfBirth"), Date.class, (Object)this.getDateOfBirth(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstName"), String.class, (Object)this.getFirstName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("honorific"), String.class, (Object)this.getHonorific(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initial"), String.class, this.getInitial(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("middleName"), String.class, this.getMiddleName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("suffix"), String.class, (Object)this.getSuffix(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("surname"), String.class, (Object)this.getSurname(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contactInformation"), processor, ContactInformation.ContactInformationBuilder.class, this.getContactInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("personId"), processor, FieldWithMetaPersonIdentifier.FieldWithMetaPersonIdentifierBuilder.class, this.getPersonId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("personRole"), processor, NaturalPersonRole.NaturalPersonRoleBuilder.class, this.getPersonRole(), new AttributeMeta[0]);
        }

        public NaturalPersonBuilder prune();
    }
}

