/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party;

import cdm.base.staticdata.party.AccountTypeEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.meta.AccountMeta;
import cdm.base.staticdata.party.metafields.FieldWithMetaAccountTypeEnum;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface Account
extends RosettaModelObject,
GlobalKey {
    public static final AccountMeta metaData = new AccountMeta();

    public Account build();

    public AccountBuilder toBuilder();

    public ReferenceWithMetaParty getAccountBeneficiary();

    public FieldWithMetaString getAccountName();

    public FieldWithMetaString getAccountNumber();

    public FieldWithMetaAccountTypeEnum getAccountType();

    public MetaFields getMeta();

    public ReferenceWithMetaParty getPartyReference();

    public ReferenceWithMetaParty getServicingParty();

    default public RosettaMetaData<? extends Account> metaData() {
        return metaData;
    }

    public static AccountBuilder builder() {
        return new AccountBuilderImpl();
    }

    default public Class<? extends Account> getType() {
        return Account.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accountBeneficiary"), processor, ReferenceWithMetaParty.class, this.getAccountBeneficiary(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accountName"), processor, FieldWithMetaString.class, this.getAccountName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accountNumber"), processor, FieldWithMetaString.class, this.getAccountNumber(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accountType"), processor, FieldWithMetaAccountTypeEnum.class, this.getAccountType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("servicingParty"), processor, ReferenceWithMetaParty.class, this.getServicingParty(), new AttributeMeta[0]);
    }

    public static class AccountBuilderImpl
    implements AccountBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder accountBeneficiary;
        protected FieldWithMetaString.FieldWithMetaStringBuilder accountName;
        protected FieldWithMetaString.FieldWithMetaStringBuilder accountNumber;
        protected FieldWithMetaAccountTypeEnum.FieldWithMetaAccountTypeEnumBuilder accountType;
        protected MetaFields.MetaFieldsBuilder meta;
        protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder partyReference;
        protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder servicingParty;

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getAccountBeneficiary() {
            return this.accountBeneficiary;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateAccountBeneficiary() {
            ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder result = this.accountBeneficiary != null ? this.accountBeneficiary : (this.accountBeneficiary = ReferenceWithMetaParty.builder());
            return result;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getAccountName() {
            return this.accountName;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateAccountName() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.accountName != null ? this.accountName : (this.accountName = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getAccountNumber() {
            return this.accountNumber;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateAccountNumber() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.accountNumber != null ? this.accountNumber : (this.accountNumber = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public FieldWithMetaAccountTypeEnum.FieldWithMetaAccountTypeEnumBuilder getAccountType() {
            return this.accountType;
        }

        @Override
        public FieldWithMetaAccountTypeEnum.FieldWithMetaAccountTypeEnumBuilder getOrCreateAccountType() {
            FieldWithMetaAccountTypeEnum.FieldWithMetaAccountTypeEnumBuilder result = this.accountType != null ? this.accountType : (this.accountType = FieldWithMetaAccountTypeEnum.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference() {
            ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = ReferenceWithMetaParty.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getServicingParty() {
            return this.servicingParty;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateServicingParty() {
            ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder result = this.servicingParty != null ? this.servicingParty : (this.servicingParty = ReferenceWithMetaParty.builder());
            return result;
        }

        @Override
        public AccountBuilder setAccountBeneficiary(ReferenceWithMetaParty accountBeneficiary) {
            this.accountBeneficiary = accountBeneficiary == null ? null : accountBeneficiary.toBuilder();
            return this;
        }

        @Override
        public AccountBuilder setAccountBeneficiaryValue(Party accountBeneficiary) {
            this.getOrCreateAccountBeneficiary().setValue(accountBeneficiary);
            return this;
        }

        @Override
        public AccountBuilder setAccountName(FieldWithMetaString accountName) {
            this.accountName = accountName == null ? null : accountName.toBuilder();
            return this;
        }

        @Override
        public AccountBuilder setAccountNameValue(String accountName) {
            this.getOrCreateAccountName().setValue(accountName);
            return this;
        }

        @Override
        public AccountBuilder setAccountNumber(FieldWithMetaString accountNumber) {
            this.accountNumber = accountNumber == null ? null : accountNumber.toBuilder();
            return this;
        }

        @Override
        public AccountBuilder setAccountNumberValue(String accountNumber) {
            this.getOrCreateAccountNumber().setValue(accountNumber);
            return this;
        }

        @Override
        public AccountBuilder setAccountType(FieldWithMetaAccountTypeEnum accountType) {
            this.accountType = accountType == null ? null : accountType.toBuilder();
            return this;
        }

        @Override
        public AccountBuilder setAccountTypeValue(AccountTypeEnum accountType) {
            this.getOrCreateAccountType().setValue(accountType);
            return this;
        }

        @Override
        public AccountBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public AccountBuilder setPartyReference(ReferenceWithMetaParty partyReference) {
            this.partyReference = partyReference == null ? null : partyReference.toBuilder();
            return this;
        }

        @Override
        public AccountBuilder setPartyReferenceValue(Party partyReference) {
            this.getOrCreatePartyReference().setValue(partyReference);
            return this;
        }

        @Override
        public AccountBuilder setServicingParty(ReferenceWithMetaParty servicingParty) {
            this.servicingParty = servicingParty == null ? null : servicingParty.toBuilder();
            return this;
        }

        @Override
        public AccountBuilder setServicingPartyValue(Party servicingParty) {
            this.getOrCreateServicingParty().setValue(servicingParty);
            return this;
        }

        @Override
        public Account build() {
            return new AccountImpl(this);
        }

        @Override
        public AccountBuilder toBuilder() {
            return this;
        }

        @Override
        public AccountBuilder prune() {
            if (this.accountBeneficiary != null && !this.accountBeneficiary.prune().hasData()) {
                this.accountBeneficiary = null;
            }
            if (this.accountName != null && !this.accountName.prune().hasData()) {
                this.accountName = null;
            }
            if (this.accountNumber != null && !this.accountNumber.prune().hasData()) {
                this.accountNumber = null;
            }
            if (this.accountType != null && !this.accountType.prune().hasData()) {
                this.accountType = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            if (this.servicingParty != null && !this.servicingParty.prune().hasData()) {
                this.servicingParty = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAccountBeneficiary() != null && this.getAccountBeneficiary().hasData()) {
                return true;
            }
            if (this.getAccountName() != null) {
                return true;
            }
            if (this.getAccountNumber() != null) {
                return true;
            }
            if (this.getAccountType() != null) {
                return true;
            }
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            return this.getServicingParty() != null && this.getServicingParty().hasData();
        }

        public AccountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AccountBuilder o = (AccountBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccountBeneficiary(), (RosettaModelObjectBuilder)o.getAccountBeneficiary(), this::setAccountBeneficiary);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccountName(), (RosettaModelObjectBuilder)o.getAccountName(), this::setAccountName);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccountNumber(), (RosettaModelObjectBuilder)o.getAccountNumber(), this::setAccountNumber);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccountType(), (RosettaModelObjectBuilder)o.getAccountType(), this::setAccountType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getServicingParty(), (RosettaModelObjectBuilder)o.getServicingParty(), this::setServicingParty);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Account _that = this.getType().cast(o);
            if (!Objects.equals(this.accountBeneficiary, _that.getAccountBeneficiary())) {
                return false;
            }
            if (!Objects.equals(this.accountName, _that.getAccountName())) {
                return false;
            }
            if (!Objects.equals(this.accountNumber, _that.getAccountNumber())) {
                return false;
            }
            if (!Objects.equals(this.accountType, _that.getAccountType())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            return Objects.equals(this.servicingParty, _that.getServicingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accountBeneficiary != null ? this.accountBeneficiary.hashCode() : 0);
            _result = 31 * _result + (this.accountName != null ? this.accountName.hashCode() : 0);
            _result = 31 * _result + (this.accountNumber != null ? this.accountNumber.hashCode() : 0);
            _result = 31 * _result + (this.accountType != null ? this.accountType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.servicingParty != null ? this.servicingParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccountBuilder {accountBeneficiary=" + this.accountBeneficiary + ", accountName=" + this.accountName + ", accountNumber=" + this.accountNumber + ", accountType=" + this.accountType + ", meta=" + this.meta + ", partyReference=" + this.partyReference + ", servicingParty=" + this.servicingParty + '}';
        }
    }

    public static class AccountImpl
    implements Account {
        private final ReferenceWithMetaParty accountBeneficiary;
        private final FieldWithMetaString accountName;
        private final FieldWithMetaString accountNumber;
        private final FieldWithMetaAccountTypeEnum accountType;
        private final MetaFields meta;
        private final ReferenceWithMetaParty partyReference;
        private final ReferenceWithMetaParty servicingParty;

        protected AccountImpl(AccountBuilder builder) {
            this.accountBeneficiary = Optional.ofNullable(builder.getAccountBeneficiary()).map(f -> f.build()).orElse(null);
            this.accountName = Optional.ofNullable(builder.getAccountName()).map(f -> f.build()).orElse(null);
            this.accountNumber = Optional.ofNullable(builder.getAccountNumber()).map(f -> f.build()).orElse(null);
            this.accountType = Optional.ofNullable(builder.getAccountType()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.servicingParty = Optional.ofNullable(builder.getServicingParty()).map(f -> f.build()).orElse(null);
        }

        @Override
        public ReferenceWithMetaParty getAccountBeneficiary() {
            return this.accountBeneficiary;
        }

        @Override
        public FieldWithMetaString getAccountName() {
            return this.accountName;
        }

        @Override
        public FieldWithMetaString getAccountNumber() {
            return this.accountNumber;
        }

        @Override
        public FieldWithMetaAccountTypeEnum getAccountType() {
            return this.accountType;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public ReferenceWithMetaParty getPartyReference() {
            return this.partyReference;
        }

        @Override
        public ReferenceWithMetaParty getServicingParty() {
            return this.servicingParty;
        }

        @Override
        public Account build() {
            return this;
        }

        @Override
        public AccountBuilder toBuilder() {
            AccountBuilder builder = Account.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AccountBuilder builder) {
            Optional.ofNullable(this.getAccountBeneficiary()).ifPresent(builder::setAccountBeneficiary);
            Optional.ofNullable(this.getAccountName()).ifPresent(builder::setAccountName);
            Optional.ofNullable(this.getAccountNumber()).ifPresent(builder::setAccountNumber);
            Optional.ofNullable(this.getAccountType()).ifPresent(builder::setAccountType);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getServicingParty()).ifPresent(builder::setServicingParty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Account _that = this.getType().cast(o);
            if (!Objects.equals(this.accountBeneficiary, _that.getAccountBeneficiary())) {
                return false;
            }
            if (!Objects.equals(this.accountName, _that.getAccountName())) {
                return false;
            }
            if (!Objects.equals(this.accountNumber, _that.getAccountNumber())) {
                return false;
            }
            if (!Objects.equals(this.accountType, _that.getAccountType())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            return Objects.equals(this.servicingParty, _that.getServicingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accountBeneficiary != null ? this.accountBeneficiary.hashCode() : 0);
            _result = 31 * _result + (this.accountName != null ? this.accountName.hashCode() : 0);
            _result = 31 * _result + (this.accountNumber != null ? this.accountNumber.hashCode() : 0);
            _result = 31 * _result + (this.accountType != null ? this.accountType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.servicingParty != null ? this.servicingParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Account {accountBeneficiary=" + this.accountBeneficiary + ", accountName=" + this.accountName + ", accountNumber=" + this.accountNumber + ", accountType=" + this.accountType + ", meta=" + this.meta + ", partyReference=" + this.partyReference + ", servicingParty=" + this.servicingParty + '}';
        }
    }

    public static interface AccountBuilder
    extends Account,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateAccountBeneficiary();

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getAccountBeneficiary();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateAccountName();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getAccountName();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateAccountNumber();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getAccountNumber();

        public FieldWithMetaAccountTypeEnum.FieldWithMetaAccountTypeEnumBuilder getOrCreateAccountType();

        @Override
        public FieldWithMetaAccountTypeEnum.FieldWithMetaAccountTypeEnumBuilder getAccountType();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference();

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference();

        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateServicingParty();

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getServicingParty();

        public AccountBuilder setAccountBeneficiary(ReferenceWithMetaParty var1);

        public AccountBuilder setAccountBeneficiaryValue(Party var1);

        public AccountBuilder setAccountName(FieldWithMetaString var1);

        public AccountBuilder setAccountNameValue(String var1);

        public AccountBuilder setAccountNumber(FieldWithMetaString var1);

        public AccountBuilder setAccountNumberValue(String var1);

        public AccountBuilder setAccountType(FieldWithMetaAccountTypeEnum var1);

        public AccountBuilder setAccountTypeValue(AccountTypeEnum var1);

        public AccountBuilder setMeta(MetaFields var1);

        public AccountBuilder setPartyReference(ReferenceWithMetaParty var1);

        public AccountBuilder setPartyReferenceValue(Party var1);

        public AccountBuilder setServicingParty(ReferenceWithMetaParty var1);

        public AccountBuilder setServicingPartyValue(Party var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accountBeneficiary"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getAccountBeneficiary(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accountName"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getAccountName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accountNumber"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getAccountNumber(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accountType"), processor, FieldWithMetaAccountTypeEnum.FieldWithMetaAccountTypeEnumBuilder.class, this.getAccountType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("servicingParty"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getServicingParty(), new AttributeMeta[0]);
        }

        public AccountBuilder prune();
    }
}

