/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.identifier.validation.datarule;

import cdm.base.staticdata.identifier.Identifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

@RosettaDataRule(value="IdentifierIssuerChoice")
@ImplementedBy(value=Default.class)
public interface IdentifierIssuerChoice
extends Validator<Identifier> {
    public static final String NAME = "IdentifierIssuerChoice";
    public static final String DEFINITION = "required choice issuerReference, issuer";

    public ValidationResult<Identifier> validate(RosettaPath var1, Identifier var2);

    public static class NoOp
    implements IdentifierIssuerChoice {
        @Override
        public ValidationResult<Identifier> validate(RosettaPath path, Identifier identifier) {
            return ValidationResult.success((String)IdentifierIssuerChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Identifier", (RosettaPath)path, (String)IdentifierIssuerChoice.DEFINITION);
        }
    }

    public static class Default
    implements IdentifierIssuerChoice {
        @Override
        public ValidationResult<Identifier> validate(RosettaPath path, Identifier identifier) {
            ComparisonResult result = this.executeDataRule(identifier);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)IdentifierIssuerChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Identifier", (RosettaPath)path, (String)IdentifierIssuerChoice.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition IdentifierIssuerChoice failed.";
            }
            return ValidationResult.failure((String)IdentifierIssuerChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Identifier", (RosettaPath)path, (String)IdentifierIssuerChoice.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Identifier identifier) {
            try {
                ComparisonResult result = ExpressionOperators.choice((Mapper)MapperS.of((Object)identifier), Arrays.asList("issuerReference", "issuer"), (ValidationResult.ChoiceRuleValidationMethod)ValidationResult.ChoiceRuleValidationMethod.REQUIRED);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

