/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.identifier;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.meta.IdentifierMeta;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface Identifier
extends RosettaModelObject,
GlobalKey {
    public static final IdentifierMeta metaData = new IdentifierMeta();

    public Identifier build();

    public IdentifierBuilder toBuilder();

    public List<? extends AssignedIdentifier> getAssignedIdentifier();

    public FieldWithMetaString getIssuer();

    public ReferenceWithMetaParty getIssuerReference();

    public MetaFields getMeta();

    default public RosettaMetaData<? extends Identifier> metaData() {
        return metaData;
    }

    public static IdentifierBuilder builder() {
        return new IdentifierBuilderImpl();
    }

    default public Class<? extends Identifier> getType() {
        return Identifier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("assignedIdentifier"), processor, AssignedIdentifier.class, this.getAssignedIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuer"), processor, FieldWithMetaString.class, this.getIssuer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerReference"), processor, ReferenceWithMetaParty.class, this.getIssuerReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class IdentifierBuilderImpl
    implements IdentifierBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected List<AssignedIdentifier.AssignedIdentifierBuilder> assignedIdentifier = new ArrayList<AssignedIdentifier.AssignedIdentifierBuilder>();
        protected FieldWithMetaString.FieldWithMetaStringBuilder issuer;
        protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder issuerReference;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        public List<? extends AssignedIdentifier.AssignedIdentifierBuilder> getAssignedIdentifier() {
            return this.assignedIdentifier;
        }

        @Override
        public AssignedIdentifier.AssignedIdentifierBuilder getOrCreateAssignedIdentifier(int _index) {
            if (this.assignedIdentifier == null) {
                this.assignedIdentifier = new ArrayList<AssignedIdentifier.AssignedIdentifierBuilder>();
            }
            return (AssignedIdentifier.AssignedIdentifierBuilder)this.getIndex(this.assignedIdentifier, _index, () -> {
                AssignedIdentifier.AssignedIdentifierBuilder newAssignedIdentifier = AssignedIdentifier.builder();
                return newAssignedIdentifier;
            });
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getIssuer() {
            return this.issuer;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateIssuer() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.issuer != null ? this.issuer : (this.issuer = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getIssuerReference() {
            return this.issuerReference;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateIssuerReference() {
            ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder result = this.issuerReference != null ? this.issuerReference : (this.issuerReference = ReferenceWithMetaParty.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public IdentifierBuilder addAssignedIdentifier(AssignedIdentifier assignedIdentifier) {
            if (assignedIdentifier != null) {
                this.assignedIdentifier.add(assignedIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public IdentifierBuilder addAssignedIdentifier(AssignedIdentifier assignedIdentifier, int _idx) {
            this.getIndex(this.assignedIdentifier, _idx, () -> assignedIdentifier.toBuilder());
            return this;
        }

        @Override
        public IdentifierBuilder addAssignedIdentifier(List<? extends AssignedIdentifier> assignedIdentifiers) {
            if (assignedIdentifiers != null) {
                for (AssignedIdentifier assignedIdentifier : assignedIdentifiers) {
                    this.assignedIdentifier.add(assignedIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public IdentifierBuilder setAssignedIdentifier(List<? extends AssignedIdentifier> assignedIdentifiers) {
            this.assignedIdentifier = assignedIdentifiers == null ? new ArrayList<AssignedIdentifier.AssignedIdentifierBuilder>() : (List)assignedIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public IdentifierBuilder setIssuer(FieldWithMetaString issuer) {
            this.issuer = issuer == null ? null : issuer.toBuilder();
            return this;
        }

        @Override
        public IdentifierBuilder setIssuerValue(String issuer) {
            this.getOrCreateIssuer().setValue(issuer);
            return this;
        }

        @Override
        public IdentifierBuilder setIssuerReference(ReferenceWithMetaParty issuerReference) {
            this.issuerReference = issuerReference == null ? null : issuerReference.toBuilder();
            return this;
        }

        @Override
        public IdentifierBuilder setIssuerReferenceValue(Party issuerReference) {
            this.getOrCreateIssuerReference().setValue(issuerReference);
            return this;
        }

        @Override
        public IdentifierBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public Identifier build() {
            return new IdentifierImpl(this);
        }

        @Override
        public IdentifierBuilder toBuilder() {
            return this;
        }

        @Override
        public IdentifierBuilder prune() {
            this.assignedIdentifier = this.assignedIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.issuer != null && !this.issuer.prune().hasData()) {
                this.issuer = null;
            }
            if (this.issuerReference != null && !this.issuerReference.prune().hasData()) {
                this.issuerReference = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAssignedIdentifier() != null && this.getAssignedIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getIssuer() != null) {
                return true;
            }
            return this.getIssuerReference() != null && this.getIssuerReference().hasData();
        }

        public IdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            IdentifierBuilder o = (IdentifierBuilder)other;
            merger.mergeRosetta(this.getAssignedIdentifier(), o.getAssignedIdentifier(), this::getOrCreateAssignedIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuer(), (RosettaModelObjectBuilder)o.getIssuer(), this::setIssuer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuerReference(), (RosettaModelObjectBuilder)o.getIssuerReference(), this::setIssuerReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Identifier _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.assignedIdentifier, _that.getAssignedIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.issuer, _that.getIssuer())) {
                return false;
            }
            if (!Objects.equals(this.issuerReference, _that.getIssuerReference())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.assignedIdentifier != null ? this.assignedIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.issuer != null ? this.issuer.hashCode() : 0);
            _result = 31 * _result + (this.issuerReference != null ? this.issuerReference.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IdentifierBuilder {assignedIdentifier=" + this.assignedIdentifier + ", issuer=" + this.issuer + ", issuerReference=" + this.issuerReference + ", meta=" + this.meta + '}';
        }
    }

    public static class IdentifierImpl
    implements Identifier {
        private final List<? extends AssignedIdentifier> assignedIdentifier;
        private final FieldWithMetaString issuer;
        private final ReferenceWithMetaParty issuerReference;
        private final MetaFields meta;

        protected IdentifierImpl(IdentifierBuilder builder) {
            this.assignedIdentifier = Optional.ofNullable(builder.getAssignedIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.issuer = Optional.ofNullable(builder.getIssuer()).map(f -> f.build()).orElse(null);
            this.issuerReference = Optional.ofNullable(builder.getIssuerReference()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        public List<? extends AssignedIdentifier> getAssignedIdentifier() {
            return this.assignedIdentifier;
        }

        @Override
        public FieldWithMetaString getIssuer() {
            return this.issuer;
        }

        @Override
        public ReferenceWithMetaParty getIssuerReference() {
            return this.issuerReference;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Identifier build() {
            return this;
        }

        @Override
        public IdentifierBuilder toBuilder() {
            IdentifierBuilder builder = Identifier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IdentifierBuilder builder) {
            Optional.ofNullable(this.getAssignedIdentifier()).ifPresent(builder::setAssignedIdentifier);
            Optional.ofNullable(this.getIssuer()).ifPresent(builder::setIssuer);
            Optional.ofNullable(this.getIssuerReference()).ifPresent(builder::setIssuerReference);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Identifier _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.assignedIdentifier, _that.getAssignedIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.issuer, _that.getIssuer())) {
                return false;
            }
            if (!Objects.equals(this.issuerReference, _that.getIssuerReference())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.assignedIdentifier != null ? this.assignedIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.issuer != null ? this.issuer.hashCode() : 0);
            _result = 31 * _result + (this.issuerReference != null ? this.issuerReference.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Identifier {assignedIdentifier=" + this.assignedIdentifier + ", issuer=" + this.issuer + ", issuerReference=" + this.issuerReference + ", meta=" + this.meta + '}';
        }
    }

    public static interface IdentifierBuilder
    extends Identifier,
    RosettaModelObjectBuilder {
        public AssignedIdentifier.AssignedIdentifierBuilder getOrCreateAssignedIdentifier(int var1);

        public List<? extends AssignedIdentifier.AssignedIdentifierBuilder> getAssignedIdentifier();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateIssuer();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getIssuer();

        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateIssuerReference();

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getIssuerReference();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public IdentifierBuilder addAssignedIdentifier(AssignedIdentifier var1);

        public IdentifierBuilder addAssignedIdentifier(AssignedIdentifier var1, int var2);

        public IdentifierBuilder addAssignedIdentifier(List<? extends AssignedIdentifier> var1);

        public IdentifierBuilder setAssignedIdentifier(List<? extends AssignedIdentifier> var1);

        public IdentifierBuilder setIssuer(FieldWithMetaString var1);

        public IdentifierBuilder setIssuerValue(String var1);

        public IdentifierBuilder setIssuerReference(ReferenceWithMetaParty var1);

        public IdentifierBuilder setIssuerReferenceValue(Party var1);

        public IdentifierBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("assignedIdentifier"), processor, AssignedIdentifier.AssignedIdentifierBuilder.class, this.getAssignedIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuer"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getIssuer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerReference"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getIssuerReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        public IdentifierBuilder prune();
    }
}

