/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="SecurityDebtSubType")
@ImplementedBy(value=Default.class)
public interface SecurityDebtSubType
extends Validator<Security> {
    public static final String NAME = "SecurityDebtSubType";
    public static final String DEFINITION = "if securityType <> SecurityTypeEnum -> Debt then debtType is absent";

    public ValidationResult<Security> validate(RosettaPath var1, Security var2);

    public static class NoOp
    implements SecurityDebtSubType {
        @Override
        public ValidationResult<Security> validate(RosettaPath path, Security security) {
            return ValidationResult.success((String)SecurityDebtSubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Security", (RosettaPath)path, (String)SecurityDebtSubType.DEFINITION);
        }
    }

    public static class Default
    implements SecurityDebtSubType {
        @Override
        public ValidationResult<Security> validate(RosettaPath path, Security security) {
            ComparisonResult result = this.executeDataRule(security);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)SecurityDebtSubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Security", (RosettaPath)path, (String)SecurityDebtSubType.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition SecurityDebtSubType failed.";
            }
            return ValidationResult.failure((String)SecurityDebtSubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Security", (RosettaPath)path, (String)SecurityDebtSubType.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Security security) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.notEqual((Mapper)MapperS.of((Object)security).map("getSecurityType", _security -> _security.getSecurityType()), (Mapper)MapperS.of((Object)((Object)SecurityTypeEnum.DEBT)), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)security).map("getDebtType", _security -> _security.getDebtType()));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

