/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.CollateralTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="CollateralTaxonomyTaxonomyValue")
@ImplementedBy(value=Default.class)
public interface CollateralTaxonomyTaxonomyValue
extends Validator<CollateralTaxonomy> {
    public static final String NAME = "CollateralTaxonomyTaxonomyValue";
    public static final String DEFINITION = "if taxonomyValue -> nonEnumeratedTaxonomyValue exists then taxonomySource <> TaxonomySourceEnum -> EU_EMIR_EligibleCollateralAssetClass and taxonomySource <> TaxonomySourceEnum -> UK_EMIR_EligibleCollateralAssetClass and taxonomySource <> TaxonomySourceEnum -> US_CFTC_PR_EligibleCollateralAssetClass";

    public ValidationResult<CollateralTaxonomy> validate(RosettaPath var1, CollateralTaxonomy var2);

    public static class NoOp
    implements CollateralTaxonomyTaxonomyValue {
        @Override
        public ValidationResult<CollateralTaxonomy> validate(RosettaPath path, CollateralTaxonomy collateralTaxonomy) {
            return ValidationResult.success((String)CollateralTaxonomyTaxonomyValue.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralTaxonomy", (RosettaPath)path, (String)CollateralTaxonomyTaxonomyValue.DEFINITION);
        }
    }

    public static class Default
    implements CollateralTaxonomyTaxonomyValue {
        @Override
        public ValidationResult<CollateralTaxonomy> validate(RosettaPath path, CollateralTaxonomy collateralTaxonomy) {
            ComparisonResult result = this.executeDataRule(collateralTaxonomy);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)CollateralTaxonomyTaxonomyValue.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralTaxonomy", (RosettaPath)path, (String)CollateralTaxonomyTaxonomyValue.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition CollateralTaxonomyTaxonomyValue failed.";
            }
            return ValidationResult.failure((String)CollateralTaxonomyTaxonomyValue.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralTaxonomy", (RosettaPath)path, (String)CollateralTaxonomyTaxonomyValue.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(CollateralTaxonomy collateralTaxonomy) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)collateralTaxonomy).map("getTaxonomyValue", _collateralTaxonomy -> _collateralTaxonomy.getTaxonomyValue()).mapC("getNonEnumeratedTaxonomyValue", collateralTaxonomyValue -> collateralTaxonomyValue.getNonEnumeratedTaxonomyValue()).map("getValue", _f -> _f.getValue())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notEqual((Mapper)MapperS.of((Object)collateralTaxonomy).map("getTaxonomySource", _collateralTaxonomy -> _collateralTaxonomy.getTaxonomySource()), (Mapper)MapperS.of((Object)((Object)TaxonomySourceEnum.EU_EMIR_ELIGIBLE_COLLATERAL_ASSET_CLASS)), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)collateralTaxonomy).map("getTaxonomySource", _collateralTaxonomy -> _collateralTaxonomy.getTaxonomySource()), (Mapper)MapperS.of((Object)((Object)TaxonomySourceEnum.UK_EMIR_ELIGIBLE_COLLATERAL_ASSET_CLASS)), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)collateralTaxonomy).map("getTaxonomySource", _collateralTaxonomy -> _collateralTaxonomy.getTaxonomySource()), (Mapper)MapperS.of((Object)((Object)TaxonomySourceEnum.US_CFTC_PR_ELIGIBLE_COLLATERAL_ASSET_CLASS)), (CardinalityOperator)CardinalityOperator.Any));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

