/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.AssetType;
import cdm.base.staticdata.asset.common.AssetTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="AssetTypeSecuritySubType")
@ImplementedBy(value=Default.class)
public interface AssetTypeSecuritySubType
extends Validator<AssetType> {
    public static final String NAME = "AssetTypeSecuritySubType";
    public static final String DEFINITION = "if assetType <> AssetTypeEnum -> Security then securityType is absent and debtType is absent and equityType is absent and fundType is absent";

    public ValidationResult<AssetType> validate(RosettaPath var1, AssetType var2);

    public static class NoOp
    implements AssetTypeSecuritySubType {
        @Override
        public ValidationResult<AssetType> validate(RosettaPath path, AssetType assetType) {
            return ValidationResult.success((String)AssetTypeSecuritySubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetType", (RosettaPath)path, (String)AssetTypeSecuritySubType.DEFINITION);
        }
    }

    public static class Default
    implements AssetTypeSecuritySubType {
        @Override
        public ValidationResult<AssetType> validate(RosettaPath path, AssetType assetType) {
            ComparisonResult result = this.executeDataRule(assetType);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)AssetTypeSecuritySubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetType", (RosettaPath)path, (String)AssetTypeSecuritySubType.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition AssetTypeSecuritySubType failed.";
            }
            return ValidationResult.failure((String)AssetTypeSecuritySubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetType", (RosettaPath)path, (String)AssetTypeSecuritySubType.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(AssetType assetType) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.notEqual((Mapper)MapperS.of((Object)assetType).map("getAssetType", _assetType -> _assetType.getAssetType()), (Mapper)MapperS.of((Object)((Object)AssetTypeEnum.SECURITY)), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)assetType).map("getSecurityType", _assetType -> _assetType.getSecurityType())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)assetType).map("getDebtType", _assetType -> _assetType.getDebtType()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)assetType).map("getEquityType", _assetType -> _assetType.getEquityType()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)assetType).map("getFundType", _assetType -> _assetType.getFundType())));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

