/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum TaxonomySourceEnum {
    CFI,
    ISDA,
    ICAD,
    EMIR,
    EU_EMIR_ELIGIBLE_COLLATERAL_ASSET_CLASS,
    UK_EMIR_ELIGIBLE_COLLATERAL_ASSET_CLASS,
    US_CFTC_PR_ELIGIBLE_COLLATERAL_ASSET_CLASS,
    OTHER;

    private static Map<String, TaxonomySourceEnum> values;
    private final String displayName;

    private TaxonomySourceEnum() {
        this(null);
    }

    private TaxonomySourceEnum(String displayName) {
        this.displayName = displayName;
    }

    public static TaxonomySourceEnum fromDisplayName(String name) {
        TaxonomySourceEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, TaxonomySourceEnum> map = new ConcurrentHashMap<String, TaxonomySourceEnum>();
        for (TaxonomySourceEnum instance : TaxonomySourceEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

