/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum SecurityTypeEnum {
    DEBT,
    EQUITY,
    FUND,
    WARRANT,
    CERTIFICATE,
    LETTER_OF_CREDIT;

    private static Map<String, SecurityTypeEnum> values;
    private final String displayName;

    private SecurityTypeEnum() {
        this(null);
    }

    private SecurityTypeEnum(String displayName) {
        this.displayName = displayName;
    }

    public static SecurityTypeEnum fromDisplayName(String name) {
        SecurityTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, SecurityTypeEnum> map = new ConcurrentHashMap<String, SecurityTypeEnum>();
        for (SecurityTypeEnum instance : SecurityTypeEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

