/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.DebtType;
import cdm.base.staticdata.asset.common.EquityTypeEnum;
import cdm.base.staticdata.asset.common.FundProductTypeEnum;
import cdm.base.staticdata.asset.common.ProductBase;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import cdm.base.staticdata.asset.common.meta.SecurityMeta;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.template.EconomicTerms;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface Security
extends ProductBase {
    public static final SecurityMeta metaData = new SecurityMeta();

    @Override
    public Security build();

    @Override
    public SecurityBuilder toBuilder();

    public DebtType getDebtType();

    public EconomicTerms getEconomicTerms();

    public EquityTypeEnum getEquityType();

    public FundProductTypeEnum getFundType();

    public SecurityTypeEnum getSecurityType();

    default public RosettaMetaData<? extends Security> metaData() {
        return metaData;
    }

    public static SecurityBuilder builder() {
        return new SecurityBuilderImpl();
    }

    default public Class<? extends Security> getType() {
        return Security.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        ProductBase.super.process(path, processor);
        processor.processBasic(path.newSubPath("equityType"), EquityTypeEnum.class, (Object)this.getEquityType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fundType"), FundProductTypeEnum.class, (Object)this.getFundType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("securityType"), SecurityTypeEnum.class, (Object)this.getSecurityType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("debtType"), processor, DebtType.class, this.getDebtType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("economicTerms"), processor, EconomicTerms.class, this.getEconomicTerms(), new AttributeMeta[0]);
    }

    public static class SecurityBuilderImpl
    extends ProductBase.ProductBaseBuilderImpl
    implements SecurityBuilder {
        protected DebtType.DebtTypeBuilder debtType;
        protected EconomicTerms.EconomicTermsBuilder economicTerms;
        protected EquityTypeEnum equityType;
        protected FundProductTypeEnum fundType;
        protected SecurityTypeEnum securityType;

        @Override
        public DebtType.DebtTypeBuilder getDebtType() {
            return this.debtType;
        }

        @Override
        public DebtType.DebtTypeBuilder getOrCreateDebtType() {
            DebtType.DebtTypeBuilder result = this.debtType != null ? this.debtType : (this.debtType = DebtType.builder());
            return result;
        }

        @Override
        public EconomicTerms.EconomicTermsBuilder getEconomicTerms() {
            return this.economicTerms;
        }

        @Override
        public EconomicTerms.EconomicTermsBuilder getOrCreateEconomicTerms() {
            EconomicTerms.EconomicTermsBuilder result = this.economicTerms != null ? this.economicTerms : (this.economicTerms = EconomicTerms.builder());
            return result;
        }

        @Override
        public EquityTypeEnum getEquityType() {
            return this.equityType;
        }

        @Override
        public FundProductTypeEnum getFundType() {
            return this.fundType;
        }

        @Override
        public SecurityTypeEnum getSecurityType() {
            return this.securityType;
        }

        @Override
        public SecurityBuilder setDebtType(DebtType debtType) {
            this.debtType = debtType == null ? null : debtType.toBuilder();
            return this;
        }

        @Override
        public SecurityBuilder setEconomicTerms(EconomicTerms economicTerms) {
            this.economicTerms = economicTerms == null ? null : economicTerms.toBuilder();
            return this;
        }

        @Override
        public SecurityBuilder setEquityType(EquityTypeEnum equityType) {
            this.equityType = equityType == null ? null : equityType;
            return this;
        }

        @Override
        public SecurityBuilder setFundType(FundProductTypeEnum fundType) {
            this.fundType = fundType == null ? null : fundType;
            return this;
        }

        @Override
        public SecurityBuilder setSecurityType(SecurityTypeEnum securityType) {
            this.securityType = securityType == null ? null : securityType;
            return this;
        }

        @Override
        public SecurityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier productIdentifier) {
            if (productIdentifier != null) {
                this.productIdentifier.add(productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier productIdentifier, int _idx) {
            this.getIndex(this.productIdentifier, _idx, () -> productIdentifier.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addProductIdentifierValue(ProductIdentifier productIdentifier) {
            this.getOrCreateProductIdentifier(-1).setValue(productIdentifier.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addProductIdentifierValue(ProductIdentifier productIdentifier, int _idx) {
            this.getOrCreateProductIdentifier(_idx).setValue(productIdentifier.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier : productIdentifiers) {
                    this.productIdentifier.add(referenceWithMetaProductIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public SecurityBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public SecurityBuilder addProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.addProductIdentifierValue(productIdentifier);
                }
            }
            return this;
        }

        @Override
        public SecurityBuilder setProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier.clear();
            if (productIdentifiers != null) {
                productIdentifiers.forEach(this::addProductIdentifierValue);
            }
            return this;
        }

        @Override
        public SecurityBuilder addProductTaxonomy(ProductTaxonomy productTaxonomy) {
            if (productTaxonomy != null) {
                this.productTaxonomy.add(productTaxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityBuilder addProductTaxonomy(ProductTaxonomy productTaxonomy, int _idx) {
            this.getIndex(this.productTaxonomy, _idx, () -> productTaxonomy.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            if (productTaxonomys != null) {
                for (ProductTaxonomy productTaxonomy : productTaxonomys) {
                    this.productTaxonomy.add(productTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        public SecurityBuilder setProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            this.productTaxonomy = productTaxonomys == null ? new ArrayList() : (List)productTaxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Security build() {
            return new SecurityImpl(this);
        }

        @Override
        public SecurityBuilder toBuilder() {
            return this;
        }

        @Override
        public SecurityBuilder prune() {
            super.prune();
            if (this.debtType != null && !this.debtType.prune().hasData()) {
                this.debtType = null;
            }
            if (this.economicTerms != null && !this.economicTerms.prune().hasData()) {
                this.economicTerms = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDebtType() != null && this.getDebtType().hasData()) {
                return true;
            }
            if (this.getEconomicTerms() != null && this.getEconomicTerms().hasData()) {
                return true;
            }
            if (this.getEquityType() != null) {
                return true;
            }
            if (this.getFundType() != null) {
                return true;
            }
            return this.getSecurityType() != null;
        }

        @Override
        public SecurityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SecurityBuilder o = (SecurityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDebtType(), (RosettaModelObjectBuilder)o.getDebtType(), this::setDebtType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEconomicTerms(), (RosettaModelObjectBuilder)o.getEconomicTerms(), this::setEconomicTerms);
            merger.mergeBasic((Object)this.getEquityType(), (Object)o.getEquityType(), this::setEquityType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFundType(), (Object)o.getFundType(), this::setFundType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSecurityType(), (Object)o.getSecurityType(), this::setSecurityType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Security _that = (Security)this.getType().cast(o);
            if (!Objects.equals(this.debtType, _that.getDebtType())) {
                return false;
            }
            if (!Objects.equals(this.economicTerms, _that.getEconomicTerms())) {
                return false;
            }
            if (!Objects.equals((Object)this.equityType, (Object)_that.getEquityType())) {
                return false;
            }
            if (!Objects.equals((Object)this.fundType, (Object)_that.getFundType())) {
                return false;
            }
            return Objects.equals((Object)this.securityType, (Object)_that.getSecurityType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.debtType != null ? this.debtType.hashCode() : 0);
            _result = 31 * _result + (this.economicTerms != null ? this.economicTerms.hashCode() : 0);
            _result = 31 * _result + (this.equityType != null ? ((Object)((Object)this.equityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fundType != null ? ((Object)((Object)this.fundType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.securityType != null ? ((Object)((Object)this.securityType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SecurityBuilder {debtType=" + this.debtType + ", economicTerms=" + this.economicTerms + ", equityType=" + (Object)((Object)this.equityType) + ", fundType=" + (Object)((Object)this.fundType) + ", securityType=" + (Object)((Object)this.securityType) + '}' + " " + super.toString();
        }
    }

    public static class SecurityImpl
    extends ProductBase.ProductBaseImpl
    implements Security {
        private final DebtType debtType;
        private final EconomicTerms economicTerms;
        private final EquityTypeEnum equityType;
        private final FundProductTypeEnum fundType;
        private final SecurityTypeEnum securityType;

        protected SecurityImpl(SecurityBuilder builder) {
            super(builder);
            this.debtType = Optional.ofNullable(builder.getDebtType()).map(f -> f.build()).orElse(null);
            this.economicTerms = Optional.ofNullable(builder.getEconomicTerms()).map(f -> f.build()).orElse(null);
            this.equityType = builder.getEquityType();
            this.fundType = builder.getFundType();
            this.securityType = builder.getSecurityType();
        }

        @Override
        public DebtType getDebtType() {
            return this.debtType;
        }

        @Override
        public EconomicTerms getEconomicTerms() {
            return this.economicTerms;
        }

        @Override
        public EquityTypeEnum getEquityType() {
            return this.equityType;
        }

        @Override
        public FundProductTypeEnum getFundType() {
            return this.fundType;
        }

        @Override
        public SecurityTypeEnum getSecurityType() {
            return this.securityType;
        }

        @Override
        public Security build() {
            return this;
        }

        @Override
        public SecurityBuilder toBuilder() {
            SecurityBuilder builder = Security.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SecurityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDebtType()).ifPresent(builder::setDebtType);
            Optional.ofNullable(this.getEconomicTerms()).ifPresent(builder::setEconomicTerms);
            Optional.ofNullable(this.getEquityType()).ifPresent(builder::setEquityType);
            Optional.ofNullable(this.getFundType()).ifPresent(builder::setFundType);
            Optional.ofNullable(this.getSecurityType()).ifPresent(builder::setSecurityType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Security _that = (Security)this.getType().cast(o);
            if (!Objects.equals(this.debtType, _that.getDebtType())) {
                return false;
            }
            if (!Objects.equals(this.economicTerms, _that.getEconomicTerms())) {
                return false;
            }
            if (!Objects.equals((Object)this.equityType, (Object)_that.getEquityType())) {
                return false;
            }
            if (!Objects.equals((Object)this.fundType, (Object)_that.getFundType())) {
                return false;
            }
            return Objects.equals((Object)this.securityType, (Object)_that.getSecurityType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.debtType != null ? this.debtType.hashCode() : 0);
            _result = 31 * _result + (this.economicTerms != null ? this.economicTerms.hashCode() : 0);
            _result = 31 * _result + (this.equityType != null ? ((Object)((Object)this.equityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fundType != null ? ((Object)((Object)this.fundType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.securityType != null ? ((Object)((Object)this.securityType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Security {debtType=" + this.debtType + ", economicTerms=" + this.economicTerms + ", equityType=" + (Object)((Object)this.equityType) + ", fundType=" + (Object)((Object)this.fundType) + ", securityType=" + (Object)((Object)this.securityType) + '}' + " " + super.toString();
        }
    }

    public static interface SecurityBuilder
    extends Security,
    ProductBase.ProductBaseBuilder,
    RosettaModelObjectBuilder {
        public DebtType.DebtTypeBuilder getOrCreateDebtType();

        @Override
        public DebtType.DebtTypeBuilder getDebtType();

        public EconomicTerms.EconomicTermsBuilder getOrCreateEconomicTerms();

        @Override
        public EconomicTerms.EconomicTermsBuilder getEconomicTerms();

        public SecurityBuilder setDebtType(DebtType var1);

        public SecurityBuilder setEconomicTerms(EconomicTerms var1);

        public SecurityBuilder setEquityType(EquityTypeEnum var1);

        public SecurityBuilder setFundType(FundProductTypeEnum var1);

        public SecurityBuilder setSecurityType(SecurityTypeEnum var1);

        @Override
        public SecurityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1);

        @Override
        public SecurityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1, int var2);

        @Override
        public SecurityBuilder addProductIdentifierValue(ProductIdentifier var1);

        @Override
        public SecurityBuilder addProductIdentifierValue(ProductIdentifier var1, int var2);

        @Override
        public SecurityBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public SecurityBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public SecurityBuilder addProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public SecurityBuilder setProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public SecurityBuilder addProductTaxonomy(ProductTaxonomy var1);

        @Override
        public SecurityBuilder addProductTaxonomy(ProductTaxonomy var1, int var2);

        @Override
        public SecurityBuilder addProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public SecurityBuilder setProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            ProductBase.ProductBaseBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("equityType"), EquityTypeEnum.class, (Object)this.getEquityType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fundType"), FundProductTypeEnum.class, (Object)this.getFundType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("securityType"), SecurityTypeEnum.class, (Object)this.getSecurityType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("debtType"), processor, DebtType.DebtTypeBuilder.class, this.getDebtType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("economicTerms"), processor, EconomicTerms.EconomicTermsBuilder.class, this.getEconomicTerms(), new AttributeMeta[0]);
        }

        @Override
        public SecurityBuilder prune();
    }
}

