/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.TaxonomyValue;
import cdm.base.staticdata.asset.common.meta.ProductTaxonomyMeta;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaAssetClassEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface ProductTaxonomy
extends Taxonomy {
    public static final ProductTaxonomyMeta metaData = new ProductTaxonomyMeta();

    @Override
    public ProductTaxonomy build();

    @Override
    public ProductTaxonomyBuilder toBuilder();

    public FieldWithMetaAssetClassEnum getPrimaryAssetClass();

    public String getProductQualifier();

    public List<? extends FieldWithMetaAssetClassEnum> getSecondaryAssetClass();

    default public RosettaMetaData<? extends ProductTaxonomy> metaData() {
        return metaData;
    }

    public static ProductTaxonomyBuilder builder() {
        return new ProductTaxonomyBuilderImpl();
    }

    default public Class<? extends ProductTaxonomy> getType() {
        return ProductTaxonomy.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        Taxonomy.super.process(path, processor);
        processor.processBasic(path.newSubPath("productQualifier"), String.class, (Object)this.getProductQualifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("primaryAssetClass"), processor, FieldWithMetaAssetClassEnum.class, this.getPrimaryAssetClass(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("secondaryAssetClass"), processor, FieldWithMetaAssetClassEnum.class, this.getSecondaryAssetClass(), new AttributeMeta[0]);
    }

    public static class ProductTaxonomyBuilderImpl
    extends Taxonomy.TaxonomyBuilderImpl
    implements ProductTaxonomyBuilder {
        protected FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder primaryAssetClass;
        protected String productQualifier;
        protected List<FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder> secondaryAssetClass = new ArrayList<FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder>();

        @Override
        public FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        public FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder getOrCreatePrimaryAssetClass() {
            FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder result = this.primaryAssetClass != null ? this.primaryAssetClass : (this.primaryAssetClass = FieldWithMetaAssetClassEnum.builder());
            return result;
        }

        @Override
        public String getProductQualifier() {
            return this.productQualifier;
        }

        @Override
        public List<? extends FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder> getSecondaryAssetClass() {
            return this.secondaryAssetClass;
        }

        @Override
        public FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder getOrCreateSecondaryAssetClass(int _index) {
            if (this.secondaryAssetClass == null) {
                this.secondaryAssetClass = new ArrayList<FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder>();
            }
            return (FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder)this.getIndex(this.secondaryAssetClass, _index, () -> {
                FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder newSecondaryAssetClass = FieldWithMetaAssetClassEnum.builder();
                return newSecondaryAssetClass;
            });
        }

        @Override
        public ProductTaxonomyBuilder setPrimaryAssetClass(FieldWithMetaAssetClassEnum primaryAssetClass) {
            this.primaryAssetClass = primaryAssetClass == null ? null : primaryAssetClass.toBuilder();
            return this;
        }

        @Override
        public ProductTaxonomyBuilder setPrimaryAssetClassValue(AssetClassEnum primaryAssetClass) {
            this.getOrCreatePrimaryAssetClass().setValue(primaryAssetClass);
            return this;
        }

        @Override
        public ProductTaxonomyBuilder setProductQualifier(String productQualifier) {
            this.productQualifier = productQualifier == null ? null : productQualifier;
            return this;
        }

        @Override
        public ProductTaxonomyBuilder addSecondaryAssetClass(FieldWithMetaAssetClassEnum secondaryAssetClass) {
            if (secondaryAssetClass != null) {
                this.secondaryAssetClass.add(secondaryAssetClass.toBuilder());
            }
            return this;
        }

        @Override
        public ProductTaxonomyBuilder addSecondaryAssetClass(FieldWithMetaAssetClassEnum secondaryAssetClass, int _idx) {
            this.getIndex(this.secondaryAssetClass, _idx, () -> secondaryAssetClass.toBuilder());
            return this;
        }

        @Override
        public ProductTaxonomyBuilder addSecondaryAssetClassValue(AssetClassEnum secondaryAssetClass) {
            this.getOrCreateSecondaryAssetClass(-1).setValue(secondaryAssetClass);
            return this;
        }

        @Override
        public ProductTaxonomyBuilder addSecondaryAssetClassValue(AssetClassEnum secondaryAssetClass, int _idx) {
            this.getOrCreateSecondaryAssetClass(_idx).setValue(secondaryAssetClass);
            return this;
        }

        @Override
        public ProductTaxonomyBuilder addSecondaryAssetClass(List<? extends FieldWithMetaAssetClassEnum> secondaryAssetClasss) {
            if (secondaryAssetClasss != null) {
                for (FieldWithMetaAssetClassEnum fieldWithMetaAssetClassEnum : secondaryAssetClasss) {
                    this.secondaryAssetClass.add(fieldWithMetaAssetClassEnum.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ProductTaxonomyBuilder setSecondaryAssetClass(List<? extends FieldWithMetaAssetClassEnum> secondaryAssetClasss) {
            this.secondaryAssetClass = secondaryAssetClasss == null ? new ArrayList<FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder>() : (List)secondaryAssetClasss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ProductTaxonomyBuilder addSecondaryAssetClassValue(List<? extends AssetClassEnum> secondaryAssetClasss) {
            if (secondaryAssetClasss != null) {
                for (AssetClassEnum assetClassEnum : secondaryAssetClasss) {
                    this.addSecondaryAssetClassValue(assetClassEnum);
                }
            }
            return this;
        }

        @Override
        public ProductTaxonomyBuilder setSecondaryAssetClassValue(List<? extends AssetClassEnum> secondaryAssetClasss) {
            this.secondaryAssetClass.clear();
            if (secondaryAssetClasss != null) {
                secondaryAssetClasss.forEach(this::addSecondaryAssetClassValue);
            }
            return this;
        }

        @Override
        public ProductTaxonomyBuilder setSource(TaxonomySourceEnum source) {
            this.source = source == null ? null : source;
            return this;
        }

        @Override
        public ProductTaxonomyBuilder setValue(TaxonomyValue value) {
            this.value = value == null ? null : value.toBuilder();
            return this;
        }

        @Override
        public ProductTaxonomy build() {
            return new ProductTaxonomyImpl(this);
        }

        @Override
        public ProductTaxonomyBuilder toBuilder() {
            return this;
        }

        @Override
        public ProductTaxonomyBuilder prune() {
            super.prune();
            if (this.primaryAssetClass != null && !this.primaryAssetClass.prune().hasData()) {
                this.primaryAssetClass = null;
            }
            this.secondaryAssetClass = this.secondaryAssetClass.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPrimaryAssetClass() != null) {
                return true;
            }
            if (this.getProductQualifier() != null) {
                return true;
            }
            return this.getSecondaryAssetClass() != null && !this.getSecondaryAssetClass().isEmpty();
        }

        @Override
        public ProductTaxonomyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ProductTaxonomyBuilder o = (ProductTaxonomyBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryAssetClass(), (RosettaModelObjectBuilder)o.getPrimaryAssetClass(), this::setPrimaryAssetClass);
            merger.mergeRosetta(this.getSecondaryAssetClass(), o.getSecondaryAssetClass(), this::getOrCreateSecondaryAssetClass);
            merger.mergeBasic((Object)this.getProductQualifier(), (Object)o.getProductQualifier(), this::setProductQualifier, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ProductTaxonomy _that = (ProductTaxonomy)this.getType().cast(o);
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.productQualifier, _that.getProductQualifier())) {
                return false;
            }
            return ListEquals.listEquals(this.secondaryAssetClass, _that.getSecondaryAssetClass());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.productQualifier != null ? this.productQualifier.hashCode() : 0);
            _result = 31 * _result + (this.secondaryAssetClass != null ? this.secondaryAssetClass.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ProductTaxonomyBuilder {primaryAssetClass=" + this.primaryAssetClass + ", productQualifier=" + this.productQualifier + ", secondaryAssetClass=" + this.secondaryAssetClass + '}' + " " + super.toString();
        }
    }

    public static class ProductTaxonomyImpl
    extends Taxonomy.TaxonomyImpl
    implements ProductTaxonomy {
        private final FieldWithMetaAssetClassEnum primaryAssetClass;
        private final String productQualifier;
        private final List<? extends FieldWithMetaAssetClassEnum> secondaryAssetClass;

        protected ProductTaxonomyImpl(ProductTaxonomyBuilder builder) {
            super(builder);
            this.primaryAssetClass = Optional.ofNullable(builder.getPrimaryAssetClass()).map(f -> f.build()).orElse(null);
            this.productQualifier = builder.getProductQualifier();
            this.secondaryAssetClass = Optional.ofNullable(builder.getSecondaryAssetClass()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public FieldWithMetaAssetClassEnum getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        public String getProductQualifier() {
            return this.productQualifier;
        }

        @Override
        public List<? extends FieldWithMetaAssetClassEnum> getSecondaryAssetClass() {
            return this.secondaryAssetClass;
        }

        @Override
        public ProductTaxonomy build() {
            return this;
        }

        @Override
        public ProductTaxonomyBuilder toBuilder() {
            ProductTaxonomyBuilder builder = ProductTaxonomy.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ProductTaxonomyBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPrimaryAssetClass()).ifPresent(builder::setPrimaryAssetClass);
            Optional.ofNullable(this.getProductQualifier()).ifPresent(builder::setProductQualifier);
            Optional.ofNullable(this.getSecondaryAssetClass()).ifPresent(builder::setSecondaryAssetClass);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ProductTaxonomy _that = (ProductTaxonomy)this.getType().cast(o);
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.productQualifier, _that.getProductQualifier())) {
                return false;
            }
            return ListEquals.listEquals(this.secondaryAssetClass, _that.getSecondaryAssetClass());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.productQualifier != null ? this.productQualifier.hashCode() : 0);
            _result = 31 * _result + (this.secondaryAssetClass != null ? this.secondaryAssetClass.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ProductTaxonomy {primaryAssetClass=" + this.primaryAssetClass + ", productQualifier=" + this.productQualifier + ", secondaryAssetClass=" + this.secondaryAssetClass + '}' + " " + super.toString();
        }
    }

    public static interface ProductTaxonomyBuilder
    extends ProductTaxonomy,
    Taxonomy.TaxonomyBuilder,
    RosettaModelObjectBuilder {
        public FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder getOrCreatePrimaryAssetClass();

        @Override
        public FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder getPrimaryAssetClass();

        public FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder getOrCreateSecondaryAssetClass(int var1);

        public List<? extends FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder> getSecondaryAssetClass();

        public ProductTaxonomyBuilder setPrimaryAssetClass(FieldWithMetaAssetClassEnum var1);

        public ProductTaxonomyBuilder setPrimaryAssetClassValue(AssetClassEnum var1);

        public ProductTaxonomyBuilder setProductQualifier(String var1);

        public ProductTaxonomyBuilder addSecondaryAssetClass(FieldWithMetaAssetClassEnum var1);

        public ProductTaxonomyBuilder addSecondaryAssetClass(FieldWithMetaAssetClassEnum var1, int var2);

        public ProductTaxonomyBuilder addSecondaryAssetClassValue(AssetClassEnum var1);

        public ProductTaxonomyBuilder addSecondaryAssetClassValue(AssetClassEnum var1, int var2);

        public ProductTaxonomyBuilder addSecondaryAssetClass(List<? extends FieldWithMetaAssetClassEnum> var1);

        public ProductTaxonomyBuilder setSecondaryAssetClass(List<? extends FieldWithMetaAssetClassEnum> var1);

        public ProductTaxonomyBuilder addSecondaryAssetClassValue(List<? extends AssetClassEnum> var1);

        public ProductTaxonomyBuilder setSecondaryAssetClassValue(List<? extends AssetClassEnum> var1);

        @Override
        public ProductTaxonomyBuilder setSource(TaxonomySourceEnum var1);

        @Override
        public ProductTaxonomyBuilder setValue(TaxonomyValue var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            Taxonomy.TaxonomyBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("productQualifier"), String.class, (Object)this.getProductQualifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("primaryAssetClass"), processor, FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder.class, this.getPrimaryAssetClass(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("secondaryAssetClass"), processor, FieldWithMetaAssetClassEnum.FieldWithMetaAssetClassEnumBuilder.class, this.getSecondaryAssetClass(), new AttributeMeta[0]);
        }

        @Override
        public ProductTaxonomyBuilder prune();
    }
}

