/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum IssuerTypeEnum {
    SUPRA_NATIONAL,
    SOVEREIGN_CENTRAL_BANK,
    QUASI_GOVERNMENT,
    REGIONAL_GOVERNMENT,
    CORPORATE,
    FUND,
    SPECIAL_PURPOSE_VEHICLE;

    private static Map<String, IssuerTypeEnum> values;
    private final String displayName;

    private IssuerTypeEnum() {
        this(null);
    }

    private IssuerTypeEnum(String displayName) {
        this.displayName = displayName;
    }

    public static IssuerTypeEnum fromDisplayName(String name) {
        IssuerTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, IssuerTypeEnum> map = new ConcurrentHashMap<String, IssuerTypeEnum>();
        for (IssuerTypeEnum instance : IssuerTypeEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

