/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.Offset;
import cdm.base.staticdata.asset.common.meta.DeliveryDateParametersMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface DeliveryDateParameters
extends RosettaModelObject {
    public static final DeliveryDateParametersMeta metaData = new DeliveryDateParametersMeta();

    public DeliveryDateParameters build();

    public DeliveryDateParametersBuilder toBuilder();

    public AdjustableDate getDeliveryDate();

    public Offset getDeliveryDateExpirationConvention();

    public Offset getDeliveryDateRollConvention();

    public Offset getDeliveryNearby();

    default public RosettaMetaData<? extends DeliveryDateParameters> metaData() {
        return metaData;
    }

    public static DeliveryDateParametersBuilder builder() {
        return new DeliveryDateParametersBuilderImpl();
    }

    default public Class<? extends DeliveryDateParameters> getType() {
        return DeliveryDateParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("deliveryDate"), processor, AdjustableDate.class, this.getDeliveryDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryDateExpirationConvention"), processor, Offset.class, this.getDeliveryDateExpirationConvention(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryDateRollConvention"), processor, Offset.class, this.getDeliveryDateRollConvention(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryNearby"), processor, Offset.class, this.getDeliveryNearby(), new AttributeMeta[0]);
    }

    public static class DeliveryDateParametersBuilderImpl
    implements DeliveryDateParametersBuilder {
        protected AdjustableDate.AdjustableDateBuilder deliveryDate;
        protected Offset.OffsetBuilder deliveryDateExpirationConvention;
        protected Offset.OffsetBuilder deliveryDateRollConvention;
        protected Offset.OffsetBuilder deliveryNearby;

        @Override
        public AdjustableDate.AdjustableDateBuilder getDeliveryDate() {
            return this.deliveryDate;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getOrCreateDeliveryDate() {
            AdjustableDate.AdjustableDateBuilder result = this.deliveryDate != null ? this.deliveryDate : (this.deliveryDate = AdjustableDate.builder());
            return result;
        }

        @Override
        public Offset.OffsetBuilder getDeliveryDateExpirationConvention() {
            return this.deliveryDateExpirationConvention;
        }

        @Override
        public Offset.OffsetBuilder getOrCreateDeliveryDateExpirationConvention() {
            Offset.OffsetBuilder result = this.deliveryDateExpirationConvention != null ? this.deliveryDateExpirationConvention : (this.deliveryDateExpirationConvention = Offset.builder());
            return result;
        }

        @Override
        public Offset.OffsetBuilder getDeliveryDateRollConvention() {
            return this.deliveryDateRollConvention;
        }

        @Override
        public Offset.OffsetBuilder getOrCreateDeliveryDateRollConvention() {
            Offset.OffsetBuilder result = this.deliveryDateRollConvention != null ? this.deliveryDateRollConvention : (this.deliveryDateRollConvention = Offset.builder());
            return result;
        }

        @Override
        public Offset.OffsetBuilder getDeliveryNearby() {
            return this.deliveryNearby;
        }

        @Override
        public Offset.OffsetBuilder getOrCreateDeliveryNearby() {
            Offset.OffsetBuilder result = this.deliveryNearby != null ? this.deliveryNearby : (this.deliveryNearby = Offset.builder());
            return result;
        }

        @Override
        public DeliveryDateParametersBuilder setDeliveryDate(AdjustableDate deliveryDate) {
            this.deliveryDate = deliveryDate == null ? null : deliveryDate.toBuilder();
            return this;
        }

        @Override
        public DeliveryDateParametersBuilder setDeliveryDateExpirationConvention(Offset deliveryDateExpirationConvention) {
            this.deliveryDateExpirationConvention = deliveryDateExpirationConvention == null ? null : deliveryDateExpirationConvention.toBuilder();
            return this;
        }

        @Override
        public DeliveryDateParametersBuilder setDeliveryDateRollConvention(Offset deliveryDateRollConvention) {
            this.deliveryDateRollConvention = deliveryDateRollConvention == null ? null : deliveryDateRollConvention.toBuilder();
            return this;
        }

        @Override
        public DeliveryDateParametersBuilder setDeliveryNearby(Offset deliveryNearby) {
            this.deliveryNearby = deliveryNearby == null ? null : deliveryNearby.toBuilder();
            return this;
        }

        @Override
        public DeliveryDateParameters build() {
            return new DeliveryDateParametersImpl(this);
        }

        @Override
        public DeliveryDateParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public DeliveryDateParametersBuilder prune() {
            if (this.deliveryDate != null && !this.deliveryDate.prune().hasData()) {
                this.deliveryDate = null;
            }
            if (this.deliveryDateExpirationConvention != null && !this.deliveryDateExpirationConvention.prune().hasData()) {
                this.deliveryDateExpirationConvention = null;
            }
            if (this.deliveryDateRollConvention != null && !this.deliveryDateRollConvention.prune().hasData()) {
                this.deliveryDateRollConvention = null;
            }
            if (this.deliveryNearby != null && !this.deliveryNearby.prune().hasData()) {
                this.deliveryNearby = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDeliveryDate() != null && this.getDeliveryDate().hasData()) {
                return true;
            }
            if (this.getDeliveryDateExpirationConvention() != null && this.getDeliveryDateExpirationConvention().hasData()) {
                return true;
            }
            if (this.getDeliveryDateRollConvention() != null && this.getDeliveryDateRollConvention().hasData()) {
                return true;
            }
            return this.getDeliveryNearby() != null && this.getDeliveryNearby().hasData();
        }

        public DeliveryDateParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DeliveryDateParametersBuilder o = (DeliveryDateParametersBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryDate(), (RosettaModelObjectBuilder)o.getDeliveryDate(), this::setDeliveryDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryDateExpirationConvention(), (RosettaModelObjectBuilder)o.getDeliveryDateExpirationConvention(), this::setDeliveryDateExpirationConvention);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryDateRollConvention(), (RosettaModelObjectBuilder)o.getDeliveryDateRollConvention(), this::setDeliveryDateRollConvention);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryNearby(), (RosettaModelObjectBuilder)o.getDeliveryNearby(), this::setDeliveryNearby);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DeliveryDateParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryDate, _that.getDeliveryDate())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDateExpirationConvention, _that.getDeliveryDateExpirationConvention())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDateRollConvention, _that.getDeliveryDateRollConvention())) {
                return false;
            }
            return Objects.equals(this.deliveryNearby, _that.getDeliveryNearby());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryDate != null ? this.deliveryDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryDateExpirationConvention != null ? this.deliveryDateExpirationConvention.hashCode() : 0);
            _result = 31 * _result + (this.deliveryDateRollConvention != null ? this.deliveryDateRollConvention.hashCode() : 0);
            _result = 31 * _result + (this.deliveryNearby != null ? this.deliveryNearby.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DeliveryDateParametersBuilder {deliveryDate=" + this.deliveryDate + ", deliveryDateExpirationConvention=" + this.deliveryDateExpirationConvention + ", deliveryDateRollConvention=" + this.deliveryDateRollConvention + ", deliveryNearby=" + this.deliveryNearby + '}';
        }
    }

    public static class DeliveryDateParametersImpl
    implements DeliveryDateParameters {
        private final AdjustableDate deliveryDate;
        private final Offset deliveryDateExpirationConvention;
        private final Offset deliveryDateRollConvention;
        private final Offset deliveryNearby;

        protected DeliveryDateParametersImpl(DeliveryDateParametersBuilder builder) {
            this.deliveryDate = Optional.ofNullable(builder.getDeliveryDate()).map(f -> f.build()).orElse(null);
            this.deliveryDateExpirationConvention = Optional.ofNullable(builder.getDeliveryDateExpirationConvention()).map(f -> f.build()).orElse(null);
            this.deliveryDateRollConvention = Optional.ofNullable(builder.getDeliveryDateRollConvention()).map(f -> f.build()).orElse(null);
            this.deliveryNearby = Optional.ofNullable(builder.getDeliveryNearby()).map(f -> f.build()).orElse(null);
        }

        @Override
        public AdjustableDate getDeliveryDate() {
            return this.deliveryDate;
        }

        @Override
        public Offset getDeliveryDateExpirationConvention() {
            return this.deliveryDateExpirationConvention;
        }

        @Override
        public Offset getDeliveryDateRollConvention() {
            return this.deliveryDateRollConvention;
        }

        @Override
        public Offset getDeliveryNearby() {
            return this.deliveryNearby;
        }

        @Override
        public DeliveryDateParameters build() {
            return this;
        }

        @Override
        public DeliveryDateParametersBuilder toBuilder() {
            DeliveryDateParametersBuilder builder = DeliveryDateParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DeliveryDateParametersBuilder builder) {
            Optional.ofNullable(this.getDeliveryDate()).ifPresent(builder::setDeliveryDate);
            Optional.ofNullable(this.getDeliveryDateExpirationConvention()).ifPresent(builder::setDeliveryDateExpirationConvention);
            Optional.ofNullable(this.getDeliveryDateRollConvention()).ifPresent(builder::setDeliveryDateRollConvention);
            Optional.ofNullable(this.getDeliveryNearby()).ifPresent(builder::setDeliveryNearby);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DeliveryDateParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryDate, _that.getDeliveryDate())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDateExpirationConvention, _that.getDeliveryDateExpirationConvention())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDateRollConvention, _that.getDeliveryDateRollConvention())) {
                return false;
            }
            return Objects.equals(this.deliveryNearby, _that.getDeliveryNearby());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryDate != null ? this.deliveryDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryDateExpirationConvention != null ? this.deliveryDateExpirationConvention.hashCode() : 0);
            _result = 31 * _result + (this.deliveryDateRollConvention != null ? this.deliveryDateRollConvention.hashCode() : 0);
            _result = 31 * _result + (this.deliveryNearby != null ? this.deliveryNearby.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DeliveryDateParameters {deliveryDate=" + this.deliveryDate + ", deliveryDateExpirationConvention=" + this.deliveryDateExpirationConvention + ", deliveryDateRollConvention=" + this.deliveryDateRollConvention + ", deliveryNearby=" + this.deliveryNearby + '}';
        }
    }

    public static interface DeliveryDateParametersBuilder
    extends DeliveryDateParameters,
    RosettaModelObjectBuilder {
        public AdjustableDate.AdjustableDateBuilder getOrCreateDeliveryDate();

        @Override
        public AdjustableDate.AdjustableDateBuilder getDeliveryDate();

        public Offset.OffsetBuilder getOrCreateDeliveryDateExpirationConvention();

        @Override
        public Offset.OffsetBuilder getDeliveryDateExpirationConvention();

        public Offset.OffsetBuilder getOrCreateDeliveryDateRollConvention();

        @Override
        public Offset.OffsetBuilder getDeliveryDateRollConvention();

        public Offset.OffsetBuilder getOrCreateDeliveryNearby();

        @Override
        public Offset.OffsetBuilder getDeliveryNearby();

        public DeliveryDateParametersBuilder setDeliveryDate(AdjustableDate var1);

        public DeliveryDateParametersBuilder setDeliveryDateExpirationConvention(Offset var1);

        public DeliveryDateParametersBuilder setDeliveryDateRollConvention(Offset var1);

        public DeliveryDateParametersBuilder setDeliveryNearby(Offset var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("deliveryDate"), processor, AdjustableDate.AdjustableDateBuilder.class, this.getDeliveryDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryDateExpirationConvention"), processor, Offset.OffsetBuilder.class, this.getDeliveryDateExpirationConvention(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryDateRollConvention"), processor, Offset.OffsetBuilder.class, this.getDeliveryDateRollConvention(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryNearby"), processor, Offset.OffsetBuilder.class, this.getDeliveryNearby(), new AttributeMeta[0]);
        }

        public DeliveryDateParametersBuilder prune();
    }
}

