/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum DebtClassEnum {
    ASSET_BACKED,
    CONVERTIBLE,
    REG_CAP,
    STRUCTURED,
    VANILLA,
    HOLDER_CONVERTIBLE,
    HOLDER_EXCHANGEABLE,
    ISSUER_CONVERTIBLE,
    ISSUER_EXCHANGEABLE;

    private static Map<String, DebtClassEnum> values;
    private final String displayName;

    private DebtClassEnum() {
        this(null);
    }

    private DebtClassEnum(String displayName) {
        this.displayName = displayName;
    }

    public static DebtClassEnum fromDisplayName(String name) {
        DebtClassEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, DebtClassEnum> map = new ConcurrentHashMap<String, DebtClassEnum>();
        for (DebtClassEnum instance : DebtClassEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

