/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.CommodityInformationPublisherEnum;
import cdm.base.staticdata.asset.common.CommodityReferenceFramework;
import cdm.base.staticdata.asset.common.PriceSource;
import cdm.base.staticdata.asset.common.meta.CommodityProductDefinitionMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface CommodityProductDefinition
extends RosettaModelObject {
    public static final CommodityProductDefinitionMeta metaData = new CommodityProductDefinitionMeta();

    public CommodityProductDefinition build();

    public CommodityProductDefinitionBuilder toBuilder();

    public CommodityInformationPublisherEnum getCommodityInfoPublisher();

    public FieldWithMetaString getExchangeId();

    public PriceSource getPriceSource();

    public CommodityReferenceFramework getReferenceFramework();

    default public RosettaMetaData<? extends CommodityProductDefinition> metaData() {
        return metaData;
    }

    public static CommodityProductDefinitionBuilder builder() {
        return new CommodityProductDefinitionBuilderImpl();
    }

    default public Class<? extends CommodityProductDefinition> getType() {
        return CommodityProductDefinition.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("commodityInfoPublisher"), CommodityInformationPublisherEnum.class, (Object)this.getCommodityInfoPublisher(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, FieldWithMetaString.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSource"), processor, PriceSource.class, this.getPriceSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceFramework"), processor, CommodityReferenceFramework.class, this.getReferenceFramework(), new AttributeMeta[0]);
    }

    public static class CommodityProductDefinitionBuilderImpl
    implements CommodityProductDefinitionBuilder {
        protected CommodityInformationPublisherEnum commodityInfoPublisher;
        protected FieldWithMetaString.FieldWithMetaStringBuilder exchangeId;
        protected PriceSource.PriceSourceBuilder priceSource;
        protected CommodityReferenceFramework.CommodityReferenceFrameworkBuilder referenceFramework;

        @Override
        public CommodityInformationPublisherEnum getCommodityInfoPublisher() {
            return this.commodityInfoPublisher;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getExchangeId() {
            return this.exchangeId;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateExchangeId() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.exchangeId != null ? this.exchangeId : (this.exchangeId = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public PriceSource.PriceSourceBuilder getPriceSource() {
            return this.priceSource;
        }

        @Override
        public PriceSource.PriceSourceBuilder getOrCreatePriceSource() {
            PriceSource.PriceSourceBuilder result = this.priceSource != null ? this.priceSource : (this.priceSource = PriceSource.builder());
            return result;
        }

        @Override
        public CommodityReferenceFramework.CommodityReferenceFrameworkBuilder getReferenceFramework() {
            return this.referenceFramework;
        }

        @Override
        public CommodityReferenceFramework.CommodityReferenceFrameworkBuilder getOrCreateReferenceFramework() {
            CommodityReferenceFramework.CommodityReferenceFrameworkBuilder result = this.referenceFramework != null ? this.referenceFramework : (this.referenceFramework = CommodityReferenceFramework.builder());
            return result;
        }

        @Override
        public CommodityProductDefinitionBuilder setCommodityInfoPublisher(CommodityInformationPublisherEnum commodityInfoPublisher) {
            this.commodityInfoPublisher = commodityInfoPublisher == null ? null : commodityInfoPublisher;
            return this;
        }

        @Override
        public CommodityProductDefinitionBuilder setExchangeId(FieldWithMetaString exchangeId) {
            this.exchangeId = exchangeId == null ? null : exchangeId.toBuilder();
            return this;
        }

        @Override
        public CommodityProductDefinitionBuilder setExchangeIdValue(String exchangeId) {
            this.getOrCreateExchangeId().setValue(exchangeId);
            return this;
        }

        @Override
        public CommodityProductDefinitionBuilder setPriceSource(PriceSource priceSource) {
            this.priceSource = priceSource == null ? null : priceSource.toBuilder();
            return this;
        }

        @Override
        public CommodityProductDefinitionBuilder setReferenceFramework(CommodityReferenceFramework referenceFramework) {
            this.referenceFramework = referenceFramework == null ? null : referenceFramework.toBuilder();
            return this;
        }

        @Override
        public CommodityProductDefinition build() {
            return new CommodityProductDefinitionImpl(this);
        }

        @Override
        public CommodityProductDefinitionBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityProductDefinitionBuilder prune() {
            if (this.exchangeId != null && !this.exchangeId.prune().hasData()) {
                this.exchangeId = null;
            }
            if (this.priceSource != null && !this.priceSource.prune().hasData()) {
                this.priceSource = null;
            }
            if (this.referenceFramework != null && !this.referenceFramework.prune().hasData()) {
                this.referenceFramework = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCommodityInfoPublisher() != null) {
                return true;
            }
            if (this.getExchangeId() != null) {
                return true;
            }
            if (this.getPriceSource() != null && this.getPriceSource().hasData()) {
                return true;
            }
            return this.getReferenceFramework() != null && this.getReferenceFramework().hasData();
        }

        public CommodityProductDefinitionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityProductDefinitionBuilder o = (CommodityProductDefinitionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeId(), (RosettaModelObjectBuilder)o.getExchangeId(), this::setExchangeId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPriceSource(), (RosettaModelObjectBuilder)o.getPriceSource(), this::setPriceSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceFramework(), (RosettaModelObjectBuilder)o.getReferenceFramework(), this::setReferenceFramework);
            merger.mergeBasic((Object)this.getCommodityInfoPublisher(), (Object)o.getCommodityInfoPublisher(), this::setCommodityInfoPublisher, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityProductDefinition _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.commodityInfoPublisher, (Object)_that.getCommodityInfoPublisher())) {
                return false;
            }
            if (!Objects.equals(this.exchangeId, _that.getExchangeId())) {
                return false;
            }
            if (!Objects.equals(this.priceSource, _that.getPriceSource())) {
                return false;
            }
            return Objects.equals(this.referenceFramework, _that.getReferenceFramework());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commodityInfoPublisher != null ? ((Object)((Object)this.commodityInfoPublisher)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exchangeId != null ? this.exchangeId.hashCode() : 0);
            _result = 31 * _result + (this.priceSource != null ? this.priceSource.hashCode() : 0);
            _result = 31 * _result + (this.referenceFramework != null ? this.referenceFramework.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityProductDefinitionBuilder {commodityInfoPublisher=" + (Object)((Object)this.commodityInfoPublisher) + ", exchangeId=" + this.exchangeId + ", priceSource=" + this.priceSource + ", referenceFramework=" + this.referenceFramework + '}';
        }
    }

    public static class CommodityProductDefinitionImpl
    implements CommodityProductDefinition {
        private final CommodityInformationPublisherEnum commodityInfoPublisher;
        private final FieldWithMetaString exchangeId;
        private final PriceSource priceSource;
        private final CommodityReferenceFramework referenceFramework;

        protected CommodityProductDefinitionImpl(CommodityProductDefinitionBuilder builder) {
            this.commodityInfoPublisher = builder.getCommodityInfoPublisher();
            this.exchangeId = Optional.ofNullable(builder.getExchangeId()).map(f -> f.build()).orElse(null);
            this.priceSource = Optional.ofNullable(builder.getPriceSource()).map(f -> f.build()).orElse(null);
            this.referenceFramework = Optional.ofNullable(builder.getReferenceFramework()).map(f -> f.build()).orElse(null);
        }

        @Override
        public CommodityInformationPublisherEnum getCommodityInfoPublisher() {
            return this.commodityInfoPublisher;
        }

        @Override
        public FieldWithMetaString getExchangeId() {
            return this.exchangeId;
        }

        @Override
        public PriceSource getPriceSource() {
            return this.priceSource;
        }

        @Override
        public CommodityReferenceFramework getReferenceFramework() {
            return this.referenceFramework;
        }

        @Override
        public CommodityProductDefinition build() {
            return this;
        }

        @Override
        public CommodityProductDefinitionBuilder toBuilder() {
            CommodityProductDefinitionBuilder builder = CommodityProductDefinition.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityProductDefinitionBuilder builder) {
            Optional.ofNullable(this.getCommodityInfoPublisher()).ifPresent(builder::setCommodityInfoPublisher);
            Optional.ofNullable(this.getExchangeId()).ifPresent(builder::setExchangeId);
            Optional.ofNullable(this.getPriceSource()).ifPresent(builder::setPriceSource);
            Optional.ofNullable(this.getReferenceFramework()).ifPresent(builder::setReferenceFramework);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityProductDefinition _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.commodityInfoPublisher, (Object)_that.getCommodityInfoPublisher())) {
                return false;
            }
            if (!Objects.equals(this.exchangeId, _that.getExchangeId())) {
                return false;
            }
            if (!Objects.equals(this.priceSource, _that.getPriceSource())) {
                return false;
            }
            return Objects.equals(this.referenceFramework, _that.getReferenceFramework());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commodityInfoPublisher != null ? ((Object)((Object)this.commodityInfoPublisher)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exchangeId != null ? this.exchangeId.hashCode() : 0);
            _result = 31 * _result + (this.priceSource != null ? this.priceSource.hashCode() : 0);
            _result = 31 * _result + (this.referenceFramework != null ? this.referenceFramework.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityProductDefinition {commodityInfoPublisher=" + (Object)((Object)this.commodityInfoPublisher) + ", exchangeId=" + this.exchangeId + ", priceSource=" + this.priceSource + ", referenceFramework=" + this.referenceFramework + '}';
        }
    }

    public static interface CommodityProductDefinitionBuilder
    extends CommodityProductDefinition,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateExchangeId();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getExchangeId();

        public PriceSource.PriceSourceBuilder getOrCreatePriceSource();

        @Override
        public PriceSource.PriceSourceBuilder getPriceSource();

        public CommodityReferenceFramework.CommodityReferenceFrameworkBuilder getOrCreateReferenceFramework();

        @Override
        public CommodityReferenceFramework.CommodityReferenceFrameworkBuilder getReferenceFramework();

        public CommodityProductDefinitionBuilder setCommodityInfoPublisher(CommodityInformationPublisherEnum var1);

        public CommodityProductDefinitionBuilder setExchangeId(FieldWithMetaString var1);

        public CommodityProductDefinitionBuilder setExchangeIdValue(String var1);

        public CommodityProductDefinitionBuilder setPriceSource(PriceSource var1);

        public CommodityProductDefinitionBuilder setReferenceFramework(CommodityReferenceFramework var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("commodityInfoPublisher"), CommodityInformationPublisherEnum.class, (Object)this.getCommodityInfoPublisher(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSource"), processor, PriceSource.PriceSourceBuilder.class, this.getPriceSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceFramework"), processor, CommodityReferenceFramework.CommodityReferenceFrameworkBuilder.class, this.getReferenceFramework(), new AttributeMeta[0]);
        }

        public CommodityProductDefinitionBuilder prune();
    }
}

