/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.CommodityProductDefinition;
import cdm.base.staticdata.asset.common.DeliveryDateParameters;
import cdm.base.staticdata.asset.common.ProductBase;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.meta.CommodityMeta;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.observable.asset.QuotationSideEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface Commodity
extends ProductBase {
    public static final CommodityMeta metaData = new CommodityMeta();

    @Override
    public Commodity build();

    @Override
    public CommodityBuilder toBuilder();

    public CommodityProductDefinition getCommodityProductDefinition();

    public DeliveryDateParameters getDeliveryDateReference();

    public String getDescription();

    public QuotationSideEnum getPriceQuoteType();

    default public RosettaMetaData<? extends Commodity> metaData() {
        return metaData;
    }

    public static CommodityBuilder builder() {
        return new CommodityBuilderImpl();
    }

    default public Class<? extends Commodity> getType() {
        return Commodity.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        ProductBase.super.process(path, processor);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceQuoteType"), QuotationSideEnum.class, (Object)this.getPriceQuoteType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityProductDefinition"), processor, CommodityProductDefinition.class, this.getCommodityProductDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryDateReference"), processor, DeliveryDateParameters.class, this.getDeliveryDateReference(), new AttributeMeta[0]);
    }

    public static class CommodityBuilderImpl
    extends ProductBase.ProductBaseBuilderImpl
    implements CommodityBuilder {
        protected CommodityProductDefinition.CommodityProductDefinitionBuilder commodityProductDefinition;
        protected DeliveryDateParameters.DeliveryDateParametersBuilder deliveryDateReference;
        protected String description;
        protected QuotationSideEnum priceQuoteType;

        @Override
        public CommodityProductDefinition.CommodityProductDefinitionBuilder getCommodityProductDefinition() {
            return this.commodityProductDefinition;
        }

        @Override
        public CommodityProductDefinition.CommodityProductDefinitionBuilder getOrCreateCommodityProductDefinition() {
            CommodityProductDefinition.CommodityProductDefinitionBuilder result = this.commodityProductDefinition != null ? this.commodityProductDefinition : (this.commodityProductDefinition = CommodityProductDefinition.builder());
            return result;
        }

        @Override
        public DeliveryDateParameters.DeliveryDateParametersBuilder getDeliveryDateReference() {
            return this.deliveryDateReference;
        }

        @Override
        public DeliveryDateParameters.DeliveryDateParametersBuilder getOrCreateDeliveryDateReference() {
            DeliveryDateParameters.DeliveryDateParametersBuilder result = this.deliveryDateReference != null ? this.deliveryDateReference : (this.deliveryDateReference = DeliveryDateParameters.builder());
            return result;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public QuotationSideEnum getPriceQuoteType() {
            return this.priceQuoteType;
        }

        @Override
        public CommodityBuilder setCommodityProductDefinition(CommodityProductDefinition commodityProductDefinition) {
            this.commodityProductDefinition = commodityProductDefinition == null ? null : commodityProductDefinition.toBuilder();
            return this;
        }

        @Override
        public CommodityBuilder setDeliveryDateReference(DeliveryDateParameters deliveryDateReference) {
            this.deliveryDateReference = deliveryDateReference == null ? null : deliveryDateReference.toBuilder();
            return this;
        }

        @Override
        public CommodityBuilder setDescription(String description) {
            this.description = description == null ? null : description;
            return this;
        }

        @Override
        public CommodityBuilder setPriceQuoteType(QuotationSideEnum priceQuoteType) {
            this.priceQuoteType = priceQuoteType == null ? null : priceQuoteType;
            return this;
        }

        @Override
        public CommodityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier productIdentifier) {
            if (productIdentifier != null) {
                this.productIdentifier.add(productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier productIdentifier, int _idx) {
            this.getIndex(this.productIdentifier, _idx, () -> productIdentifier.toBuilder());
            return this;
        }

        @Override
        public CommodityBuilder addProductIdentifierValue(ProductIdentifier productIdentifier) {
            this.getOrCreateProductIdentifier(-1).setValue(productIdentifier.toBuilder());
            return this;
        }

        @Override
        public CommodityBuilder addProductIdentifierValue(ProductIdentifier productIdentifier, int _idx) {
            this.getOrCreateProductIdentifier(_idx).setValue(productIdentifier.toBuilder());
            return this;
        }

        @Override
        public CommodityBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier : productIdentifiers) {
                    this.productIdentifier.add(referenceWithMetaProductIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CommodityBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CommodityBuilder addProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.addProductIdentifierValue(productIdentifier);
                }
            }
            return this;
        }

        @Override
        public CommodityBuilder setProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier.clear();
            if (productIdentifiers != null) {
                productIdentifiers.forEach(this::addProductIdentifierValue);
            }
            return this;
        }

        @Override
        public CommodityBuilder addProductTaxonomy(ProductTaxonomy productTaxonomy) {
            if (productTaxonomy != null) {
                this.productTaxonomy.add(productTaxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityBuilder addProductTaxonomy(ProductTaxonomy productTaxonomy, int _idx) {
            this.getIndex(this.productTaxonomy, _idx, () -> productTaxonomy.toBuilder());
            return this;
        }

        @Override
        public CommodityBuilder addProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            if (productTaxonomys != null) {
                for (ProductTaxonomy productTaxonomy : productTaxonomys) {
                    this.productTaxonomy.add(productTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CommodityBuilder setProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            this.productTaxonomy = productTaxonomys == null ? new ArrayList() : (List)productTaxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Commodity build() {
            return new CommodityImpl(this);
        }

        @Override
        public CommodityBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityBuilder prune() {
            super.prune();
            if (this.commodityProductDefinition != null && !this.commodityProductDefinition.prune().hasData()) {
                this.commodityProductDefinition = null;
            }
            if (this.deliveryDateReference != null && !this.deliveryDateReference.prune().hasData()) {
                this.deliveryDateReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCommodityProductDefinition() != null && this.getCommodityProductDefinition().hasData()) {
                return true;
            }
            if (this.getDeliveryDateReference() != null && this.getDeliveryDateReference().hasData()) {
                return true;
            }
            if (this.getDescription() != null) {
                return true;
            }
            return this.getPriceQuoteType() != null;
        }

        @Override
        public CommodityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommodityBuilder o = (CommodityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityProductDefinition(), (RosettaModelObjectBuilder)o.getCommodityProductDefinition(), this::setCommodityProductDefinition);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryDateReference(), (RosettaModelObjectBuilder)o.getDeliveryDateReference(), this::setDeliveryDateReference);
            merger.mergeBasic((Object)this.getDescription(), (Object)o.getDescription(), this::setDescription, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceQuoteType(), (Object)o.getPriceQuoteType(), this::setPriceQuoteType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Commodity _that = (Commodity)this.getType().cast(o);
            if (!Objects.equals(this.commodityProductDefinition, _that.getCommodityProductDefinition())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDateReference, _that.getDeliveryDateReference())) {
                return false;
            }
            if (!Objects.equals(this.description, _that.getDescription())) {
                return false;
            }
            return Objects.equals((Object)this.priceQuoteType, (Object)_that.getPriceQuoteType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.commodityProductDefinition != null ? this.commodityProductDefinition.hashCode() : 0);
            _result = 31 * _result + (this.deliveryDateReference != null ? this.deliveryDateReference.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            _result = 31 * _result + (this.priceQuoteType != null ? ((Object)((Object)this.priceQuoteType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityBuilder {commodityProductDefinition=" + this.commodityProductDefinition + ", deliveryDateReference=" + this.deliveryDateReference + ", description=" + this.description + ", priceQuoteType=" + (Object)((Object)this.priceQuoteType) + '}' + " " + super.toString();
        }
    }

    public static class CommodityImpl
    extends ProductBase.ProductBaseImpl
    implements Commodity {
        private final CommodityProductDefinition commodityProductDefinition;
        private final DeliveryDateParameters deliveryDateReference;
        private final String description;
        private final QuotationSideEnum priceQuoteType;

        protected CommodityImpl(CommodityBuilder builder) {
            super(builder);
            this.commodityProductDefinition = Optional.ofNullable(builder.getCommodityProductDefinition()).map(f -> f.build()).orElse(null);
            this.deliveryDateReference = Optional.ofNullable(builder.getDeliveryDateReference()).map(f -> f.build()).orElse(null);
            this.description = builder.getDescription();
            this.priceQuoteType = builder.getPriceQuoteType();
        }

        @Override
        public CommodityProductDefinition getCommodityProductDefinition() {
            return this.commodityProductDefinition;
        }

        @Override
        public DeliveryDateParameters getDeliveryDateReference() {
            return this.deliveryDateReference;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public QuotationSideEnum getPriceQuoteType() {
            return this.priceQuoteType;
        }

        @Override
        public Commodity build() {
            return this;
        }

        @Override
        public CommodityBuilder toBuilder() {
            CommodityBuilder builder = Commodity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCommodityProductDefinition()).ifPresent(builder::setCommodityProductDefinition);
            Optional.ofNullable(this.getDeliveryDateReference()).ifPresent(builder::setDeliveryDateReference);
            Optional.ofNullable(this.getDescription()).ifPresent(builder::setDescription);
            Optional.ofNullable(this.getPriceQuoteType()).ifPresent(builder::setPriceQuoteType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Commodity _that = (Commodity)this.getType().cast(o);
            if (!Objects.equals(this.commodityProductDefinition, _that.getCommodityProductDefinition())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDateReference, _that.getDeliveryDateReference())) {
                return false;
            }
            if (!Objects.equals(this.description, _that.getDescription())) {
                return false;
            }
            return Objects.equals((Object)this.priceQuoteType, (Object)_that.getPriceQuoteType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.commodityProductDefinition != null ? this.commodityProductDefinition.hashCode() : 0);
            _result = 31 * _result + (this.deliveryDateReference != null ? this.deliveryDateReference.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            _result = 31 * _result + (this.priceQuoteType != null ? ((Object)((Object)this.priceQuoteType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Commodity {commodityProductDefinition=" + this.commodityProductDefinition + ", deliveryDateReference=" + this.deliveryDateReference + ", description=" + this.description + ", priceQuoteType=" + (Object)((Object)this.priceQuoteType) + '}' + " " + super.toString();
        }
    }

    public static interface CommodityBuilder
    extends Commodity,
    ProductBase.ProductBaseBuilder,
    RosettaModelObjectBuilder {
        public CommodityProductDefinition.CommodityProductDefinitionBuilder getOrCreateCommodityProductDefinition();

        @Override
        public CommodityProductDefinition.CommodityProductDefinitionBuilder getCommodityProductDefinition();

        public DeliveryDateParameters.DeliveryDateParametersBuilder getOrCreateDeliveryDateReference();

        @Override
        public DeliveryDateParameters.DeliveryDateParametersBuilder getDeliveryDateReference();

        public CommodityBuilder setCommodityProductDefinition(CommodityProductDefinition var1);

        public CommodityBuilder setDeliveryDateReference(DeliveryDateParameters var1);

        public CommodityBuilder setDescription(String var1);

        public CommodityBuilder setPriceQuoteType(QuotationSideEnum var1);

        @Override
        public CommodityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1);

        @Override
        public CommodityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1, int var2);

        @Override
        public CommodityBuilder addProductIdentifierValue(ProductIdentifier var1);

        @Override
        public CommodityBuilder addProductIdentifierValue(ProductIdentifier var1, int var2);

        @Override
        public CommodityBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public CommodityBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public CommodityBuilder addProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public CommodityBuilder setProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public CommodityBuilder addProductTaxonomy(ProductTaxonomy var1);

        @Override
        public CommodityBuilder addProductTaxonomy(ProductTaxonomy var1, int var2);

        @Override
        public CommodityBuilder addProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public CommodityBuilder setProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            ProductBase.ProductBaseBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceQuoteType"), QuotationSideEnum.class, (Object)this.getPriceQuoteType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityProductDefinition"), processor, CommodityProductDefinition.CommodityProductDefinitionBuilder.class, this.getCommodityProductDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryDateReference"), processor, DeliveryDateParameters.DeliveryDateParametersBuilder.class, this.getDeliveryDateReference(), new AttributeMeta[0]);
        }

        @Override
        public CommodityBuilder prune();
    }
}

