/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.meta.AssetPoolMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface AssetPool
extends RosettaModelObject {
    public static final AssetPoolMeta metaData = new AssetPoolMeta();

    public AssetPool build();

    public AssetPoolBuilder toBuilder();

    public BigDecimal getCurrentFactor();

    public Date getEffectiveDate();

    public BigDecimal getInitialFactor();

    public String getVersion();

    default public RosettaMetaData<? extends AssetPool> metaData() {
        return metaData;
    }

    public static AssetPoolBuilder builder() {
        return new AssetPoolBuilderImpl();
    }

    default public Class<? extends AssetPool> getType() {
        return AssetPool.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("currentFactor"), BigDecimal.class, (Object)this.getCurrentFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialFactor"), BigDecimal.class, (Object)this.getInitialFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AssetPoolBuilderImpl
    implements AssetPoolBuilder {
        protected BigDecimal currentFactor;
        protected Date effectiveDate;
        protected BigDecimal initialFactor;
        protected String version;

        @Override
        public BigDecimal getCurrentFactor() {
            return this.currentFactor;
        }

        @Override
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public BigDecimal getInitialFactor() {
            return this.initialFactor;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public AssetPoolBuilder setCurrentFactor(BigDecimal currentFactor) {
            this.currentFactor = currentFactor == null ? null : currentFactor;
            return this;
        }

        @Override
        public AssetPoolBuilder setEffectiveDate(Date effectiveDate) {
            this.effectiveDate = effectiveDate == null ? null : effectiveDate;
            return this;
        }

        @Override
        public AssetPoolBuilder setInitialFactor(BigDecimal initialFactor) {
            this.initialFactor = initialFactor == null ? null : initialFactor;
            return this;
        }

        @Override
        public AssetPoolBuilder setVersion(String version) {
            this.version = version == null ? null : version;
            return this;
        }

        @Override
        public AssetPool build() {
            return new AssetPoolImpl(this);
        }

        @Override
        public AssetPoolBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetPoolBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getCurrentFactor() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getInitialFactor() != null) {
                return true;
            }
            return this.getVersion() != null;
        }

        public AssetPoolBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetPoolBuilder o = (AssetPoolBuilder)other;
            merger.mergeBasic((Object)this.getCurrentFactor(), (Object)o.getCurrentFactor(), this::setCurrentFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialFactor(), (Object)o.getInitialFactor(), this::setInitialFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVersion(), (Object)o.getVersion(), this::setVersion, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetPool _that = this.getType().cast(o);
            if (!Objects.equals(this.currentFactor, _that.getCurrentFactor())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.initialFactor, _that.getInitialFactor())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currentFactor != null ? this.currentFactor.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.initialFactor != null ? this.initialFactor.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetPoolBuilder {currentFactor=" + this.currentFactor + ", effectiveDate=" + this.effectiveDate + ", initialFactor=" + this.initialFactor + ", version=" + this.version + '}';
        }
    }

    public static class AssetPoolImpl
    implements AssetPool {
        private final BigDecimal currentFactor;
        private final Date effectiveDate;
        private final BigDecimal initialFactor;
        private final String version;

        protected AssetPoolImpl(AssetPoolBuilder builder) {
            this.currentFactor = builder.getCurrentFactor();
            this.effectiveDate = builder.getEffectiveDate();
            this.initialFactor = builder.getInitialFactor();
            this.version = builder.getVersion();
        }

        @Override
        public BigDecimal getCurrentFactor() {
            return this.currentFactor;
        }

        @Override
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public BigDecimal getInitialFactor() {
            return this.initialFactor;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public AssetPool build() {
            return this;
        }

        @Override
        public AssetPoolBuilder toBuilder() {
            AssetPoolBuilder builder = AssetPool.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetPoolBuilder builder) {
            Optional.ofNullable(this.getCurrentFactor()).ifPresent(builder::setCurrentFactor);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getInitialFactor()).ifPresent(builder::setInitialFactor);
            Optional.ofNullable(this.getVersion()).ifPresent(builder::setVersion);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetPool _that = this.getType().cast(o);
            if (!Objects.equals(this.currentFactor, _that.getCurrentFactor())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.initialFactor, _that.getInitialFactor())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currentFactor != null ? this.currentFactor.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.initialFactor != null ? this.initialFactor.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetPool {currentFactor=" + this.currentFactor + ", effectiveDate=" + this.effectiveDate + ", initialFactor=" + this.initialFactor + ", version=" + this.version + '}';
        }
    }

    public static interface AssetPoolBuilder
    extends AssetPool,
    RosettaModelObjectBuilder {
        public AssetPoolBuilder setCurrentFactor(BigDecimal var1);

        public AssetPoolBuilder setEffectiveDate(Date var1);

        public AssetPoolBuilder setInitialFactor(BigDecimal var1);

        public AssetPoolBuilder setVersion(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("currentFactor"), BigDecimal.class, (Object)this.getCurrentFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialFactor"), BigDecimal.class, (Object)this.getInitialFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AssetPoolBuilder prune();
    }
}

