/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.functions.ArithmeticOpImpl;
import cdm.base.math.functions.VectorOperation;
import com.rosetta.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorOperationImpl
extends VectorOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectorOperationImpl.class);

    @Override
    protected List<BigDecimal> doEvaluate(ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, List<BigDecimal> right) {
        return this.doEval(arithmeticOp, CollectionUtils.emptyIfNull(left), CollectionUtils.emptyIfNull(right));
    }

    protected List<BigDecimal> doEval(ArithmeticOperationEnum arithmeticOp, List<BigDecimal> left, List<BigDecimal> right) {
        BiFunction<BigDecimal, BigDecimal, BigDecimal> eval = ArithmeticOpImpl.operation(arithmeticOp);
        int leftSize = left == null ? 0 : left.size();
        int rightSize = right == null ? 0 : right.size();
        int num = Math.max(leftSize, rightSize);
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>(num);
        for (int i = 0; i < num; ++i) {
            BigDecimal lhs = i < leftSize ? left.get(i) : new BigDecimal("0.0");
            BigDecimal rhs = i < rightSize ? right.get(i) : new BigDecimal("0.0");
            try {
                BigDecimal val = eval.apply(lhs, rhs);
                result.add(val);
                continue;
            }
            catch (ArithmeticException e) {
                LOGGER.error("Arithmetic operation failed: lhs {}, rhs {}", new Object[]{lhs, rhs, e});
            }
        }
        return result;
    }
}

