/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.RoundingDirectionEnum;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=RoundToPrecisionDefault.class)
public abstract class RoundToPrecision
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;

    public BigDecimal evaluate(BigDecimal value, Integer precision, RoundingDirectionEnum roundingMode) {
        this.conditionValidator.validate(() -> ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)precision), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All), "");
        BigDecimal roundedValue = this.doEvaluate(value, precision, roundingMode);
        return roundedValue;
    }

    protected abstract BigDecimal doEvaluate(BigDecimal var1, Integer var2, RoundingDirectionEnum var3);

    public static class RoundToPrecisionDefault
    extends RoundToPrecision {
        @Override
        protected BigDecimal doEvaluate(BigDecimal value, Integer precision, RoundingDirectionEnum roundingMode) {
            BigDecimal roundedValue = null;
            return this.assignOutput(roundedValue, value, precision, roundingMode);
        }

        protected BigDecimal assignOutput(BigDecimal roundedValue, BigDecimal value, Integer precision, RoundingDirectionEnum roundingMode) {
            return roundedValue;
        }
    }
}

