/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.RoundingModeEnum;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=RoundToNearestDefault.class)
public abstract class RoundToNearest
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;

    public BigDecimal evaluate(BigDecimal value, BigDecimal nearest, RoundingModeEnum roundingMode) {
        this.conditionValidator.validate(() -> ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)nearest), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All), "");
        BigDecimal roundedValue = this.doEvaluate(value, nearest, roundingMode);
        return roundedValue;
    }

    protected abstract BigDecimal doEvaluate(BigDecimal var1, BigDecimal var2, RoundingModeEnum var3);

    public static class RoundToNearestDefault
    extends RoundToNearest {
        @Override
        protected BigDecimal doEvaluate(BigDecimal value, BigDecimal nearest, RoundingModeEnum roundingMode) {
            BigDecimal roundedValue = null;
            return this.assignOutput(roundedValue, value, nearest, roundingMode);
        }

        protected BigDecimal assignOutput(BigDecimal roundedValue, BigDecimal value, BigDecimal nearest, RoundingModeEnum roundingMode) {
            return roundedValue;
        }
    }
}

