/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.QuantitySchedule;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@ImplementedBy(value=FilterQuantityByCurrencyDefault.class)
public abstract class FilterQuantityByCurrency
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends QuantitySchedule> evaluate(List<? extends QuantitySchedule> quantities, String currency) {
        List<QuantitySchedule.QuantityScheduleBuilder> filteredQuantities = this.doEvaluate(quantities, currency);
        if (filteredQuantities != null) {
            this.objectValidator.validate(QuantitySchedule.class, filteredQuantities);
        }
        return filteredQuantities;
    }

    protected abstract List<QuantitySchedule.QuantityScheduleBuilder> doEvaluate(List<? extends QuantitySchedule> var1, String var2);

    public static class FilterQuantityByCurrencyDefault
    extends FilterQuantityByCurrency {
        @Override
        protected List<QuantitySchedule.QuantityScheduleBuilder> doEvaluate(List<? extends QuantitySchedule> quantities, String currency) {
            ArrayList<QuantitySchedule.QuantityScheduleBuilder> filteredQuantities = new ArrayList<QuantitySchedule.QuantityScheduleBuilder>();
            return this.assignOutput(filteredQuantities, quantities, currency);
        }

        protected List<QuantitySchedule.QuantityScheduleBuilder> assignOutput(List<QuantitySchedule.QuantityScheduleBuilder> filteredQuantities, List<? extends QuantitySchedule> quantities, String currency) {
            List addVar = this.toBuilder(MapperC.of(quantities).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)currency), (CardinalityOperator)CardinalityOperator.All).get()).getMulti());
            filteredQuantities.addAll(addVar);
            return Optional.ofNullable(filteredQuantities).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

