/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.NonNegativeQuantity;
import cdm.base.math.UnitType;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=Create_NonNegativeQuantityDefault.class)
public abstract class Create_NonNegativeQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public NonNegativeQuantity evaluate(BigDecimal amount, UnitType unit) {
        NonNegativeQuantity.NonNegativeQuantityBuilder quantity = this.doEvaluate(amount, unit);
        if (quantity != null) {
            this.objectValidator.validate(NonNegativeQuantity.class, (RosettaModelObject)quantity);
        }
        return quantity;
    }

    protected abstract NonNegativeQuantity.NonNegativeQuantityBuilder doEvaluate(BigDecimal var1, UnitType var2);

    public static class Create_NonNegativeQuantityDefault
    extends Create_NonNegativeQuantity {
        @Override
        protected NonNegativeQuantity.NonNegativeQuantityBuilder doEvaluate(BigDecimal amount, UnitType unit) {
            NonNegativeQuantity.NonNegativeQuantityBuilder quantity = NonNegativeQuantity.builder();
            return this.assignOutput(quantity, amount, unit);
        }

        protected NonNegativeQuantity.NonNegativeQuantityBuilder assignOutput(NonNegativeQuantity.NonNegativeQuantityBuilder quantity, BigDecimal amount, UnitType unit) {
            quantity.setValue((BigDecimal)MapperS.of((Object)amount).get());
            quantity.setUnit((UnitType)MapperS.of((Object)unit).get());
            return Optional.ofNullable(quantity).map(o -> o.prune()).orElse(null);
        }
    }
}

