/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math;

import cdm.base.datetime.Frequency;
import cdm.base.math.DatedValue;
import cdm.base.math.Measure;
import cdm.base.math.MeasureSchedule;
import cdm.base.math.UnitType;
import cdm.base.math.meta.QuantityScheduleMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface QuantitySchedule
extends MeasureSchedule {
    public static final QuantityScheduleMeta metaData = new QuantityScheduleMeta();

    @Override
    public QuantitySchedule build();

    @Override
    public QuantityScheduleBuilder toBuilder();

    public Frequency getFrequency();

    public Measure getMultiplier();

    default public RosettaMetaData<? extends QuantitySchedule> metaData() {
        return metaData;
    }

    public static QuantityScheduleBuilder builder() {
        return new QuantityScheduleBuilderImpl();
    }

    default public Class<? extends QuantitySchedule> getType() {
        return QuantitySchedule.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        MeasureSchedule.super.process(path, processor);
        this.processRosetta(path.newSubPath("frequency"), processor, Frequency.class, this.getFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("multiplier"), processor, Measure.class, this.getMultiplier(), new AttributeMeta[0]);
    }

    public static class QuantityScheduleBuilderImpl
    extends MeasureSchedule.MeasureScheduleBuilderImpl
    implements QuantityScheduleBuilder {
        protected Frequency.FrequencyBuilder frequency;
        protected Measure.MeasureBuilder multiplier;

        @Override
        public Frequency.FrequencyBuilder getFrequency() {
            return this.frequency;
        }

        @Override
        public Frequency.FrequencyBuilder getOrCreateFrequency() {
            Frequency.FrequencyBuilder result = this.frequency != null ? this.frequency : (this.frequency = Frequency.builder());
            return result;
        }

        @Override
        public Measure.MeasureBuilder getMultiplier() {
            return this.multiplier;
        }

        @Override
        public Measure.MeasureBuilder getOrCreateMultiplier() {
            Measure.MeasureBuilder result = this.multiplier != null ? this.multiplier : (this.multiplier = Measure.builder());
            return result;
        }

        @Override
        public QuantityScheduleBuilder setFrequency(Frequency frequency) {
            this.frequency = frequency == null ? null : frequency.toBuilder();
            return this;
        }

        @Override
        public QuantityScheduleBuilder setMultiplier(Measure multiplier) {
            this.multiplier = multiplier == null ? null : multiplier.toBuilder();
            return this;
        }

        @Override
        public QuantityScheduleBuilder addDatedValue(DatedValue datedValue) {
            if (datedValue != null) {
                this.datedValue.add(datedValue.toBuilder());
            }
            return this;
        }

        @Override
        public QuantityScheduleBuilder addDatedValue(DatedValue datedValue, int _idx) {
            this.getIndex(this.datedValue, _idx, () -> datedValue.toBuilder());
            return this;
        }

        @Override
        public QuantityScheduleBuilder addDatedValue(List<? extends DatedValue> datedValues) {
            if (datedValues != null) {
                for (DatedValue datedValue : datedValues) {
                    this.datedValue.add(datedValue.toBuilder());
                }
            }
            return this;
        }

        @Override
        public QuantityScheduleBuilder setDatedValue(List<? extends DatedValue> datedValues) {
            this.datedValue = datedValues == null ? new ArrayList() : (List)datedValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public QuantityScheduleBuilder setUnit(UnitType unit) {
            this.unit = unit == null ? null : unit.toBuilder();
            return this;
        }

        @Override
        public QuantityScheduleBuilder setValue(BigDecimal value) {
            this.value = value == null ? null : value;
            return this;
        }

        @Override
        public QuantitySchedule build() {
            return new QuantityScheduleImpl(this);
        }

        @Override
        public QuantityScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public QuantityScheduleBuilder prune() {
            super.prune();
            if (this.frequency != null && !this.frequency.prune().hasData()) {
                this.frequency = null;
            }
            if (this.multiplier != null && !this.multiplier.prune().hasData()) {
                this.multiplier = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFrequency() != null && this.getFrequency().hasData()) {
                return true;
            }
            return this.getMultiplier() != null && this.getMultiplier().hasData();
        }

        @Override
        public QuantityScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            QuantityScheduleBuilder o = (QuantityScheduleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFrequency(), (RosettaModelObjectBuilder)o.getFrequency(), this::setFrequency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMultiplier(), (RosettaModelObjectBuilder)o.getMultiplier(), this::setMultiplier);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            QuantitySchedule _that = (QuantitySchedule)this.getType().cast(o);
            if (!Objects.equals(this.frequency, _that.getFrequency())) {
                return false;
            }
            return Objects.equals(this.multiplier, _that.getMultiplier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.frequency != null ? this.frequency.hashCode() : 0);
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "QuantityScheduleBuilder {frequency=" + this.frequency + ", multiplier=" + this.multiplier + '}' + " " + super.toString();
        }
    }

    public static class QuantityScheduleImpl
    extends MeasureSchedule.MeasureScheduleImpl
    implements QuantitySchedule {
        private final Frequency frequency;
        private final Measure multiplier;

        protected QuantityScheduleImpl(QuantityScheduleBuilder builder) {
            super(builder);
            this.frequency = Optional.ofNullable(builder.getFrequency()).map(f -> f.build()).orElse(null);
            this.multiplier = Optional.ofNullable(builder.getMultiplier()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Frequency getFrequency() {
            return this.frequency;
        }

        @Override
        public Measure getMultiplier() {
            return this.multiplier;
        }

        @Override
        public QuantitySchedule build() {
            return this;
        }

        @Override
        public QuantityScheduleBuilder toBuilder() {
            QuantityScheduleBuilder builder = QuantitySchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(QuantityScheduleBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFrequency()).ifPresent(builder::setFrequency);
            Optional.ofNullable(this.getMultiplier()).ifPresent(builder::setMultiplier);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            QuantitySchedule _that = (QuantitySchedule)this.getType().cast(o);
            if (!Objects.equals(this.frequency, _that.getFrequency())) {
                return false;
            }
            return Objects.equals(this.multiplier, _that.getMultiplier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.frequency != null ? this.frequency.hashCode() : 0);
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "QuantitySchedule {frequency=" + this.frequency + ", multiplier=" + this.multiplier + '}' + " " + super.toString();
        }
    }

    public static interface QuantityScheduleBuilder
    extends QuantitySchedule,
    MeasureSchedule.MeasureScheduleBuilder,
    RosettaModelObjectBuilder {
        public Frequency.FrequencyBuilder getOrCreateFrequency();

        @Override
        public Frequency.FrequencyBuilder getFrequency();

        public Measure.MeasureBuilder getOrCreateMultiplier();

        @Override
        public Measure.MeasureBuilder getMultiplier();

        public QuantityScheduleBuilder setFrequency(Frequency var1);

        public QuantityScheduleBuilder setMultiplier(Measure var1);

        @Override
        public QuantityScheduleBuilder addDatedValue(DatedValue var1);

        @Override
        public QuantityScheduleBuilder addDatedValue(DatedValue var1, int var2);

        @Override
        public QuantityScheduleBuilder addDatedValue(List<? extends DatedValue> var1);

        @Override
        public QuantityScheduleBuilder setDatedValue(List<? extends DatedValue> var1);

        @Override
        public QuantityScheduleBuilder setUnit(UnitType var1);

        @Override
        public QuantityScheduleBuilder setValue(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            MeasureSchedule.MeasureScheduleBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("frequency"), processor, Frequency.FrequencyBuilder.class, this.getFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("multiplier"), processor, Measure.MeasureBuilder.class, this.getMultiplier(), new AttributeMeta[0]);
        }

        @Override
        public QuantityScheduleBuilder prune();
    }
}

