/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math;

import cdm.base.datetime.Frequency;
import cdm.base.math.DatedValue;
import cdm.base.math.Measure;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.meta.QuantityMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaClass
public interface Quantity
extends QuantitySchedule {
    public static final QuantityMeta metaData = new QuantityMeta();

    @Override
    public Quantity build();

    @Override
    public QuantityBuilder toBuilder();

    default public RosettaMetaData<? extends Quantity> metaData() {
        return metaData;
    }

    public static QuantityBuilder builder() {
        return new QuantityBuilderImpl();
    }

    default public Class<? extends Quantity> getType() {
        return Quantity.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        QuantitySchedule.super.process(path, processor);
    }

    public static class QuantityBuilderImpl
    extends QuantitySchedule.QuantityScheduleBuilderImpl
    implements QuantityBuilder {
        @Override
        public QuantityBuilder setFrequency(Frequency frequency) {
            this.frequency = frequency == null ? null : frequency.toBuilder();
            return this;
        }

        @Override
        public QuantityBuilder setMultiplier(Measure multiplier) {
            this.multiplier = multiplier == null ? null : multiplier.toBuilder();
            return this;
        }

        @Override
        public QuantityBuilder addDatedValue(DatedValue datedValue) {
            if (datedValue != null) {
                this.datedValue.add(datedValue.toBuilder());
            }
            return this;
        }

        @Override
        public QuantityBuilder addDatedValue(DatedValue datedValue, int _idx) {
            this.getIndex(this.datedValue, _idx, () -> datedValue.toBuilder());
            return this;
        }

        @Override
        public QuantityBuilder addDatedValue(List<? extends DatedValue> datedValues) {
            if (datedValues != null) {
                for (DatedValue datedValue : datedValues) {
                    this.datedValue.add(datedValue.toBuilder());
                }
            }
            return this;
        }

        @Override
        public QuantityBuilder setDatedValue(List<? extends DatedValue> datedValues) {
            this.datedValue = datedValues == null ? new ArrayList() : (List)datedValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public QuantityBuilder setUnit(UnitType unit) {
            this.unit = unit == null ? null : unit.toBuilder();
            return this;
        }

        @Override
        public QuantityBuilder setValue(BigDecimal value) {
            this.value = value == null ? null : value;
            return this;
        }

        @Override
        public Quantity build() {
            return new QuantityImpl(this);
        }

        @Override
        public QuantityBuilder toBuilder() {
            return this;
        }

        @Override
        public QuantityBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public QuantityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            QuantityBuilder o = (QuantityBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "QuantityBuilder {} " + super.toString();
        }
    }

    public static class QuantityImpl
    extends QuantitySchedule.QuantityScheduleImpl
    implements Quantity {
        protected QuantityImpl(QuantityBuilder builder) {
            super(builder);
        }

        @Override
        public Quantity build() {
            return this;
        }

        @Override
        public QuantityBuilder toBuilder() {
            QuantityBuilder builder = Quantity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(QuantityBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "Quantity {} " + super.toString();
        }
    }

    public static interface QuantityBuilder
    extends Quantity,
    QuantitySchedule.QuantityScheduleBuilder,
    RosettaModelObjectBuilder {
        @Override
        public QuantityBuilder setFrequency(Frequency var1);

        @Override
        public QuantityBuilder setMultiplier(Measure var1);

        @Override
        public QuantityBuilder addDatedValue(DatedValue var1);

        @Override
        public QuantityBuilder addDatedValue(DatedValue var1, int var2);

        @Override
        public QuantityBuilder addDatedValue(List<? extends DatedValue> var1);

        @Override
        public QuantityBuilder setDatedValue(List<? extends DatedValue> var1);

        @Override
        public QuantityBuilder setUnit(UnitType var1);

        @Override
        public QuantityBuilder setValue(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            QuantitySchedule.QuantityScheduleBuilder.super.process(path, processor);
        }

        @Override
        public QuantityBuilder prune();
    }
}

