/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math;

import cdm.base.math.meta.MoneyBoundMeta;
import cdm.observable.asset.Money;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface MoneyBound
extends RosettaModelObject {
    public static final MoneyBoundMeta metaData = new MoneyBoundMeta();

    public MoneyBound build();

    public MoneyBoundBuilder toBuilder();

    public Boolean getInclusive();

    public Money getMoney();

    default public RosettaMetaData<? extends MoneyBound> metaData() {
        return metaData;
    }

    public static MoneyBoundBuilder builder() {
        return new MoneyBoundBuilderImpl();
    }

    default public Class<? extends MoneyBound> getType() {
        return MoneyBound.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("inclusive"), Boolean.class, (Object)this.getInclusive(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("money"), processor, Money.class, this.getMoney(), new AttributeMeta[0]);
    }

    public static class MoneyBoundBuilderImpl
    implements MoneyBoundBuilder {
        protected Boolean inclusive;
        protected Money.MoneyBuilder money;

        @Override
        public Boolean getInclusive() {
            return this.inclusive;
        }

        @Override
        public Money.MoneyBuilder getMoney() {
            return this.money;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMoney() {
            Money.MoneyBuilder result = this.money != null ? this.money : (this.money = Money.builder());
            return result;
        }

        @Override
        public MoneyBoundBuilder setInclusive(Boolean inclusive) {
            this.inclusive = inclusive == null ? null : inclusive;
            return this;
        }

        @Override
        public MoneyBoundBuilder setMoney(Money money) {
            this.money = money == null ? null : money.toBuilder();
            return this;
        }

        @Override
        public MoneyBound build() {
            return new MoneyBoundImpl(this);
        }

        @Override
        public MoneyBoundBuilder toBuilder() {
            return this;
        }

        @Override
        public MoneyBoundBuilder prune() {
            if (this.money != null && !this.money.prune().hasData()) {
                this.money = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getInclusive() != null) {
                return true;
            }
            return this.getMoney() != null && this.getMoney().hasData();
        }

        public MoneyBoundBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MoneyBoundBuilder o = (MoneyBoundBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMoney(), (RosettaModelObjectBuilder)o.getMoney(), this::setMoney);
            merger.mergeBasic((Object)this.getInclusive(), (Object)o.getInclusive(), this::setInclusive, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MoneyBound _that = this.getType().cast(o);
            if (!Objects.equals(this.inclusive, _that.getInclusive())) {
                return false;
            }
            return Objects.equals(this.money, _that.getMoney());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.inclusive != null ? this.inclusive.hashCode() : 0);
            _result = 31 * _result + (this.money != null ? this.money.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MoneyBoundBuilder {inclusive=" + this.inclusive + ", money=" + this.money + '}';
        }
    }

    public static class MoneyBoundImpl
    implements MoneyBound {
        private final Boolean inclusive;
        private final Money money;

        protected MoneyBoundImpl(MoneyBoundBuilder builder) {
            this.inclusive = builder.getInclusive();
            this.money = Optional.ofNullable(builder.getMoney()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Boolean getInclusive() {
            return this.inclusive;
        }

        @Override
        public Money getMoney() {
            return this.money;
        }

        @Override
        public MoneyBound build() {
            return this;
        }

        @Override
        public MoneyBoundBuilder toBuilder() {
            MoneyBoundBuilder builder = MoneyBound.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MoneyBoundBuilder builder) {
            Optional.ofNullable(this.getInclusive()).ifPresent(builder::setInclusive);
            Optional.ofNullable(this.getMoney()).ifPresent(builder::setMoney);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MoneyBound _that = this.getType().cast(o);
            if (!Objects.equals(this.inclusive, _that.getInclusive())) {
                return false;
            }
            return Objects.equals(this.money, _that.getMoney());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.inclusive != null ? this.inclusive.hashCode() : 0);
            _result = 31 * _result + (this.money != null ? this.money.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MoneyBound {inclusive=" + this.inclusive + ", money=" + this.money + '}';
        }
    }

    public static interface MoneyBoundBuilder
    extends MoneyBound,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateMoney();

        @Override
        public Money.MoneyBuilder getMoney();

        public MoneyBoundBuilder setInclusive(Boolean var1);

        public MoneyBoundBuilder setMoney(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("inclusive"), Boolean.class, (Object)this.getInclusive(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("money"), processor, Money.MoneyBuilder.class, this.getMoney(), new AttributeMeta[0]);
        }

        public MoneyBoundBuilder prune();
    }
}

