/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math;

import cdm.base.math.DatedValue;
import cdm.base.math.MeasureBase;
import cdm.base.math.UnitType;
import cdm.base.math.meta.MeasureScheduleMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface MeasureSchedule
extends MeasureBase {
    public static final MeasureScheduleMeta metaData = new MeasureScheduleMeta();

    @Override
    public MeasureSchedule build();

    @Override
    public MeasureScheduleBuilder toBuilder();

    public List<? extends DatedValue> getDatedValue();

    default public RosettaMetaData<? extends MeasureSchedule> metaData() {
        return metaData;
    }

    public static MeasureScheduleBuilder builder() {
        return new MeasureScheduleBuilderImpl();
    }

    default public Class<? extends MeasureSchedule> getType() {
        return MeasureSchedule.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        MeasureBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.class, this.getDatedValue(), new AttributeMeta[0]);
    }

    public static class MeasureScheduleBuilderImpl
    extends MeasureBase.MeasureBaseBuilderImpl
    implements MeasureScheduleBuilder {
        protected List<DatedValue.DatedValueBuilder> datedValue = new ArrayList<DatedValue.DatedValueBuilder>();

        @Override
        public List<? extends DatedValue.DatedValueBuilder> getDatedValue() {
            return this.datedValue;
        }

        @Override
        public DatedValue.DatedValueBuilder getOrCreateDatedValue(int _index) {
            if (this.datedValue == null) {
                this.datedValue = new ArrayList<DatedValue.DatedValueBuilder>();
            }
            return (DatedValue.DatedValueBuilder)this.getIndex(this.datedValue, _index, () -> {
                DatedValue.DatedValueBuilder newDatedValue = DatedValue.builder();
                return newDatedValue;
            });
        }

        @Override
        public MeasureScheduleBuilder addDatedValue(DatedValue datedValue) {
            if (datedValue != null) {
                this.datedValue.add(datedValue.toBuilder());
            }
            return this;
        }

        @Override
        public MeasureScheduleBuilder addDatedValue(DatedValue datedValue, int _idx) {
            this.getIndex(this.datedValue, _idx, () -> datedValue.toBuilder());
            return this;
        }

        @Override
        public MeasureScheduleBuilder addDatedValue(List<? extends DatedValue> datedValues) {
            if (datedValues != null) {
                for (DatedValue datedValue : datedValues) {
                    this.datedValue.add(datedValue.toBuilder());
                }
            }
            return this;
        }

        @Override
        public MeasureScheduleBuilder setDatedValue(List<? extends DatedValue> datedValues) {
            this.datedValue = datedValues == null ? new ArrayList<DatedValue.DatedValueBuilder>() : (List)datedValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MeasureScheduleBuilder setUnit(UnitType unit) {
            this.unit = unit == null ? null : unit.toBuilder();
            return this;
        }

        @Override
        public MeasureScheduleBuilder setValue(BigDecimal value) {
            this.value = value == null ? null : value;
            return this;
        }

        @Override
        public MeasureSchedule build() {
            return new MeasureScheduleImpl(this);
        }

        @Override
        public MeasureScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public MeasureScheduleBuilder prune() {
            super.prune();
            this.datedValue = this.datedValue.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getDatedValue() != null && this.getDatedValue().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public MeasureScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MeasureScheduleBuilder o = (MeasureScheduleBuilder)other;
            merger.mergeRosetta(this.getDatedValue(), o.getDatedValue(), this::getOrCreateDatedValue);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MeasureSchedule _that = (MeasureSchedule)this.getType().cast(o);
            return ListEquals.listEquals(this.datedValue, _that.getDatedValue());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.datedValue != null ? this.datedValue.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MeasureScheduleBuilder {datedValue=" + this.datedValue + '}' + " " + super.toString();
        }
    }

    public static class MeasureScheduleImpl
    extends MeasureBase.MeasureBaseImpl
    implements MeasureSchedule {
        private final List<? extends DatedValue> datedValue;

        protected MeasureScheduleImpl(MeasureScheduleBuilder builder) {
            super(builder);
            this.datedValue = Optional.ofNullable(builder.getDatedValue()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public List<? extends DatedValue> getDatedValue() {
            return this.datedValue;
        }

        @Override
        public MeasureSchedule build() {
            return this;
        }

        @Override
        public MeasureScheduleBuilder toBuilder() {
            MeasureScheduleBuilder builder = MeasureSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MeasureScheduleBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDatedValue()).ifPresent(builder::setDatedValue);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MeasureSchedule _that = (MeasureSchedule)this.getType().cast(o);
            return ListEquals.listEquals(this.datedValue, _that.getDatedValue());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.datedValue != null ? this.datedValue.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MeasureSchedule {datedValue=" + this.datedValue + '}' + " " + super.toString();
        }
    }

    public static interface MeasureScheduleBuilder
    extends MeasureSchedule,
    MeasureBase.MeasureBaseBuilder,
    RosettaModelObjectBuilder {
        public DatedValue.DatedValueBuilder getOrCreateDatedValue(int var1);

        public List<? extends DatedValue.DatedValueBuilder> getDatedValue();

        public MeasureScheduleBuilder addDatedValue(DatedValue var1);

        public MeasureScheduleBuilder addDatedValue(DatedValue var1, int var2);

        public MeasureScheduleBuilder addDatedValue(List<? extends DatedValue> var1);

        public MeasureScheduleBuilder setDatedValue(List<? extends DatedValue> var1);

        @Override
        public MeasureScheduleBuilder setUnit(UnitType var1);

        @Override
        public MeasureScheduleBuilder setValue(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            MeasureBase.MeasureBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.DatedValueBuilder.class, this.getDatedValue(), new AttributeMeta[0]);
        }

        @Override
        public MeasureScheduleBuilder prune();
    }
}

