/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math;

import cdm.base.math.UnitType;
import cdm.base.math.meta.MeasureBaseMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface MeasureBase
extends RosettaModelObject {
    public static final MeasureBaseMeta metaData = new MeasureBaseMeta();

    public MeasureBase build();

    public MeasureBaseBuilder toBuilder();

    public UnitType getUnit();

    public BigDecimal getValue();

    default public RosettaMetaData<? extends MeasureBase> metaData() {
        return metaData;
    }

    public static MeasureBaseBuilder builder() {
        return new MeasureBaseBuilderImpl();
    }

    default public Class<? extends MeasureBase> getType() {
        return MeasureBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unit"), processor, UnitType.class, this.getUnit(), new AttributeMeta[0]);
    }

    public static class MeasureBaseBuilderImpl
    implements MeasureBaseBuilder {
        protected UnitType.UnitTypeBuilder unit;
        protected BigDecimal value;

        @Override
        public UnitType.UnitTypeBuilder getUnit() {
            return this.unit;
        }

        @Override
        public UnitType.UnitTypeBuilder getOrCreateUnit() {
            UnitType.UnitTypeBuilder result = this.unit != null ? this.unit : (this.unit = UnitType.builder());
            return result;
        }

        @Override
        public BigDecimal getValue() {
            return this.value;
        }

        @Override
        public MeasureBaseBuilder setUnit(UnitType unit) {
            this.unit = unit == null ? null : unit.toBuilder();
            return this;
        }

        @Override
        public MeasureBaseBuilder setValue(BigDecimal value) {
            this.value = value == null ? null : value;
            return this;
        }

        @Override
        public MeasureBase build() {
            return new MeasureBaseImpl(this);
        }

        @Override
        public MeasureBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public MeasureBaseBuilder prune() {
            if (this.unit != null && !this.unit.prune().hasData()) {
                this.unit = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getUnit() != null && this.getUnit().hasData()) {
                return true;
            }
            return this.getValue() != null;
        }

        public MeasureBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MeasureBaseBuilder o = (MeasureBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnit(), (RosettaModelObjectBuilder)o.getUnit(), this::setUnit);
            merger.mergeBasic((Object)this.getValue(), (Object)o.getValue(), this::setValue, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MeasureBase _that = this.getType().cast(o);
            if (!Objects.equals(this.unit, _that.getUnit())) {
                return false;
            }
            return Objects.equals(this.value, _that.getValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MeasureBaseBuilder {unit=" + this.unit + ", value=" + this.value + '}';
        }
    }

    public static class MeasureBaseImpl
    implements MeasureBase {
        private final UnitType unit;
        private final BigDecimal value;

        protected MeasureBaseImpl(MeasureBaseBuilder builder) {
            this.unit = Optional.ofNullable(builder.getUnit()).map(f -> f.build()).orElse(null);
            this.value = builder.getValue();
        }

        @Override
        public UnitType getUnit() {
            return this.unit;
        }

        @Override
        public BigDecimal getValue() {
            return this.value;
        }

        @Override
        public MeasureBase build() {
            return this;
        }

        @Override
        public MeasureBaseBuilder toBuilder() {
            MeasureBaseBuilder builder = MeasureBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MeasureBaseBuilder builder) {
            Optional.ofNullable(this.getUnit()).ifPresent(builder::setUnit);
            Optional.ofNullable(this.getValue()).ifPresent(builder::setValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MeasureBase _that = this.getType().cast(o);
            if (!Objects.equals(this.unit, _that.getUnit())) {
                return false;
            }
            return Objects.equals(this.value, _that.getValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MeasureBase {unit=" + this.unit + ", value=" + this.value + '}';
        }
    }

    public static interface MeasureBaseBuilder
    extends MeasureBase,
    RosettaModelObjectBuilder {
        public UnitType.UnitTypeBuilder getOrCreateUnit();

        @Override
        public UnitType.UnitTypeBuilder getUnit();

        public MeasureBaseBuilder setUnit(UnitType var1);

        public MeasureBaseBuilder setValue(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unit"), processor, UnitType.UnitTypeBuilder.class, this.getUnit(), new AttributeMeta[0]);
        }

        public MeasureBaseBuilder prune();
    }
}

