/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.validation.datarule;

import cdm.base.datetime.Offset;
import cdm.base.datetime.PeriodEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="OffsetDayType")
@ImplementedBy(value=Default.class)
public interface OffsetDayType
extends Validator<Offset> {
    public static final String NAME = "OffsetDayType";
    public static final String DEFINITION = "if period <> PeriodEnum -> D or periodMultiplier = 0 then dayType is absent";

    public ValidationResult<Offset> validate(RosettaPath var1, Offset var2);

    public static class NoOp
    implements OffsetDayType {
        @Override
        public ValidationResult<Offset> validate(RosettaPath path, Offset offset) {
            return ValidationResult.success((String)OffsetDayType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Offset", (RosettaPath)path, (String)OffsetDayType.DEFINITION);
        }
    }

    public static class Default
    implements OffsetDayType {
        @Override
        public ValidationResult<Offset> validate(RosettaPath path, Offset offset) {
            ComparisonResult result = this.executeDataRule(offset);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)OffsetDayType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Offset", (RosettaPath)path, (String)OffsetDayType.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition OffsetDayType failed.";
            }
            return ValidationResult.failure((String)OffsetDayType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Offset", (RosettaPath)path, (String)OffsetDayType.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Offset offset) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.notEqual((Mapper)MapperS.of((Object)offset).map("getPeriod", period -> period.getPeriod()), (Mapper)MapperS.of((Object)((Object)PeriodEnum.D)), (CardinalityOperator)CardinalityOperator.Any).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)offset).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)offset).map("getDayType", _offset -> _offset.getDayType()));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

