/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.BusinessCenterTime;
import cdm.base.datetime.TimeZone;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.Optional;

@ImplementedBy(value=TimeZoneFromBusinessCenterTimeDefault.class)
public abstract class TimeZoneFromBusinessCenterTime
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public TimeZone evaluate(BusinessCenterTime time) {
        TimeZone.TimeZoneBuilder result = this.doEvaluate(time);
        if (result != null) {
            this.objectValidator.validate(TimeZone.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract TimeZone.TimeZoneBuilder doEvaluate(BusinessCenterTime var1);

    public static class TimeZoneFromBusinessCenterTimeDefault
    extends TimeZoneFromBusinessCenterTime {
        @Override
        protected TimeZone.TimeZoneBuilder doEvaluate(BusinessCenterTime time) {
            TimeZone.TimeZoneBuilder result = TimeZone.builder();
            return this.assignOutput(result, time);
        }

        protected TimeZone.TimeZoneBuilder assignOutput(TimeZone.TimeZoneBuilder result, BusinessCenterTime time) {
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }
    }
}

