/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.functions.AddBusinessDays;
import cdm.base.datetime.functions.AppendDateToList;
import cdm.base.datetime.functions.IsBusinessDay;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.List;

@ImplementedBy(value=GenerateDateListDefault.class)
public abstract class GenerateDateList
implements RosettaFunction {
    @Inject
    protected AddBusinessDays addBusinessDays;
    @Inject
    protected AppendDateToList appendDateToList;
    @Inject
    protected GenerateDateList generateDateList;
    @Inject
    protected IsBusinessDay isBusinessDay;

    public List<Date> evaluate(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
        List<Date> dateList = this.doEvaluate(startDate, endDate, businessCenters);
        return dateList;
    }

    protected abstract List<Date> doEvaluate(Date var1, Date var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Boolean> active(Date var1, Date var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Boolean> isGoodBusinessDay(Date var1, Date var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Date> priorDate(Date var1, Date var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Date> priorList(Date var1, Date var2, List<BusinessCenterEnum> var3);

    protected abstract Mapper<Date> newList(Date var1, Date var2, List<BusinessCenterEnum> var3);

    public static class GenerateDateListDefault
    extends GenerateDateList {
        @Override
        protected List<Date> doEvaluate(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            ArrayList<Date> dateList = new ArrayList<Date>();
            return this.assignOutput(dateList, startDate, endDate, businessCenters);
        }

        protected List<Date> assignOutput(List<Date> dateList, Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            List addVar = MapperUtils.runMulti(() -> {
                if (((Boolean)MapperS.of((Object)((Boolean)this.active(startDate, endDate, businessCenters).get())).getOrDefault((Object)false)).booleanValue()) {
                    return MapperC.of((List)this.newList(startDate, endDate, businessCenters).getMulti());
                }
                return MapperC.ofNull();
            }).getMulti();
            dateList.addAll(addVar);
            return dateList;
        }

        @Override
        protected Mapper<Boolean> active(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            return ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)startDate), (Mapper)MapperS.of((Object)endDate), (CardinalityOperator)CardinalityOperator.All);
        }

        @Override
        protected Mapper<Boolean> isGoodBusinessDay(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.isBusinessDay.evaluate((Date)MapperS.of((Object)endDate).get(), MapperC.of(businessCenters).getMulti()));
        }

        @Override
        protected Mapper<Date> priorDate(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.addBusinessDays.evaluate((Date)MapperS.of((Object)endDate).get(), (Integer)MapperS.of((Object)-1).get(), MapperC.of(businessCenters).getMulti()));
        }

        @Override
        protected Mapper<Date> priorList(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            return MapperC.of(this.generateDateList.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)((Date)this.priorDate(startDate, endDate, businessCenters).get())).get(), MapperC.of(businessCenters).getMulti()));
        }

        @Override
        protected Mapper<Date> newList(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            return MapperUtils.runMulti(() -> {
                if (((Boolean)MapperS.of((Object)((Boolean)this.isGoodBusinessDay(startDate, endDate, businessCenters).get())).getOrDefault((Object)false)).booleanValue()) {
                    return MapperC.of(this.appendDateToList.evaluate(MapperC.of((List)this.priorList(startDate, endDate, businessCenters).getMulti()).getMulti(), (Date)MapperS.of((Object)endDate).get()));
                }
                return MapperC.of((List)this.priorList(startDate, endDate, businessCenters).getMulti());
            });
        }
    }
}

