/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.daycount.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.functions.DateDifference;
import cdm.base.datetime.functions.LeapYearDateDifference;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.IsLeapYear;
import com.rosetta.model.lib.functions.Min;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;

public class YearFraction {
    @Inject
    protected _1_1_ _1_1_;
    @Inject
    protected aCT_ACT_ISDA_ aCT_ACT_ISDA_;
    @Inject
    protected aCT_ACT_ICMA_ aCT_ACT_ICMA_;
    @Inject
    protected aCT_365_FIXED_ aCT_365_FIXED_;
    @Inject
    protected aCT_360_ aCT_360_;
    @Inject
    protected _30_360_ _30_360_;
    @Inject
    protected _30E_360_ _30E_360_;
    @Inject
    protected _30E_360_ISDA_ _30E_360_ISDA_;
    @Inject
    protected aCT_364_ aCT_364_;
    @Inject
    protected aCT_365L_ aCT_365L_;
    @Inject
    protected cAL_252_ cAL_252_;

    public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
        switch (dayCountFractionEnum) {
            case _1_1: {
                return this._1_1_.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_ACT_ISDA: {
                return this.aCT_ACT_ISDA_.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_ACT_ICMA: {
                return this.aCT_ACT_ICMA_.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_365_FIXED: {
                return this.aCT_365_FIXED_.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_360: {
                return this.aCT_360_.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case _30_360: {
                return this._30_360_.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case _30E_360: {
                return this._30E_360_.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case _30E_360_ISDA: {
                return this._30E_360_ISDA_.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_364: {
                return this.aCT_364_.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case ACT_365L: {
                return this.aCT_365L_.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
            case CAL_252: {
                return this.cAL_252_.evaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }
        }
        throw new IllegalArgumentException("Enum value not implemented: " + (Object)((Object)dayCountFractionEnum));
    }

    @ImplementedBy(value=cAL_252_Default.class)
    public static abstract class cAL_252_
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class cAL_252_Default
        extends cAL_252_ {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)252)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }
        }
    }

    @ImplementedBy(value=aCT_365L_Default.class)
    public static abstract class aCT_365L_
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Boolean> endDateIsInLeapYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class aCT_365L_Default
        extends aCT_365L_ {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.daysInYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get()))).get();
                return result;
            }

            @Override
            protected Mapper<Boolean> endDateIsInLeapYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new IsLeapYear().execute((Integer)MapperS.of((Object)endDate).map("Year", Date::getYear).get()));
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }

            @Override
            protected Mapper<Integer> daysInYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.endDateIsInLeapYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)366);
                    }
                    return MapperS.of((Object)365);
                });
            }
        }
    }

    @ImplementedBy(value=aCT_364_Default.class)
    public static abstract class aCT_364_
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class aCT_364_Default
        extends aCT_364_ {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)364)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }
        }
    }

    @ImplementedBy(value=_30E_360_ISDA_Default.class)
    public static abstract class _30E_360_ISDA_
    implements RosettaFunction {
        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Boolean> startDateIsInLeapYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Boolean> endDateIsInLeapYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class _30E_360_ISDA_Default
        extends _30E_360_ISDA_ {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperMaths.add((Mapper)MapperMaths.add((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)360), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)30), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get()))))), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperS.of((Object)360)).get();
                return result;
            }

            @Override
            protected Mapper<Boolean> startDateIsInLeapYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new IsLeapYear().execute((Integer)MapperS.of((Object)startDate).map("Year", Date::getYear).get()));
            }

            @Override
            protected Mapper<Boolean> endDateIsInLeapYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new IsLeapYear().execute((Integer)MapperS.of((Object)endDate).map("Year", Date::getYear).get()));
            }

            @Override
            protected Mapper<Integer> startYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> endYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> startMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> endMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> startDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.startDateIsInLeapYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)startDate).map("Month", Date::getMonth), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)startDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)28), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.startDateIsInLeapYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)startDate).map("Month", Date::getMonth), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)startDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)29), (CardinalityOperator)CardinalityOperator.All))).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)startDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)31), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)30);
                    }
                    return MapperS.of((Object)endDate).map("Day", Date::getDay);
                });
            }

            @Override
            protected Mapper<Integer> endDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.endDateIsInLeapYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate).map("Month", Date::getMonth), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)28), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.endDateIsInLeapYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate).map("Month", Date::getMonth), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)29), (CardinalityOperator)CardinalityOperator.All))).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)31), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)endDate), (Mapper)MapperS.of((Object)terminationDate), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)30);
                    }
                    return MapperS.of((Object)endDate).map("Day", Date::getDay);
                });
            }
        }
    }

    @ImplementedBy(value=_30E_360_Default.class)
    public static abstract class _30E_360_
    implements RosettaFunction {
        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class _30E_360_Default
        extends _30E_360_ {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperMaths.add((Mapper)MapperMaths.add((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)360), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)30), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get()))))), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperS.of((Object)360)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> startYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> endYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> startMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> endMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> endDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new Min().execute((Integer)MapperS.of((Object)endDate).map("Day", Date::getDay).get(), (Integer)MapperS.of((Object)30).get()));
            }

            @Override
            protected Mapper<Integer> startDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new Min().execute((Integer)MapperS.of((Object)startDate).map("Day", Date::getDay).get(), (Integer)MapperS.of((Object)30).get()));
            }
        }
    }

    @ImplementedBy(value=_30_360_Default.class)
    public static abstract class _30_360_
    implements RosettaFunction {
        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endYear(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endMonth(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> endDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> startDay(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class _30_360_Default
        extends _30_360_ {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperMaths.add((Mapper)MapperMaths.add((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)360), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startYear(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)30), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startMonth(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get()))))), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.endDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.startDay(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())))), (Mapper)MapperS.of((Object)360)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> startYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> endYear(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Year", Date::getYear);
            }

            @Override
            protected Mapper<Integer> startMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)startDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> endMonth(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)endDate).map("Month", Date::getMonth);
            }

            @Override
            protected Mapper<Integer> endDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)startDate).map("Day", Date::getDay), (Mapper)MapperS.of((Object)29), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)new Min().execute((Integer)MapperS.of((Object)endDate).map("Day", Date::getDay).get(), (Integer)MapperS.of((Object)30).get()));
                    }
                    return MapperS.of((Object)endDate).map("Day", Date::getDay);
                });
            }

            @Override
            protected Mapper<Integer> startDay(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)new Min().execute((Integer)MapperS.of((Object)startDate).map("Day", Date::getDay).get(), (Integer)MapperS.of((Object)30).get()));
            }
        }
    }

    @ImplementedBy(value=aCT_360_Default.class)
    public static abstract class aCT_360_
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class aCT_360_Default
        extends aCT_360_ {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)360)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }
        }
    }

    @ImplementedBy(value=aCT_365_FIXED_Default.class)
    public static abstract class aCT_365_FIXED_
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class aCT_365_FIXED_Default
        extends aCT_365_FIXED_ {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)365)).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }
        }
    }

    @ImplementedBy(value=aCT_ACT_ICMA_Default.class)
    public static abstract class aCT_ACT_ICMA_
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class aCT_ACT_ICMA_Default
        extends aCT_ACT_ICMA_ {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)periodsInYear))).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }
        }
    }

    @ImplementedBy(value=aCT_ACT_ISDA_Default.class)
    public static abstract class aCT_ACT_ISDA_
    implements RosettaFunction {
        @Inject
        protected DateDifference dateDifference;
        @Inject
        protected LeapYearDateDifference leapYearDateDifference;

        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInLeapYearPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        protected abstract Mapper<Integer> daysInNonLeapPeriod(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class aCT_ACT_ISDA_Default
        extends aCT_ACT_ISDA_ {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperMaths.add((Mapper)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInNonLeapPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)365)), (Mapper)MapperMaths.divide((Mapper)MapperS.of((Object)((Integer)this.daysInLeapYearPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)366))).get();
                return result;
            }

            @Override
            protected Mapper<Integer> daysInPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.dateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }

            @Override
            protected Mapper<Integer> daysInLeapYearPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperS.of((Object)this.leapYearDateDifference.evaluate((Date)MapperS.of((Object)startDate).get(), (Date)MapperS.of((Object)endDate).get()));
            }

            @Override
            protected Mapper<Integer> daysInNonLeapPeriod(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                return MapperMaths.subtract((Mapper)MapperS.of((Object)((Integer)this.daysInPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())), (Mapper)MapperS.of((Object)((Integer)this.daysInLeapYearPeriod(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear).get())));
            }
        }
    }

    @ImplementedBy(value=_1_1_Default.class)
    public static abstract class _1_1_
    implements RosettaFunction {
        public BigDecimal evaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
            BigDecimal result = this.doEvaluate(dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            return result;
        }

        protected abstract BigDecimal doEvaluate(DayCountFractionEnum var1, Date var2, Date var3, Date var4, Integer var5);

        public static class _1_1_Default
        extends _1_1_ {
            @Override
            protected BigDecimal doEvaluate(DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                BigDecimal result = null;
                return this.assignOutput(result, dayCountFractionEnum, startDate, endDate, terminationDate, periodsInYear);
            }

            protected BigDecimal assignOutput(BigDecimal result, DayCountFractionEnum dayCountFractionEnum, Date startDate, Date endDate, Date terminationDate, Integer periodsInYear) {
                result = (BigDecimal)MapperS.of((Object)new BigDecimal("1.0")).get();
                return result;
            }
        }
    }
}

