/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.daycount.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;

public class DayCountBasis {
    @Inject
    protected aCT_360_ aCT_360_;
    @Inject
    protected _30_360_ _30_360_;
    @Inject
    protected _30E_360_ _30E_360_;
    @Inject
    protected aCT_365L_ aCT_365L_;
    @Inject
    protected aCT_365_FIXED_ aCT_365_FIXED_;
    @Inject
    protected aCT_ACT_AFB_ aCT_ACT_AFB_;
    @Inject
    protected aCT_ACT_ISDA_ aCT_ACT_ISDA_;
    @Inject
    protected aCT_ACT_ICMA_ aCT_ACT_ICMA_;
    @Inject
    protected cAL_252_ cAL_252_;

    public Integer evaluate(DayCountFractionEnum dcf) {
        switch (dcf) {
            case ACT_360: {
                return this.aCT_360_.evaluate(dcf);
            }
            case _30_360: {
                return this._30_360_.evaluate(dcf);
            }
            case _30E_360: {
                return this._30E_360_.evaluate(dcf);
            }
            case ACT_365L: {
                return this.aCT_365L_.evaluate(dcf);
            }
            case ACT_365_FIXED: {
                return this.aCT_365_FIXED_.evaluate(dcf);
            }
            case ACT_ACT_AFB: {
                return this.aCT_ACT_AFB_.evaluate(dcf);
            }
            case ACT_ACT_ISDA: {
                return this.aCT_ACT_ISDA_.evaluate(dcf);
            }
            case ACT_ACT_ICMA: {
                return this.aCT_ACT_ICMA_.evaluate(dcf);
            }
            case CAL_252: {
                return this.cAL_252_.evaluate(dcf);
            }
        }
        throw new IllegalArgumentException("Enum value not implemented: " + (Object)((Object)dcf));
    }

    @ImplementedBy(value=cAL_252_Default.class)
    public static abstract class cAL_252_
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class cAL_252_Default
        extends cAL_252_ {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = (Integer)MapperS.of((Object)252).get();
                return basis;
            }
        }
    }

    @ImplementedBy(value=aCT_ACT_ICMA_Default.class)
    public static abstract class aCT_ACT_ICMA_
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class aCT_ACT_ICMA_Default
        extends aCT_ACT_ICMA_ {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = (Integer)MapperS.of((Object)365).get();
                return basis;
            }
        }
    }

    @ImplementedBy(value=aCT_ACT_ISDA_Default.class)
    public static abstract class aCT_ACT_ISDA_
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class aCT_ACT_ISDA_Default
        extends aCT_ACT_ISDA_ {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = (Integer)MapperS.of((Object)365).get();
                return basis;
            }
        }
    }

    @ImplementedBy(value=aCT_ACT_AFB_Default.class)
    public static abstract class aCT_ACT_AFB_
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class aCT_ACT_AFB_Default
        extends aCT_ACT_AFB_ {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = (Integer)MapperS.of((Object)365).get();
                return basis;
            }
        }
    }

    @ImplementedBy(value=aCT_365_FIXED_Default.class)
    public static abstract class aCT_365_FIXED_
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class aCT_365_FIXED_Default
        extends aCT_365_FIXED_ {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = (Integer)MapperS.of((Object)365).get();
                return basis;
            }
        }
    }

    @ImplementedBy(value=aCT_365L_Default.class)
    public static abstract class aCT_365L_
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class aCT_365L_Default
        extends aCT_365L_ {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = (Integer)MapperS.of((Object)365).get();
                return basis;
            }
        }
    }

    @ImplementedBy(value=_30E_360_Default.class)
    public static abstract class _30E_360_
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class _30E_360_Default
        extends _30E_360_ {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = (Integer)MapperS.of((Object)360).get();
                return basis;
            }
        }
    }

    @ImplementedBy(value=_30_360_Default.class)
    public static abstract class _30_360_
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class _30_360_Default
        extends _30_360_ {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = (Integer)MapperS.of((Object)360).get();
                return basis;
            }
        }
    }

    @ImplementedBy(value=aCT_360_Default.class)
    public static abstract class aCT_360_
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class aCT_360_Default
        extends aCT_360_ {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = (Integer)MapperS.of((Object)360).get();
                return basis;
            }
        }
    }
}

