/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.meta.TimeZoneMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.time.LocalTime;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface TimeZone
extends RosettaModelObject {
    public static final TimeZoneMeta metaData = new TimeZoneMeta();

    public TimeZone build();

    public TimeZoneBuilder toBuilder();

    public FieldWithMetaString getLocation();

    public LocalTime getTime();

    default public RosettaMetaData<? extends TimeZone> metaData() {
        return metaData;
    }

    public static TimeZoneBuilder builder() {
        return new TimeZoneBuilderImpl();
    }

    default public Class<? extends TimeZone> getType() {
        return TimeZone.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("time"), LocalTime.class, (Object)this.getTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("location"), processor, FieldWithMetaString.class, this.getLocation(), new AttributeMeta[0]);
    }

    public static class TimeZoneBuilderImpl
    implements TimeZoneBuilder {
        protected FieldWithMetaString.FieldWithMetaStringBuilder location;
        protected LocalTime time;

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getLocation() {
            return this.location;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateLocation() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.location != null ? this.location : (this.location = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public LocalTime getTime() {
            return this.time;
        }

        @Override
        public TimeZoneBuilder setLocation(FieldWithMetaString location) {
            this.location = location == null ? null : location.toBuilder();
            return this;
        }

        @Override
        public TimeZoneBuilder setLocationValue(String location) {
            this.getOrCreateLocation().setValue(location);
            return this;
        }

        @Override
        public TimeZoneBuilder setTime(LocalTime time) {
            this.time = time == null ? null : time;
            return this;
        }

        @Override
        public TimeZone build() {
            return new TimeZoneImpl(this);
        }

        @Override
        public TimeZoneBuilder toBuilder() {
            return this;
        }

        @Override
        public TimeZoneBuilder prune() {
            if (this.location != null && !this.location.prune().hasData()) {
                this.location = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getLocation() != null) {
                return true;
            }
            return this.getTime() != null;
        }

        public TimeZoneBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TimeZoneBuilder o = (TimeZoneBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLocation(), (RosettaModelObjectBuilder)o.getLocation(), this::setLocation);
            merger.mergeBasic((Object)this.getTime(), (Object)o.getTime(), this::setTime, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TimeZone _that = this.getType().cast(o);
            if (!Objects.equals(this.location, _that.getLocation())) {
                return false;
            }
            return Objects.equals(this.time, _that.getTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TimeZoneBuilder {location=" + this.location + ", time=" + this.time + '}';
        }
    }

    public static class TimeZoneImpl
    implements TimeZone {
        private final FieldWithMetaString location;
        private final LocalTime time;

        protected TimeZoneImpl(TimeZoneBuilder builder) {
            this.location = Optional.ofNullable(builder.getLocation()).map(f -> f.build()).orElse(null);
            this.time = builder.getTime();
        }

        @Override
        public FieldWithMetaString getLocation() {
            return this.location;
        }

        @Override
        public LocalTime getTime() {
            return this.time;
        }

        @Override
        public TimeZone build() {
            return this;
        }

        @Override
        public TimeZoneBuilder toBuilder() {
            TimeZoneBuilder builder = TimeZone.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TimeZoneBuilder builder) {
            Optional.ofNullable(this.getLocation()).ifPresent(builder::setLocation);
            Optional.ofNullable(this.getTime()).ifPresent(builder::setTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TimeZone _that = this.getType().cast(o);
            if (!Objects.equals(this.location, _that.getLocation())) {
                return false;
            }
            return Objects.equals(this.time, _that.getTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TimeZone {location=" + this.location + ", time=" + this.time + '}';
        }
    }

    public static interface TimeZoneBuilder
    extends TimeZone,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateLocation();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getLocation();

        public TimeZoneBuilder setLocation(FieldWithMetaString var1);

        public TimeZoneBuilder setLocationValue(String var1);

        public TimeZoneBuilder setTime(LocalTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("time"), LocalTime.class, (Object)this.getTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("location"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getLocation(), new AttributeMeta[0]);
        }

        public TimeZoneBuilder prune();
    }
}

