/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.BusinessDayAdjustments;
import cdm.base.datetime.CalculationPeriodFrequency;
import cdm.base.datetime.DayTypeEnum;
import cdm.base.datetime.meta.PeriodicDatesMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface PeriodicDates
extends RosettaModelObject {
    public static final PeriodicDatesMeta metaData = new PeriodicDatesMeta();

    public PeriodicDates build();

    public PeriodicDatesBuilder toBuilder();

    public DayTypeEnum getDayType();

    public AdjustableOrRelativeDate getEndDate();

    public BusinessDayAdjustments getPeriodDatesAdjustments();

    public CalculationPeriodFrequency getPeriodFrequency();

    public AdjustableOrRelativeDate getStartDate();

    default public RosettaMetaData<? extends PeriodicDates> metaData() {
        return metaData;
    }

    public static PeriodicDatesBuilder builder() {
        return new PeriodicDatesBuilderImpl();
    }

    default public Class<? extends PeriodicDates> getType() {
        return PeriodicDates.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("dayType"), DayTypeEnum.class, (Object)this.getDayType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("endDate"), processor, AdjustableOrRelativeDate.class, this.getEndDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodDatesAdjustments"), processor, BusinessDayAdjustments.class, this.getPeriodDatesAdjustments(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodFrequency"), processor, CalculationPeriodFrequency.class, this.getPeriodFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("startDate"), processor, AdjustableOrRelativeDate.class, this.getStartDate(), new AttributeMeta[0]);
    }

    public static class PeriodicDatesBuilderImpl
    implements PeriodicDatesBuilder {
        protected DayTypeEnum dayType;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder endDate;
        protected BusinessDayAdjustments.BusinessDayAdjustmentsBuilder periodDatesAdjustments;
        protected CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder periodFrequency;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder startDate;

        @Override
        public DayTypeEnum getDayType() {
            return this.dayType;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEndDate() {
            return this.endDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEndDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.endDate != null ? this.endDate : (this.endDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getPeriodDatesAdjustments() {
            return this.periodDatesAdjustments;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreatePeriodDatesAdjustments() {
            BusinessDayAdjustments.BusinessDayAdjustmentsBuilder result = this.periodDatesAdjustments != null ? this.periodDatesAdjustments : (this.periodDatesAdjustments = BusinessDayAdjustments.builder());
            return result;
        }

        @Override
        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getPeriodFrequency() {
            return this.periodFrequency;
        }

        @Override
        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getOrCreatePeriodFrequency() {
            CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder result = this.periodFrequency != null ? this.periodFrequency : (this.periodFrequency = CalculationPeriodFrequency.builder());
            return result;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getStartDate() {
            return this.startDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateStartDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.startDate != null ? this.startDate : (this.startDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        public PeriodicDatesBuilder setDayType(DayTypeEnum dayType) {
            this.dayType = dayType == null ? null : dayType;
            return this;
        }

        @Override
        public PeriodicDatesBuilder setEndDate(AdjustableOrRelativeDate endDate) {
            this.endDate = endDate == null ? null : endDate.toBuilder();
            return this;
        }

        @Override
        public PeriodicDatesBuilder setPeriodDatesAdjustments(BusinessDayAdjustments periodDatesAdjustments) {
            this.periodDatesAdjustments = periodDatesAdjustments == null ? null : periodDatesAdjustments.toBuilder();
            return this;
        }

        @Override
        public PeriodicDatesBuilder setPeriodFrequency(CalculationPeriodFrequency periodFrequency) {
            this.periodFrequency = periodFrequency == null ? null : periodFrequency.toBuilder();
            return this;
        }

        @Override
        public PeriodicDatesBuilder setStartDate(AdjustableOrRelativeDate startDate) {
            this.startDate = startDate == null ? null : startDate.toBuilder();
            return this;
        }

        @Override
        public PeriodicDates build() {
            return new PeriodicDatesImpl(this);
        }

        @Override
        public PeriodicDatesBuilder toBuilder() {
            return this;
        }

        @Override
        public PeriodicDatesBuilder prune() {
            if (this.endDate != null && !this.endDate.prune().hasData()) {
                this.endDate = null;
            }
            if (this.periodDatesAdjustments != null && !this.periodDatesAdjustments.prune().hasData()) {
                this.periodDatesAdjustments = null;
            }
            if (this.periodFrequency != null && !this.periodFrequency.prune().hasData()) {
                this.periodFrequency = null;
            }
            if (this.startDate != null && !this.startDate.prune().hasData()) {
                this.startDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDayType() != null) {
                return true;
            }
            if (this.getEndDate() != null && this.getEndDate().hasData()) {
                return true;
            }
            if (this.getPeriodDatesAdjustments() != null && this.getPeriodDatesAdjustments().hasData()) {
                return true;
            }
            if (this.getPeriodFrequency() != null && this.getPeriodFrequency().hasData()) {
                return true;
            }
            return this.getStartDate() != null && this.getStartDate().hasData();
        }

        public PeriodicDatesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PeriodicDatesBuilder o = (PeriodicDatesBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEndDate(), (RosettaModelObjectBuilder)o.getEndDate(), this::setEndDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodDatesAdjustments(), (RosettaModelObjectBuilder)o.getPeriodDatesAdjustments(), this::setPeriodDatesAdjustments);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodFrequency(), (RosettaModelObjectBuilder)o.getPeriodFrequency(), this::setPeriodFrequency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStartDate(), (RosettaModelObjectBuilder)o.getStartDate(), this::setStartDate);
            merger.mergeBasic((Object)this.getDayType(), (Object)o.getDayType(), this::setDayType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PeriodicDates _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.dayType, (Object)_that.getDayType())) {
                return false;
            }
            if (!Objects.equals(this.endDate, _that.getEndDate())) {
                return false;
            }
            if (!Objects.equals(this.periodDatesAdjustments, _that.getPeriodDatesAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.periodFrequency, _that.getPeriodFrequency())) {
                return false;
            }
            return Objects.equals(this.startDate, _that.getStartDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dayType != null ? ((Object)((Object)this.dayType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            _result = 31 * _result + (this.periodDatesAdjustments != null ? this.periodDatesAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.periodFrequency != null ? this.periodFrequency.hashCode() : 0);
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PeriodicDatesBuilder {dayType=" + (Object)((Object)this.dayType) + ", endDate=" + this.endDate + ", periodDatesAdjustments=" + this.periodDatesAdjustments + ", periodFrequency=" + this.periodFrequency + ", startDate=" + this.startDate + '}';
        }
    }

    public static class PeriodicDatesImpl
    implements PeriodicDates {
        private final DayTypeEnum dayType;
        private final AdjustableOrRelativeDate endDate;
        private final BusinessDayAdjustments periodDatesAdjustments;
        private final CalculationPeriodFrequency periodFrequency;
        private final AdjustableOrRelativeDate startDate;

        protected PeriodicDatesImpl(PeriodicDatesBuilder builder) {
            this.dayType = builder.getDayType();
            this.endDate = Optional.ofNullable(builder.getEndDate()).map(f -> f.build()).orElse(null);
            this.periodDatesAdjustments = Optional.ofNullable(builder.getPeriodDatesAdjustments()).map(f -> f.build()).orElse(null);
            this.periodFrequency = Optional.ofNullable(builder.getPeriodFrequency()).map(f -> f.build()).orElse(null);
            this.startDate = Optional.ofNullable(builder.getStartDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        public DayTypeEnum getDayType() {
            return this.dayType;
        }

        @Override
        public AdjustableOrRelativeDate getEndDate() {
            return this.endDate;
        }

        @Override
        public BusinessDayAdjustments getPeriodDatesAdjustments() {
            return this.periodDatesAdjustments;
        }

        @Override
        public CalculationPeriodFrequency getPeriodFrequency() {
            return this.periodFrequency;
        }

        @Override
        public AdjustableOrRelativeDate getStartDate() {
            return this.startDate;
        }

        @Override
        public PeriodicDates build() {
            return this;
        }

        @Override
        public PeriodicDatesBuilder toBuilder() {
            PeriodicDatesBuilder builder = PeriodicDates.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PeriodicDatesBuilder builder) {
            Optional.ofNullable(this.getDayType()).ifPresent(builder::setDayType);
            Optional.ofNullable(this.getEndDate()).ifPresent(builder::setEndDate);
            Optional.ofNullable(this.getPeriodDatesAdjustments()).ifPresent(builder::setPeriodDatesAdjustments);
            Optional.ofNullable(this.getPeriodFrequency()).ifPresent(builder::setPeriodFrequency);
            Optional.ofNullable(this.getStartDate()).ifPresent(builder::setStartDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PeriodicDates _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.dayType, (Object)_that.getDayType())) {
                return false;
            }
            if (!Objects.equals(this.endDate, _that.getEndDate())) {
                return false;
            }
            if (!Objects.equals(this.periodDatesAdjustments, _that.getPeriodDatesAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.periodFrequency, _that.getPeriodFrequency())) {
                return false;
            }
            return Objects.equals(this.startDate, _that.getStartDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dayType != null ? ((Object)((Object)this.dayType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            _result = 31 * _result + (this.periodDatesAdjustments != null ? this.periodDatesAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.periodFrequency != null ? this.periodFrequency.hashCode() : 0);
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PeriodicDates {dayType=" + (Object)((Object)this.dayType) + ", endDate=" + this.endDate + ", periodDatesAdjustments=" + this.periodDatesAdjustments + ", periodFrequency=" + this.periodFrequency + ", startDate=" + this.startDate + '}';
        }
    }

    public static interface PeriodicDatesBuilder
    extends PeriodicDates,
    RosettaModelObjectBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEndDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEndDate();

        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreatePeriodDatesAdjustments();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getPeriodDatesAdjustments();

        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getOrCreatePeriodFrequency();

        @Override
        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getPeriodFrequency();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateStartDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getStartDate();

        public PeriodicDatesBuilder setDayType(DayTypeEnum var1);

        public PeriodicDatesBuilder setEndDate(AdjustableOrRelativeDate var1);

        public PeriodicDatesBuilder setPeriodDatesAdjustments(BusinessDayAdjustments var1);

        public PeriodicDatesBuilder setPeriodFrequency(CalculationPeriodFrequency var1);

        public PeriodicDatesBuilder setStartDate(AdjustableOrRelativeDate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("dayType"), DayTypeEnum.class, (Object)this.getDayType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("endDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getEndDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodDatesAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, this.getPeriodDatesAdjustments(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodFrequency"), processor, CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder.class, this.getPeriodFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("startDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getStartDate(), new AttributeMeta[0]);
        }

        public PeriodicDatesBuilder prune();
    }
}

