/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.Period;
import cdm.base.datetime.meta.PeriodBoundMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface PeriodBound
extends RosettaModelObject {
    public static final PeriodBoundMeta metaData = new PeriodBoundMeta();

    public PeriodBound build();

    public PeriodBoundBuilder toBuilder();

    public Boolean getInclusive();

    public Period getPeriod();

    default public RosettaMetaData<? extends PeriodBound> metaData() {
        return metaData;
    }

    public static PeriodBoundBuilder builder() {
        return new PeriodBoundBuilderImpl();
    }

    default public Class<? extends PeriodBound> getType() {
        return PeriodBound.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("inclusive"), Boolean.class, (Object)this.getInclusive(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("period"), processor, Period.class, this.getPeriod(), new AttributeMeta[0]);
    }

    public static class PeriodBoundBuilderImpl
    implements PeriodBoundBuilder {
        protected Boolean inclusive;
        protected Period.PeriodBuilder period;

        @Override
        public Boolean getInclusive() {
            return this.inclusive;
        }

        @Override
        public Period.PeriodBuilder getPeriod() {
            return this.period;
        }

        @Override
        public Period.PeriodBuilder getOrCreatePeriod() {
            Period.PeriodBuilder result = this.period != null ? this.period : (this.period = Period.builder());
            return result;
        }

        @Override
        public PeriodBoundBuilder setInclusive(Boolean inclusive) {
            this.inclusive = inclusive == null ? null : inclusive;
            return this;
        }

        @Override
        public PeriodBoundBuilder setPeriod(Period period) {
            this.period = period == null ? null : period.toBuilder();
            return this;
        }

        @Override
        public PeriodBound build() {
            return new PeriodBoundImpl(this);
        }

        @Override
        public PeriodBoundBuilder toBuilder() {
            return this;
        }

        @Override
        public PeriodBoundBuilder prune() {
            if (this.period != null && !this.period.prune().hasData()) {
                this.period = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getInclusive() != null) {
                return true;
            }
            return this.getPeriod() != null && this.getPeriod().hasData();
        }

        public PeriodBoundBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PeriodBoundBuilder o = (PeriodBoundBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriod(), (RosettaModelObjectBuilder)o.getPeriod(), this::setPeriod);
            merger.mergeBasic((Object)this.getInclusive(), (Object)o.getInclusive(), this::setInclusive, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PeriodBound _that = this.getType().cast(o);
            if (!Objects.equals(this.inclusive, _that.getInclusive())) {
                return false;
            }
            return Objects.equals(this.period, _that.getPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.inclusive != null ? this.inclusive.hashCode() : 0);
            _result = 31 * _result + (this.period != null ? this.period.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PeriodBoundBuilder {inclusive=" + this.inclusive + ", period=" + this.period + '}';
        }
    }

    public static class PeriodBoundImpl
    implements PeriodBound {
        private final Boolean inclusive;
        private final Period period;

        protected PeriodBoundImpl(PeriodBoundBuilder builder) {
            this.inclusive = builder.getInclusive();
            this.period = Optional.ofNullable(builder.getPeriod()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Boolean getInclusive() {
            return this.inclusive;
        }

        @Override
        public Period getPeriod() {
            return this.period;
        }

        @Override
        public PeriodBound build() {
            return this;
        }

        @Override
        public PeriodBoundBuilder toBuilder() {
            PeriodBoundBuilder builder = PeriodBound.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PeriodBoundBuilder builder) {
            Optional.ofNullable(this.getInclusive()).ifPresent(builder::setInclusive);
            Optional.ofNullable(this.getPeriod()).ifPresent(builder::setPeriod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PeriodBound _that = this.getType().cast(o);
            if (!Objects.equals(this.inclusive, _that.getInclusive())) {
                return false;
            }
            return Objects.equals(this.period, _that.getPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.inclusive != null ? this.inclusive.hashCode() : 0);
            _result = 31 * _result + (this.period != null ? this.period.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PeriodBound {inclusive=" + this.inclusive + ", period=" + this.period + '}';
        }
    }

    public static interface PeriodBoundBuilder
    extends PeriodBound,
    RosettaModelObjectBuilder {
        public Period.PeriodBuilder getOrCreatePeriod();

        @Override
        public Period.PeriodBuilder getPeriod();

        public PeriodBoundBuilder setInclusive(Boolean var1);

        public PeriodBoundBuilder setPeriod(Period var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("inclusive"), Boolean.class, (Object)this.getInclusive(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("period"), processor, Period.PeriodBuilder.class, this.getPeriod(), new AttributeMeta[0]);
        }

        public PeriodBoundBuilder prune();
    }
}

