/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.BusinessCenterTime;
import cdm.base.datetime.DayOfWeekEnum;
import cdm.base.datetime.Period;
import cdm.base.datetime.meta.CalculationFrequencyMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CalculationFrequency
extends RosettaModelObject {
    public static final CalculationFrequencyMeta metaData = new CalculationFrequencyMeta();

    public CalculationFrequency build();

    public CalculationFrequencyBuilder toBuilder();

    public List<BusinessCenterEnum> getBusinessCenter();

    public BusinessCenterTime getDateLocation();

    public BigDecimal getDayOfMonth();

    public DayOfWeekEnum getDayOfWeek();

    public BigDecimal getMonthOfYear();

    public BigDecimal getOffsetDays();

    public Period getPeriod();

    public BigDecimal getWeekOfMonth();

    default public RosettaMetaData<? extends CalculationFrequency> metaData() {
        return metaData;
    }

    public static CalculationFrequencyBuilder builder() {
        return new CalculationFrequencyBuilderImpl();
    }

    default public Class<? extends CalculationFrequency> getType() {
        return CalculationFrequency.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("businessCenter"), BusinessCenterEnum.class, this.getBusinessCenter(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayOfMonth"), BigDecimal.class, (Object)this.getDayOfMonth(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayOfWeek"), DayOfWeekEnum.class, (Object)this.getDayOfWeek(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("monthOfYear"), BigDecimal.class, (Object)this.getMonthOfYear(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("offsetDays"), BigDecimal.class, (Object)this.getOffsetDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("weekOfMonth"), BigDecimal.class, (Object)this.getWeekOfMonth(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateLocation"), processor, BusinessCenterTime.class, this.getDateLocation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("period"), processor, Period.class, this.getPeriod(), new AttributeMeta[0]);
    }

    public static class CalculationFrequencyBuilderImpl
    implements CalculationFrequencyBuilder {
        protected List<BusinessCenterEnum> businessCenter = new ArrayList<BusinessCenterEnum>();
        protected BusinessCenterTime.BusinessCenterTimeBuilder dateLocation;
        protected BigDecimal dayOfMonth;
        protected DayOfWeekEnum dayOfWeek;
        protected BigDecimal monthOfYear;
        protected BigDecimal offsetDays;
        protected Period.PeriodBuilder period;
        protected BigDecimal weekOfMonth;

        @Override
        public List<BusinessCenterEnum> getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getDateLocation() {
            return this.dateLocation;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateDateLocation() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.dateLocation != null ? this.dateLocation : (this.dateLocation = BusinessCenterTime.builder());
            return result;
        }

        @Override
        public BigDecimal getDayOfMonth() {
            return this.dayOfMonth;
        }

        @Override
        public DayOfWeekEnum getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        public BigDecimal getMonthOfYear() {
            return this.monthOfYear;
        }

        @Override
        public BigDecimal getOffsetDays() {
            return this.offsetDays;
        }

        @Override
        public Period.PeriodBuilder getPeriod() {
            return this.period;
        }

        @Override
        public Period.PeriodBuilder getOrCreatePeriod() {
            Period.PeriodBuilder result = this.period != null ? this.period : (this.period = Period.builder());
            return result;
        }

        @Override
        public BigDecimal getWeekOfMonth() {
            return this.weekOfMonth;
        }

        @Override
        public CalculationFrequencyBuilder addBusinessCenter(BusinessCenterEnum businessCenter) {
            if (businessCenter != null) {
                this.businessCenter.add(businessCenter);
            }
            return this;
        }

        @Override
        public CalculationFrequencyBuilder addBusinessCenter(BusinessCenterEnum businessCenter, int _idx) {
            this.getIndex(this.businessCenter, _idx, () -> businessCenter);
            return this;
        }

        @Override
        public CalculationFrequencyBuilder addBusinessCenter(List<? extends BusinessCenterEnum> businessCenters) {
            if (businessCenters != null) {
                for (BusinessCenterEnum businessCenterEnum : businessCenters) {
                    this.businessCenter.add(businessCenterEnum);
                }
            }
            return this;
        }

        @Override
        public CalculationFrequencyBuilder setBusinessCenter(List<? extends BusinessCenterEnum> businessCenters) {
            this.businessCenter = businessCenters == null ? new ArrayList<BusinessCenterEnum>() : (List)businessCenters.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculationFrequencyBuilder setDateLocation(BusinessCenterTime dateLocation) {
            this.dateLocation = dateLocation == null ? null : dateLocation.toBuilder();
            return this;
        }

        @Override
        public CalculationFrequencyBuilder setDayOfMonth(BigDecimal dayOfMonth) {
            this.dayOfMonth = dayOfMonth == null ? null : dayOfMonth;
            return this;
        }

        @Override
        public CalculationFrequencyBuilder setDayOfWeek(DayOfWeekEnum dayOfWeek) {
            this.dayOfWeek = dayOfWeek == null ? null : dayOfWeek;
            return this;
        }

        @Override
        public CalculationFrequencyBuilder setMonthOfYear(BigDecimal monthOfYear) {
            this.monthOfYear = monthOfYear == null ? null : monthOfYear;
            return this;
        }

        @Override
        public CalculationFrequencyBuilder setOffsetDays(BigDecimal offsetDays) {
            this.offsetDays = offsetDays == null ? null : offsetDays;
            return this;
        }

        @Override
        public CalculationFrequencyBuilder setPeriod(Period period) {
            this.period = period == null ? null : period.toBuilder();
            return this;
        }

        @Override
        public CalculationFrequencyBuilder setWeekOfMonth(BigDecimal weekOfMonth) {
            this.weekOfMonth = weekOfMonth == null ? null : weekOfMonth;
            return this;
        }

        @Override
        public CalculationFrequency build() {
            return new CalculationFrequencyImpl(this);
        }

        @Override
        public CalculationFrequencyBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculationFrequencyBuilder prune() {
            if (this.dateLocation != null && !this.dateLocation.prune().hasData()) {
                this.dateLocation = null;
            }
            if (this.period != null && !this.period.prune().hasData()) {
                this.period = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBusinessCenter() != null && !this.getBusinessCenter().isEmpty()) {
                return true;
            }
            if (this.getDateLocation() != null && this.getDateLocation().hasData()) {
                return true;
            }
            if (this.getDayOfMonth() != null) {
                return true;
            }
            if (this.getDayOfWeek() != null) {
                return true;
            }
            if (this.getMonthOfYear() != null) {
                return true;
            }
            if (this.getOffsetDays() != null) {
                return true;
            }
            if (this.getPeriod() != null && this.getPeriod().hasData()) {
                return true;
            }
            return this.getWeekOfMonth() != null;
        }

        public CalculationFrequencyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CalculationFrequencyBuilder o = (CalculationFrequencyBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateLocation(), (RosettaModelObjectBuilder)o.getDateLocation(), this::setDateLocation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriod(), (RosettaModelObjectBuilder)o.getPeriod(), this::setPeriod);
            merger.mergeBasic(this.getBusinessCenter(), o.getBusinessCenter(), this::addBusinessCenter);
            merger.mergeBasic((Object)this.getDayOfMonth(), (Object)o.getDayOfMonth(), this::setDayOfMonth, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayOfWeek(), (Object)o.getDayOfWeek(), this::setDayOfWeek, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMonthOfYear(), (Object)o.getMonthOfYear(), this::setMonthOfYear, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOffsetDays(), (Object)o.getOffsetDays(), this::setOffsetDays, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getWeekOfMonth(), (Object)o.getWeekOfMonth(), this::setWeekOfMonth, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculationFrequency _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.businessCenter, _that.getBusinessCenter())) {
                return false;
            }
            if (!Objects.equals(this.dateLocation, _that.getDateLocation())) {
                return false;
            }
            if (!Objects.equals(this.dayOfMonth, _that.getDayOfMonth())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayOfWeek, (Object)_that.getDayOfWeek())) {
                return false;
            }
            if (!Objects.equals(this.monthOfYear, _that.getMonthOfYear())) {
                return false;
            }
            if (!Objects.equals(this.offsetDays, _that.getOffsetDays())) {
                return false;
            }
            if (!Objects.equals(this.period, _that.getPeriod())) {
                return false;
            }
            return Objects.equals(this.weekOfMonth, _that.getWeekOfMonth());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.businessCenter != null ? this.businessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.dateLocation != null ? this.dateLocation.hashCode() : 0);
            _result = 31 * _result + (this.dayOfMonth != null ? this.dayOfMonth.hashCode() : 0);
            _result = 31 * _result + (this.dayOfWeek != null ? ((Object)((Object)this.dayOfWeek)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.monthOfYear != null ? this.monthOfYear.hashCode() : 0);
            _result = 31 * _result + (this.offsetDays != null ? this.offsetDays.hashCode() : 0);
            _result = 31 * _result + (this.period != null ? this.period.hashCode() : 0);
            _result = 31 * _result + (this.weekOfMonth != null ? this.weekOfMonth.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculationFrequencyBuilder {businessCenter=" + this.businessCenter + ", dateLocation=" + this.dateLocation + ", dayOfMonth=" + this.dayOfMonth + ", dayOfWeek=" + (Object)((Object)this.dayOfWeek) + ", monthOfYear=" + this.monthOfYear + ", offsetDays=" + this.offsetDays + ", period=" + this.period + ", weekOfMonth=" + this.weekOfMonth + '}';
        }
    }

    public static class CalculationFrequencyImpl
    implements CalculationFrequency {
        private final List<BusinessCenterEnum> businessCenter;
        private final BusinessCenterTime dateLocation;
        private final BigDecimal dayOfMonth;
        private final DayOfWeekEnum dayOfWeek;
        private final BigDecimal monthOfYear;
        private final BigDecimal offsetDays;
        private final Period period;
        private final BigDecimal weekOfMonth;

        protected CalculationFrequencyImpl(CalculationFrequencyBuilder builder) {
            this.businessCenter = Optional.ofNullable(builder.getBusinessCenter()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.dateLocation = Optional.ofNullable(builder.getDateLocation()).map(f -> f.build()).orElse(null);
            this.dayOfMonth = builder.getDayOfMonth();
            this.dayOfWeek = builder.getDayOfWeek();
            this.monthOfYear = builder.getMonthOfYear();
            this.offsetDays = builder.getOffsetDays();
            this.period = Optional.ofNullable(builder.getPeriod()).map(f -> f.build()).orElse(null);
            this.weekOfMonth = builder.getWeekOfMonth();
        }

        @Override
        public List<BusinessCenterEnum> getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        public BusinessCenterTime getDateLocation() {
            return this.dateLocation;
        }

        @Override
        public BigDecimal getDayOfMonth() {
            return this.dayOfMonth;
        }

        @Override
        public DayOfWeekEnum getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        public BigDecimal getMonthOfYear() {
            return this.monthOfYear;
        }

        @Override
        public BigDecimal getOffsetDays() {
            return this.offsetDays;
        }

        @Override
        public Period getPeriod() {
            return this.period;
        }

        @Override
        public BigDecimal getWeekOfMonth() {
            return this.weekOfMonth;
        }

        @Override
        public CalculationFrequency build() {
            return this;
        }

        @Override
        public CalculationFrequencyBuilder toBuilder() {
            CalculationFrequencyBuilder builder = CalculationFrequency.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculationFrequencyBuilder builder) {
            Optional.ofNullable(this.getBusinessCenter()).ifPresent(builder::setBusinessCenter);
            Optional.ofNullable(this.getDateLocation()).ifPresent(builder::setDateLocation);
            Optional.ofNullable(this.getDayOfMonth()).ifPresent(builder::setDayOfMonth);
            Optional.ofNullable(this.getDayOfWeek()).ifPresent(builder::setDayOfWeek);
            Optional.ofNullable(this.getMonthOfYear()).ifPresent(builder::setMonthOfYear);
            Optional.ofNullable(this.getOffsetDays()).ifPresent(builder::setOffsetDays);
            Optional.ofNullable(this.getPeriod()).ifPresent(builder::setPeriod);
            Optional.ofNullable(this.getWeekOfMonth()).ifPresent(builder::setWeekOfMonth);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculationFrequency _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.businessCenter, _that.getBusinessCenter())) {
                return false;
            }
            if (!Objects.equals(this.dateLocation, _that.getDateLocation())) {
                return false;
            }
            if (!Objects.equals(this.dayOfMonth, _that.getDayOfMonth())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayOfWeek, (Object)_that.getDayOfWeek())) {
                return false;
            }
            if (!Objects.equals(this.monthOfYear, _that.getMonthOfYear())) {
                return false;
            }
            if (!Objects.equals(this.offsetDays, _that.getOffsetDays())) {
                return false;
            }
            if (!Objects.equals(this.period, _that.getPeriod())) {
                return false;
            }
            return Objects.equals(this.weekOfMonth, _that.getWeekOfMonth());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.businessCenter != null ? this.businessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.dateLocation != null ? this.dateLocation.hashCode() : 0);
            _result = 31 * _result + (this.dayOfMonth != null ? this.dayOfMonth.hashCode() : 0);
            _result = 31 * _result + (this.dayOfWeek != null ? ((Object)((Object)this.dayOfWeek)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.monthOfYear != null ? this.monthOfYear.hashCode() : 0);
            _result = 31 * _result + (this.offsetDays != null ? this.offsetDays.hashCode() : 0);
            _result = 31 * _result + (this.period != null ? this.period.hashCode() : 0);
            _result = 31 * _result + (this.weekOfMonth != null ? this.weekOfMonth.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculationFrequency {businessCenter=" + this.businessCenter + ", dateLocation=" + this.dateLocation + ", dayOfMonth=" + this.dayOfMonth + ", dayOfWeek=" + (Object)((Object)this.dayOfWeek) + ", monthOfYear=" + this.monthOfYear + ", offsetDays=" + this.offsetDays + ", period=" + this.period + ", weekOfMonth=" + this.weekOfMonth + '}';
        }
    }

    public static interface CalculationFrequencyBuilder
    extends CalculationFrequency,
    RosettaModelObjectBuilder {
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateDateLocation();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getDateLocation();

        public Period.PeriodBuilder getOrCreatePeriod();

        @Override
        public Period.PeriodBuilder getPeriod();

        public CalculationFrequencyBuilder addBusinessCenter(BusinessCenterEnum var1);

        public CalculationFrequencyBuilder addBusinessCenter(BusinessCenterEnum var1, int var2);

        public CalculationFrequencyBuilder addBusinessCenter(List<? extends BusinessCenterEnum> var1);

        public CalculationFrequencyBuilder setBusinessCenter(List<? extends BusinessCenterEnum> var1);

        public CalculationFrequencyBuilder setDateLocation(BusinessCenterTime var1);

        public CalculationFrequencyBuilder setDayOfMonth(BigDecimal var1);

        public CalculationFrequencyBuilder setDayOfWeek(DayOfWeekEnum var1);

        public CalculationFrequencyBuilder setMonthOfYear(BigDecimal var1);

        public CalculationFrequencyBuilder setOffsetDays(BigDecimal var1);

        public CalculationFrequencyBuilder setPeriod(Period var1);

        public CalculationFrequencyBuilder setWeekOfMonth(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("businessCenter"), BusinessCenterEnum.class, this.getBusinessCenter(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayOfMonth"), BigDecimal.class, (Object)this.getDayOfMonth(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayOfWeek"), DayOfWeekEnum.class, (Object)this.getDayOfWeek(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("monthOfYear"), BigDecimal.class, (Object)this.getMonthOfYear(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("offsetDays"), BigDecimal.class, (Object)this.getOffsetDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("weekOfMonth"), BigDecimal.class, (Object)this.getWeekOfMonth(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateLocation"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getDateLocation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("period"), processor, Period.PeriodBuilder.class, this.getPeriod(), new AttributeMeta[0]);
        }

        public CalculationFrequencyBuilder prune();
    }
}

