/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.BusinessDayConventionEnum;
import cdm.base.datetime.DateRange;
import cdm.base.datetime.meta.BusinessDateRangeMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface BusinessDateRange
extends DateRange {
    public static final BusinessDateRangeMeta metaData = new BusinessDateRangeMeta();

    @Override
    public BusinessDateRange build();

    @Override
    public BusinessDateRangeBuilder toBuilder();

    public BusinessCenters getBusinessCenters();

    public BusinessDayConventionEnum getBusinessDayConvention();

    default public RosettaMetaData<? extends BusinessDateRange> metaData() {
        return metaData;
    }

    public static BusinessDateRangeBuilder builder() {
        return new BusinessDateRangeBuilderImpl();
    }

    default public Class<? extends BusinessDateRange> getType() {
        return BusinessDateRange.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        DateRange.super.process(path, processor);
        processor.processBasic(path.newSubPath("businessDayConvention"), BusinessDayConventionEnum.class, (Object)this.getBusinessDayConvention(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessCenters"), processor, BusinessCenters.class, this.getBusinessCenters(), new AttributeMeta[0]);
    }

    public static class BusinessDateRangeBuilderImpl
    extends DateRange.DateRangeBuilderImpl
    implements BusinessDateRangeBuilder {
        protected BusinessCenters.BusinessCentersBuilder businessCenters;
        protected BusinessDayConventionEnum businessDayConvention;

        @Override
        public BusinessCenters.BusinessCentersBuilder getBusinessCenters() {
            return this.businessCenters;
        }

        @Override
        public BusinessCenters.BusinessCentersBuilder getOrCreateBusinessCenters() {
            BusinessCenters.BusinessCentersBuilder result = this.businessCenters != null ? this.businessCenters : (this.businessCenters = BusinessCenters.builder());
            return result;
        }

        @Override
        public BusinessDayConventionEnum getBusinessDayConvention() {
            return this.businessDayConvention;
        }

        @Override
        public BusinessDateRangeBuilder setBusinessCenters(BusinessCenters businessCenters) {
            this.businessCenters = businessCenters == null ? null : businessCenters.toBuilder();
            return this;
        }

        @Override
        public BusinessDateRangeBuilder setBusinessDayConvention(BusinessDayConventionEnum businessDayConvention) {
            this.businessDayConvention = businessDayConvention == null ? null : businessDayConvention;
            return this;
        }

        @Override
        public BusinessDateRangeBuilder setEndDate(Date endDate) {
            this.endDate = endDate == null ? null : endDate;
            return this;
        }

        @Override
        public BusinessDateRangeBuilder setStartDate(Date startDate) {
            this.startDate = startDate == null ? null : startDate;
            return this;
        }

        @Override
        public BusinessDateRange build() {
            return new BusinessDateRangeImpl(this);
        }

        @Override
        public BusinessDateRangeBuilder toBuilder() {
            return this;
        }

        @Override
        public BusinessDateRangeBuilder prune() {
            super.prune();
            if (this.businessCenters != null && !this.businessCenters.prune().hasData()) {
                this.businessCenters = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBusinessCenters() != null && this.getBusinessCenters().hasData()) {
                return true;
            }
            return this.getBusinessDayConvention() != null;
        }

        @Override
        public BusinessDateRangeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BusinessDateRangeBuilder o = (BusinessDateRangeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessCenters(), (RosettaModelObjectBuilder)o.getBusinessCenters(), this::setBusinessCenters);
            merger.mergeBasic((Object)this.getBusinessDayConvention(), (Object)o.getBusinessDayConvention(), this::setBusinessDayConvention, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BusinessDateRange _that = (BusinessDateRange)this.getType().cast(o);
            if (!Objects.equals(this.businessCenters, _that.getBusinessCenters())) {
                return false;
            }
            return Objects.equals((Object)this.businessDayConvention, (Object)_that.getBusinessDayConvention());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.businessCenters != null ? this.businessCenters.hashCode() : 0);
            _result = 31 * _result + (this.businessDayConvention != null ? ((Object)((Object)this.businessDayConvention)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BusinessDateRangeBuilder {businessCenters=" + this.businessCenters + ", businessDayConvention=" + (Object)((Object)this.businessDayConvention) + '}' + " " + super.toString();
        }
    }

    public static class BusinessDateRangeImpl
    extends DateRange.DateRangeImpl
    implements BusinessDateRange {
        private final BusinessCenters businessCenters;
        private final BusinessDayConventionEnum businessDayConvention;

        protected BusinessDateRangeImpl(BusinessDateRangeBuilder builder) {
            super(builder);
            this.businessCenters = Optional.ofNullable(builder.getBusinessCenters()).map(f -> f.build()).orElse(null);
            this.businessDayConvention = builder.getBusinessDayConvention();
        }

        @Override
        public BusinessCenters getBusinessCenters() {
            return this.businessCenters;
        }

        @Override
        public BusinessDayConventionEnum getBusinessDayConvention() {
            return this.businessDayConvention;
        }

        @Override
        public BusinessDateRange build() {
            return this;
        }

        @Override
        public BusinessDateRangeBuilder toBuilder() {
            BusinessDateRangeBuilder builder = BusinessDateRange.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BusinessDateRangeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBusinessCenters()).ifPresent(builder::setBusinessCenters);
            Optional.ofNullable(this.getBusinessDayConvention()).ifPresent(builder::setBusinessDayConvention);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BusinessDateRange _that = (BusinessDateRange)this.getType().cast(o);
            if (!Objects.equals(this.businessCenters, _that.getBusinessCenters())) {
                return false;
            }
            return Objects.equals((Object)this.businessDayConvention, (Object)_that.getBusinessDayConvention());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.businessCenters != null ? this.businessCenters.hashCode() : 0);
            _result = 31 * _result + (this.businessDayConvention != null ? ((Object)((Object)this.businessDayConvention)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BusinessDateRange {businessCenters=" + this.businessCenters + ", businessDayConvention=" + (Object)((Object)this.businessDayConvention) + '}' + " " + super.toString();
        }
    }

    public static interface BusinessDateRangeBuilder
    extends BusinessDateRange,
    DateRange.DateRangeBuilder,
    RosettaModelObjectBuilder {
        public BusinessCenters.BusinessCentersBuilder getOrCreateBusinessCenters();

        @Override
        public BusinessCenters.BusinessCentersBuilder getBusinessCenters();

        public BusinessDateRangeBuilder setBusinessCenters(BusinessCenters var1);

        public BusinessDateRangeBuilder setBusinessDayConvention(BusinessDayConventionEnum var1);

        @Override
        public BusinessDateRangeBuilder setEndDate(Date var1);

        @Override
        public BusinessDateRangeBuilder setStartDate(Date var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            DateRange.DateRangeBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("businessDayConvention"), BusinessDayConventionEnum.class, (Object)this.getBusinessDayConvention(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessCenters"), processor, BusinessCenters.BusinessCentersBuilder.class, this.getBusinessCenters(), new AttributeMeta[0]);
        }

        @Override
        public BusinessDateRangeBuilder prune();
    }
}

