/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.CalculationPeriodFrequency;
import cdm.base.datetime.meta.AveragingScheduleMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface AveragingSchedule
extends RosettaModelObject {
    public static final AveragingScheduleMeta metaData = new AveragingScheduleMeta();

    public AveragingSchedule build();

    public AveragingScheduleBuilder toBuilder();

    public CalculationPeriodFrequency getAveragingPeriodFrequency();

    public Date getEndDate();

    public Date getStartDate();

    default public RosettaMetaData<? extends AveragingSchedule> metaData() {
        return metaData;
    }

    public static AveragingScheduleBuilder builder() {
        return new AveragingScheduleBuilderImpl();
    }

    default public Class<? extends AveragingSchedule> getType() {
        return AveragingSchedule.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("endDate"), Date.class, (Object)this.getEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("startDate"), Date.class, (Object)this.getStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averagingPeriodFrequency"), processor, CalculationPeriodFrequency.class, this.getAveragingPeriodFrequency(), new AttributeMeta[0]);
    }

    public static class AveragingScheduleBuilderImpl
    implements AveragingScheduleBuilder {
        protected CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder averagingPeriodFrequency;
        protected Date endDate;
        protected Date startDate;

        @Override
        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getAveragingPeriodFrequency() {
            return this.averagingPeriodFrequency;
        }

        @Override
        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getOrCreateAveragingPeriodFrequency() {
            CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder result = this.averagingPeriodFrequency != null ? this.averagingPeriodFrequency : (this.averagingPeriodFrequency = CalculationPeriodFrequency.builder());
            return result;
        }

        @Override
        public Date getEndDate() {
            return this.endDate;
        }

        @Override
        public Date getStartDate() {
            return this.startDate;
        }

        @Override
        public AveragingScheduleBuilder setAveragingPeriodFrequency(CalculationPeriodFrequency averagingPeriodFrequency) {
            this.averagingPeriodFrequency = averagingPeriodFrequency == null ? null : averagingPeriodFrequency.toBuilder();
            return this;
        }

        @Override
        public AveragingScheduleBuilder setEndDate(Date endDate) {
            this.endDate = endDate == null ? null : endDate;
            return this;
        }

        @Override
        public AveragingScheduleBuilder setStartDate(Date startDate) {
            this.startDate = startDate == null ? null : startDate;
            return this;
        }

        @Override
        public AveragingSchedule build() {
            return new AveragingScheduleImpl(this);
        }

        @Override
        public AveragingScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public AveragingScheduleBuilder prune() {
            if (this.averagingPeriodFrequency != null && !this.averagingPeriodFrequency.prune().hasData()) {
                this.averagingPeriodFrequency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAveragingPeriodFrequency() != null && this.getAveragingPeriodFrequency().hasData()) {
                return true;
            }
            if (this.getEndDate() != null) {
                return true;
            }
            return this.getStartDate() != null;
        }

        public AveragingScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AveragingScheduleBuilder o = (AveragingScheduleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingPeriodFrequency(), (RosettaModelObjectBuilder)o.getAveragingPeriodFrequency(), this::setAveragingPeriodFrequency);
            merger.mergeBasic((Object)this.getEndDate(), (Object)o.getEndDate(), this::setEndDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStartDate(), (Object)o.getStartDate(), this::setStartDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AveragingSchedule _that = this.getType().cast(o);
            if (!Objects.equals(this.averagingPeriodFrequency, _that.getAveragingPeriodFrequency())) {
                return false;
            }
            if (!Objects.equals(this.endDate, _that.getEndDate())) {
                return false;
            }
            return Objects.equals(this.startDate, _that.getStartDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.averagingPeriodFrequency != null ? this.averagingPeriodFrequency.hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AveragingScheduleBuilder {averagingPeriodFrequency=" + this.averagingPeriodFrequency + ", endDate=" + this.endDate + ", startDate=" + this.startDate + '}';
        }
    }

    public static class AveragingScheduleImpl
    implements AveragingSchedule {
        private final CalculationPeriodFrequency averagingPeriodFrequency;
        private final Date endDate;
        private final Date startDate;

        protected AveragingScheduleImpl(AveragingScheduleBuilder builder) {
            this.averagingPeriodFrequency = Optional.ofNullable(builder.getAveragingPeriodFrequency()).map(f -> f.build()).orElse(null);
            this.endDate = builder.getEndDate();
            this.startDate = builder.getStartDate();
        }

        @Override
        public CalculationPeriodFrequency getAveragingPeriodFrequency() {
            return this.averagingPeriodFrequency;
        }

        @Override
        public Date getEndDate() {
            return this.endDate;
        }

        @Override
        public Date getStartDate() {
            return this.startDate;
        }

        @Override
        public AveragingSchedule build() {
            return this;
        }

        @Override
        public AveragingScheduleBuilder toBuilder() {
            AveragingScheduleBuilder builder = AveragingSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AveragingScheduleBuilder builder) {
            Optional.ofNullable(this.getAveragingPeriodFrequency()).ifPresent(builder::setAveragingPeriodFrequency);
            Optional.ofNullable(this.getEndDate()).ifPresent(builder::setEndDate);
            Optional.ofNullable(this.getStartDate()).ifPresent(builder::setStartDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AveragingSchedule _that = this.getType().cast(o);
            if (!Objects.equals(this.averagingPeriodFrequency, _that.getAveragingPeriodFrequency())) {
                return false;
            }
            if (!Objects.equals(this.endDate, _that.getEndDate())) {
                return false;
            }
            return Objects.equals(this.startDate, _that.getStartDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.averagingPeriodFrequency != null ? this.averagingPeriodFrequency.hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AveragingSchedule {averagingPeriodFrequency=" + this.averagingPeriodFrequency + ", endDate=" + this.endDate + ", startDate=" + this.startDate + '}';
        }
    }

    public static interface AveragingScheduleBuilder
    extends AveragingSchedule,
    RosettaModelObjectBuilder {
        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getOrCreateAveragingPeriodFrequency();

        @Override
        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getAveragingPeriodFrequency();

        public AveragingScheduleBuilder setAveragingPeriodFrequency(CalculationPeriodFrequency var1);

        public AveragingScheduleBuilder setEndDate(Date var1);

        public AveragingScheduleBuilder setStartDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("endDate"), Date.class, (Object)this.getEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("startDate"), Date.class, (Object)this.getStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averagingPeriodFrequency"), processor, CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder.class, this.getAveragingPeriodFrequency(), new AttributeMeta[0]);
        }

        public AveragingScheduleBuilder prune();
    }
}

